// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        (unknown)
// source: pbmesh/v2beta1/pbproxystate/listener.proto

package pbproxystate

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// +kubebuilder:validation:Enum=DIRECTION_UNSPECIFIED;DIRECTION_INBOUND;DIRECTION_OUTBOUND
// +kubebuilder:validation:Type=string
type Direction int32

const (
	// DIRECTION_UNSPECIFIED is used by mesh gateway listeners.
	Direction_DIRECTION_UNSPECIFIED Direction = 0
	Direction_DIRECTION_INBOUND     Direction = 1
	Direction_DIRECTION_OUTBOUND    Direction = 2
)

// Enum value maps for Direction.
var (
	Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "DIRECTION_INBOUND",
		2: "DIRECTION_OUTBOUND",
	}
	Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"DIRECTION_INBOUND":     1,
		"DIRECTION_OUTBOUND":    2,
	}
)

func (x Direction) Enum() *Direction {
	p := new(Direction)
	*p = x
	return p
}

func (x Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[0].Descriptor()
}

func (Direction) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[0]
}

func (x Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Direction.Descriptor instead.
func (Direction) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{0}
}

// +kubebuilder:validation:Enum=BALANCE_CONNECTIONS_DEFAULT;BALANCE_CONNECTIONS_EXACT
// +kubebuilder:validation:Type=string
type BalanceConnections int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	BalanceConnections_BALANCE_CONNECTIONS_DEFAULT BalanceConnections = 0
	BalanceConnections_BALANCE_CONNECTIONS_EXACT   BalanceConnections = 1
)

// Enum value maps for BalanceConnections.
var (
	BalanceConnections_name = map[int32]string{
		0: "BALANCE_CONNECTIONS_DEFAULT",
		1: "BALANCE_CONNECTIONS_EXACT",
	}
	BalanceConnections_value = map[string]int32{
		"BALANCE_CONNECTIONS_DEFAULT": 0,
		"BALANCE_CONNECTIONS_EXACT":   1,
	}
)

func (x BalanceConnections) Enum() *BalanceConnections {
	p := new(BalanceConnections)
	*p = x
	return p
}

func (x BalanceConnections) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BalanceConnections) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[1].Descriptor()
}

func (BalanceConnections) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[1]
}

func (x BalanceConnections) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BalanceConnections.Descriptor instead.
func (BalanceConnections) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{1}
}

// Capabilities map to proxy functionality to enable. These enable tproxy, l7 protocol/alpn inspection, or l4 sni/alpn inspection.
//
// +kubebuilder:validation:Enum=CAPABILITY_TRANSPARENT;CAPABILITY_L7_PROTOCOL_INSPECTION;CAPABILITY_L4_TLS_INSPECTION
// +kubebuilder:validation:Type=string
type Capability int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	Capability_CAPABILITY_TRANSPARENT            Capability = 0
	Capability_CAPABILITY_L7_PROTOCOL_INSPECTION Capability = 1
	Capability_CAPABILITY_L4_TLS_INSPECTION      Capability = 2
)

// Enum value maps for Capability.
var (
	Capability_name = map[int32]string{
		0: "CAPABILITY_TRANSPARENT",
		1: "CAPABILITY_L7_PROTOCOL_INSPECTION",
		2: "CAPABILITY_L4_TLS_INSPECTION",
	}
	Capability_value = map[string]int32{
		"CAPABILITY_TRANSPARENT":            0,
		"CAPABILITY_L7_PROTOCOL_INSPECTION": 1,
		"CAPABILITY_L4_TLS_INSPECTION":      2,
	}
)

func (x Capability) Enum() *Capability {
	p := new(Capability)
	*p = x
	return p
}

func (x Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[2].Descriptor()
}

func (Capability) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[2]
}

func (x Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Capability.Descriptor instead.
func (Capability) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{2}
}

// +kubebuilder:validation:Enum=XFCC_POLICY_SANITIZE;XFCC_POLICY_FORWARD_ONLY;XFCC_POLICY_APPEND_FORWARD;XFCC_POLICY_SANITIZE_SET;XFCC_POLICY_ALWAYS_FORWARD_ONLY
// +kubebuilder:validation:Type=string
type XFCCPolicy int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	// Do not send the XFCC header to the next hop. This is the default value.
	XFCCPolicy_XFCC_POLICY_SANITIZE XFCCPolicy = 0
	// When the client connection is mTLS (Mutual TLS), forward the XFCC header
	// in the request.
	XFCCPolicy_XFCC_POLICY_FORWARD_ONLY XFCCPolicy = 1
	// When the client connection is mTLS, append the client certificate
	// information to the request’s XFCC header and forward it.
	XFCCPolicy_XFCC_POLICY_APPEND_FORWARD XFCCPolicy = 2
	// When the client connection is mTLS, reset the XFCC header with the client
	// certificate information and send it to the next hop.
	XFCCPolicy_XFCC_POLICY_SANITIZE_SET XFCCPolicy = 3
	// Always forward the XFCC header in the request, regardless of whether the
	// client connection is mTLS.
	XFCCPolicy_XFCC_POLICY_ALWAYS_FORWARD_ONLY XFCCPolicy = 4
)

// Enum value maps for XFCCPolicy.
var (
	XFCCPolicy_name = map[int32]string{
		0: "XFCC_POLICY_SANITIZE",
		1: "XFCC_POLICY_FORWARD_ONLY",
		2: "XFCC_POLICY_APPEND_FORWARD",
		3: "XFCC_POLICY_SANITIZE_SET",
		4: "XFCC_POLICY_ALWAYS_FORWARD_ONLY",
	}
	XFCCPolicy_value = map[string]int32{
		"XFCC_POLICY_SANITIZE":            0,
		"XFCC_POLICY_FORWARD_ONLY":        1,
		"XFCC_POLICY_APPEND_FORWARD":      2,
		"XFCC_POLICY_SANITIZE_SET":        3,
		"XFCC_POLICY_ALWAYS_FORWARD_ONLY": 4,
	}
)

func (x XFCCPolicy) Enum() *XFCCPolicy {
	p := new(XFCCPolicy)
	*p = x
	return p
}

func (x XFCCPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (XFCCPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[3].Descriptor()
}

func (XFCCPolicy) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[3]
}

func (x XFCCPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use XFCCPolicy.Descriptor instead.
func (XFCCPolicy) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{3}
}

// +kubebuilder:validation:Enum=L7_PROTOCOL_HTTP;L7_PROTOCOL_HTTP2;L7_PROTOCOL_GRPC
// +kubebuilder:validation:Type=string
type L7Protocol int32

const (
	// buf:lint:ignore ENUM_ZERO_VALUE_SUFFIX
	L7Protocol_L7_PROTOCOL_HTTP  L7Protocol = 0
	L7Protocol_L7_PROTOCOL_HTTP2 L7Protocol = 1
	L7Protocol_L7_PROTOCOL_GRPC  L7Protocol = 2
)

// Enum value maps for L7Protocol.
var (
	L7Protocol_name = map[int32]string{
		0: "L7_PROTOCOL_HTTP",
		1: "L7_PROTOCOL_HTTP2",
		2: "L7_PROTOCOL_GRPC",
	}
	L7Protocol_value = map[string]int32{
		"L7_PROTOCOL_HTTP":  0,
		"L7_PROTOCOL_HTTP2": 1,
		"L7_PROTOCOL_GRPC":  2,
	}
)

func (x L7Protocol) Enum() *L7Protocol {
	p := new(L7Protocol)
	*p = x
	return p
}

func (x L7Protocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (L7Protocol) Descriptor() protoreflect.EnumDescriptor {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[4].Descriptor()
}

func (L7Protocol) Type() protoreflect.EnumType {
	return &file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes[4]
}

func (x L7Protocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use L7Protocol.Descriptor instead.
func (L7Protocol) EnumDescriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{4}
}

type Listener struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is the name of the listener.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// direction tells the listener the direction of traffic.
	Direction Direction `protobuf:"varint,2,opt,name=direction,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.Direction" json:"direction,omitempty"`
	// bind_address describes where to listen.
	//
	// Types that are assignable to BindAddress:
	//
	//	*Listener_HostPort
	//	*Listener_UnixSocket
	BindAddress isListener_BindAddress `protobuf_oneof:"bind_address"`
	// routers describes how to route traffic from this listener.
	Routers []*Router `protobuf:"bytes,5,rep,name=routers,proto3" json:"routers,omitempty"`
	// default_router describes where to route if none of the other router matches match the connection.
	DefaultRouter *Router `protobuf:"bytes,6,opt,name=default_router,json=defaultRouter,proto3" json:"default_router,omitempty"`
	// capabilities describe Envoy proxy functionality to enable. These map closely to Envoy listener filters.
	Capabilities []Capability `protobuf:"varint,7,rep,packed,name=capabilities,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.Capability" json:"capabilities,omitempty"`
	// balance_connections configures how the listener should balance connections.
	BalanceConnections BalanceConnections `protobuf:"varint,8,opt,name=balance_connections,json=balanceConnections,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.BalanceConnections" json:"balance_connections,omitempty"`
	// escape_hatch_listener_json configures a user configured escape hatch listener.
	EscapeHatchListener string `protobuf:"bytes,9,opt,name=escape_hatch_listener,json=escapeHatchListener,proto3" json:"escape_hatch_listener,omitempty"`
	// use_escape_hatch_tracing configures whether to use the top level user configured tracing escape hatch for this listener.
	UseEscapeHatchTracing bool `protobuf:"varint,10,opt,name=use_escape_hatch_tracing,json=useEscapeHatchTracing,proto3" json:"use_escape_hatch_tracing,omitempty"`
}

func (x *Listener) Reset() {
	*x = Listener{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Listener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Listener) ProtoMessage() {}

func (x *Listener) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Listener.ProtoReflect.Descriptor instead.
func (*Listener) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{0}
}

func (x *Listener) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Listener) GetDirection() Direction {
	if x != nil {
		return x.Direction
	}
	return Direction_DIRECTION_UNSPECIFIED
}

func (m *Listener) GetBindAddress() isListener_BindAddress {
	if m != nil {
		return m.BindAddress
	}
	return nil
}

func (x *Listener) GetHostPort() *HostPortAddress {
	if x, ok := x.GetBindAddress().(*Listener_HostPort); ok {
		return x.HostPort
	}
	return nil
}

func (x *Listener) GetUnixSocket() *UnixSocketAddress {
	if x, ok := x.GetBindAddress().(*Listener_UnixSocket); ok {
		return x.UnixSocket
	}
	return nil
}

func (x *Listener) GetRouters() []*Router {
	if x != nil {
		return x.Routers
	}
	return nil
}

func (x *Listener) GetDefaultRouter() *Router {
	if x != nil {
		return x.DefaultRouter
	}
	return nil
}

func (x *Listener) GetCapabilities() []Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

func (x *Listener) GetBalanceConnections() BalanceConnections {
	if x != nil {
		return x.BalanceConnections
	}
	return BalanceConnections_BALANCE_CONNECTIONS_DEFAULT
}

func (x *Listener) GetEscapeHatchListener() string {
	if x != nil {
		return x.EscapeHatchListener
	}
	return ""
}

func (x *Listener) GetUseEscapeHatchTracing() bool {
	if x != nil {
		return x.UseEscapeHatchTracing
	}
	return false
}

type isListener_BindAddress interface {
	isListener_BindAddress()
}

type Listener_HostPort struct {
	HostPort *HostPortAddress `protobuf:"bytes,3,opt,name=host_port,json=hostPort,proto3,oneof"`
}

type Listener_UnixSocket struct {
	UnixSocket *UnixSocketAddress `protobuf:"bytes,4,opt,name=unix_socket,json=unixSocket,proto3,oneof"`
}

func (*Listener_HostPort) isListener_BindAddress() {}

func (*Listener_UnixSocket) isListener_BindAddress() {}

type Router struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// match specifies how to match traffic coming into this listener. If the traffic matches, it will be routed to the
	// destination.
	Match *Match `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// Types that are assignable to Destination:
	//
	//	*Router_L4
	//	*Router_L7
	//	*Router_Sni
	Destination isRouter_Destination `protobuf_oneof:"destination"`
	// inbound_tls is used by inbound listeners that terminate TLS.
	InboundTls *TransportSocket `protobuf:"bytes,5,opt,name=inbound_tls,json=inboundTls,proto3" json:"inbound_tls,omitempty"`
}

func (x *Router) Reset() {
	*x = Router{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Router) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Router) ProtoMessage() {}

func (x *Router) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Router.ProtoReflect.Descriptor instead.
func (*Router) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{1}
}

func (x *Router) GetMatch() *Match {
	if x != nil {
		return x.Match
	}
	return nil
}

func (m *Router) GetDestination() isRouter_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *Router) GetL4() *L4Destination {
	if x, ok := x.GetDestination().(*Router_L4); ok {
		return x.L4
	}
	return nil
}

func (x *Router) GetL7() *L7Destination {
	if x, ok := x.GetDestination().(*Router_L7); ok {
		return x.L7
	}
	return nil
}

func (x *Router) GetSni() *SNIDestination {
	if x, ok := x.GetDestination().(*Router_Sni); ok {
		return x.Sni
	}
	return nil
}

func (x *Router) GetInboundTls() *TransportSocket {
	if x != nil {
		return x.InboundTls
	}
	return nil
}

type isRouter_Destination interface {
	isRouter_Destination()
}

type Router_L4 struct {
	// l4 is an l4 destination to route to, which will have a reference to a cluster.
	L4 *L4Destination `protobuf:"bytes,2,opt,name=l4,proto3,oneof"`
}

type Router_L7 struct {
	// l7 is an l7 destination to route to, which will have a reference to a route.
	L7 *L7Destination `protobuf:"bytes,3,opt,name=l7,proto3,oneof"`
}

type Router_Sni struct {
	// sni is an SNI destination, which means there will be no references, but the SNI name will be tied to the cluster
	// name, so we should generate all clusters.
	Sni *SNIDestination `protobuf:"bytes,4,opt,name=sni,proto3,oneof"`
}

func (*Router_L4) isRouter_Destination() {}

func (*Router_L7) isRouter_Destination() {}

func (*Router_Sni) isRouter_Destination() {}

type Match struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AlpnProtocols      []string                `protobuf:"bytes,1,rep,name=alpn_protocols,json=alpnProtocols,proto3" json:"alpn_protocols,omitempty"`
	DestinationPort    *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=destination_port,json=destinationPort,proto3" json:"destination_port,omitempty"`
	PrefixRanges       []*CidrRange            `protobuf:"bytes,3,rep,name=prefix_ranges,json=prefixRanges,proto3" json:"prefix_ranges,omitempty"`
	SourcePrefixRanges []*CidrRange            `protobuf:"bytes,4,rep,name=source_prefix_ranges,json=sourcePrefixRanges,proto3" json:"source_prefix_ranges,omitempty"`
	// server_names matches based on SNI of the incoming request.
	ServerNames []string `protobuf:"bytes,5,rep,name=server_names,json=serverNames,proto3" json:"server_names,omitempty"`
}

func (x *Match) Reset() {
	*x = Match{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Match) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Match) ProtoMessage() {}

func (x *Match) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Match.ProtoReflect.Descriptor instead.
func (*Match) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{2}
}

func (x *Match) GetAlpnProtocols() []string {
	if x != nil {
		return x.AlpnProtocols
	}
	return nil
}

func (x *Match) GetDestinationPort() *wrapperspb.UInt32Value {
	if x != nil {
		return x.DestinationPort
	}
	return nil
}

func (x *Match) GetPrefixRanges() []*CidrRange {
	if x != nil {
		return x.PrefixRanges
	}
	return nil
}

func (x *Match) GetSourcePrefixRanges() []*CidrRange {
	if x != nil {
		return x.SourcePrefixRanges
	}
	return nil
}

func (x *Match) GetServerNames() []string {
	if x != nil {
		return x.ServerNames
	}
	return nil
}

type CidrRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AddressPrefix string                  `protobuf:"bytes,1,opt,name=address_prefix,json=addressPrefix,proto3" json:"address_prefix,omitempty"`
	PrefixLen     *wrapperspb.UInt32Value `protobuf:"bytes,2,opt,name=prefix_len,json=prefixLen,proto3" json:"prefix_len,omitempty"`
}

func (x *CidrRange) Reset() {
	*x = CidrRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CidrRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CidrRange) ProtoMessage() {}

func (x *CidrRange) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CidrRange.ProtoReflect.Descriptor instead.
func (*CidrRange) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{3}
}

func (x *CidrRange) GetAddressPrefix() string {
	if x != nil {
		return x.AddressPrefix
	}
	return ""
}

func (x *CidrRange) GetPrefixLen() *wrapperspb.UInt32Value {
	if x != nil {
		return x.PrefixLen
	}
	return nil
}

type L4Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// destination is one or more clusters to route to.
	//
	// Types that are assignable to Destination:
	//
	//	*L4Destination_Cluster
	//	*L4Destination_WeightedClusters
	Destination isL4Destination_Destination `protobuf_oneof:"destination"`
	// stat_prefix is for compatibility with v1 xds configuration, so it is generated in exactly the same way.
	StatPrefix string `protobuf:"bytes,3,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// traffic_permissions is a list of traffic permissions for this destination.
	TrafficPermissions *TrafficPermissions `protobuf:"bytes,4,opt,name=traffic_permissions,json=trafficPermissions,proto3" json:"traffic_permissions,omitempty"`
	// max_inbound_connections specifies how many connections this destination can accept.
	MaxInboundConnections uint64 `protobuf:"varint,5,opt,name=max_inbound_connections,json=maxInboundConnections,proto3" json:"max_inbound_connections,omitempty"`
}

func (x *L4Destination) Reset() {
	*x = L4Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L4Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L4Destination) ProtoMessage() {}

func (x *L4Destination) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L4Destination.ProtoReflect.Descriptor instead.
func (*L4Destination) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{4}
}

func (m *L4Destination) GetDestination() isL4Destination_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *L4Destination) GetCluster() *DestinationCluster {
	if x, ok := x.GetDestination().(*L4Destination_Cluster); ok {
		return x.Cluster
	}
	return nil
}

func (x *L4Destination) GetWeightedClusters() *L4WeightedClusterGroup {
	if x, ok := x.GetDestination().(*L4Destination_WeightedClusters); ok {
		return x.WeightedClusters
	}
	return nil
}

func (x *L4Destination) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *L4Destination) GetTrafficPermissions() *TrafficPermissions {
	if x != nil {
		return x.TrafficPermissions
	}
	return nil
}

func (x *L4Destination) GetMaxInboundConnections() uint64 {
	if x != nil {
		return x.MaxInboundConnections
	}
	return 0
}

type isL4Destination_Destination interface {
	isL4Destination_Destination()
}

type L4Destination_Cluster struct {
	Cluster *DestinationCluster `protobuf:"bytes,1,opt,name=cluster,proto3,oneof"`
}

type L4Destination_WeightedClusters struct {
	WeightedClusters *L4WeightedClusterGroup `protobuf:"bytes,2,opt,name=weighted_clusters,json=weightedClusters,proto3,oneof"`
}

func (*L4Destination_Cluster) isL4Destination_Destination() {}

func (*L4Destination_WeightedClusters) isL4Destination_Destination() {}

type L7DestinationRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name is a key in the top level routes map. This specifies which route to go to in this L7 destination.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *L7DestinationRoute) Reset() {
	*x = L7DestinationRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7DestinationRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7DestinationRoute) ProtoMessage() {}

func (x *L7DestinationRoute) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7DestinationRoute.ProtoReflect.Descriptor instead.
func (*L7DestinationRoute) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{5}
}

func (x *L7DestinationRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type L7Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// route specifies which route to go to in this L7 destination.
	Route *L7DestinationRoute `protobuf:"bytes,1,opt,name=route,proto3" json:"route,omitempty"`
	// stat_prefix is for compatibility with v1 xds configuration, so it is generated in exactly the same way.
	StatPrefix string `protobuf:"bytes,2,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// protocol for the destination.
	Protocol L7Protocol `protobuf:"varint,3,opt,name=protocol,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.L7Protocol" json:"protocol,omitempty"`
	// traffic_permissions is a list of intentions for this destination.
	TrafficPermissions *TrafficPermissions `protobuf:"bytes,4,opt,name=traffic_permissions,json=trafficPermissions,proto3" json:"traffic_permissions,omitempty"`
	// include_xfcc specifies whether to add an xfcc policy for handling xfcc headers.
	IncludeXfccPolicy bool `protobuf:"varint,5,opt,name=include_xfcc_policy,json=includeXfccPolicy,proto3" json:"include_xfcc_policy,omitempty"`
	// xfcc_policy determines how to handle xfcc headers.
	XfccPolicy XFCCPolicy `protobuf:"varint,6,opt,name=xfcc_policy,json=xfccPolicy,proto3,enum=hashicorp.consul.mesh.v2beta1.pbproxystate.XFCCPolicy" json:"xfcc_policy,omitempty"`
	// parse_xfcc_headers determines whether to add filters to parse xfcc headers on incoming connections.
	ParseXfccHeaders bool `protobuf:"varint,7,opt,name=parse_xfcc_headers,json=parseXfccHeaders,proto3" json:"parse_xfcc_headers,omitempty"`
	// static_route specifies whether this is a static route that is inlined in the listener filter. This is required to
	// match existing xds config.
	StaticRoute bool `protobuf:"varint,8,opt,name=static_route,json=staticRoute,proto3" json:"static_route,omitempty"`
	// max_inbound_connections specifies how many connections this destination can accept.
	MaxInboundConnections uint64 `protobuf:"varint,9,opt,name=max_inbound_connections,json=maxInboundConnections,proto3" json:"max_inbound_connections,omitempty"`
}

func (x *L7Destination) Reset() {
	*x = L7Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *L7Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*L7Destination) ProtoMessage() {}

func (x *L7Destination) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use L7Destination.ProtoReflect.Descriptor instead.
func (*L7Destination) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{6}
}

func (x *L7Destination) GetRoute() *L7DestinationRoute {
	if x != nil {
		return x.Route
	}
	return nil
}

func (x *L7Destination) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *L7Destination) GetProtocol() L7Protocol {
	if x != nil {
		return x.Protocol
	}
	return L7Protocol_L7_PROTOCOL_HTTP
}

func (x *L7Destination) GetTrafficPermissions() *TrafficPermissions {
	if x != nil {
		return x.TrafficPermissions
	}
	return nil
}

func (x *L7Destination) GetIncludeXfccPolicy() bool {
	if x != nil {
		return x.IncludeXfccPolicy
	}
	return false
}

func (x *L7Destination) GetXfccPolicy() XFCCPolicy {
	if x != nil {
		return x.XfccPolicy
	}
	return XFCCPolicy_XFCC_POLICY_SANITIZE
}

func (x *L7Destination) GetParseXfccHeaders() bool {
	if x != nil {
		return x.ParseXfccHeaders
	}
	return false
}

func (x *L7Destination) GetStaticRoute() bool {
	if x != nil {
		return x.StaticRoute
	}
	return false
}

func (x *L7Destination) GetMaxInboundConnections() uint64 {
	if x != nil {
		return x.MaxInboundConnections
	}
	return 0
}

type SNIDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// stat_prefix is for compatibility with v1 xds configuration, so it is generated in exactly the same way.
	StatPrefix string `protobuf:"bytes,1,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
}

func (x *SNIDestination) Reset() {
	*x = SNIDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SNIDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SNIDestination) ProtoMessage() {}

func (x *SNIDestination) ProtoReflect() protoreflect.Message {
	mi := &file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SNIDestination.ProtoReflect.Descriptor instead.
func (*SNIDestination) Descriptor() ([]byte, []int) {
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP(), []int{7}
}

func (x *SNIDestination) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

var File_pbmesh_v2beta1_pbproxystate_listener_proto protoreflect.FileDescriptor

var file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x6c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x66,
	0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x70, 0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63,
	0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa4, 0x06, 0x0a, 0x08, 0x4c, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x5a, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e,
	0x48, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48,
	0x00, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x60, 0x0a, 0x0b, 0x75,
	0x6e, 0x69, 0x78, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x55, 0x6e,
	0x69, 0x78, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48,
	0x00, 0x52, 0x0a, 0x75, 0x6e, 0x69, 0x78, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x4c, 0x0a,
	0x07, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70,
	0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x72, 0x52, 0x07, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x73, 0x12, 0x59, 0x0a, 0x0e, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x52, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x52, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x6f, 0x0a, 0x13, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x42, 0x61, 0x6c,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x12, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x68, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x48, 0x61, 0x74, 0x63, 0x68, 0x4c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x18, 0x75, 0x73, 0x65, 0x5f, 0x65,
	0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x68, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x72, 0x61, 0x63,
	0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x75, 0x73, 0x65, 0x45, 0x73,
	0x63, 0x61, 0x70, 0x65, 0x48, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x63, 0x69, 0x6e, 0x67,
	0x42, 0x0e, 0x0a, 0x0c, 0x62, 0x69, 0x6e, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x22, 0xa8, 0x03, 0x0a, 0x06, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x05, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x68, 0x61, 0x73,
	0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65,
	0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x05, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x4b, 0x0a, 0x02, 0x6c, 0x34, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e,
	0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x34,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x02, 0x6c,
	0x34, 0x12, 0x4b, 0x0a, 0x02, 0x6c, 0x37, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x37, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x02, 0x6c, 0x37, 0x12, 0x4e,
	0x0a, 0x03, 0x73, 0x6e, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x68, 0x61,
	0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d,
	0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72,
	0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x4e, 0x49, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x03, 0x73, 0x6e, 0x69, 0x12, 0x5c,
	0x0a, 0x0b, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x74, 0x6c, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x6f, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x0a, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x54, 0x6c, 0x73, 0x42, 0x0d, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdf, 0x02, 0x0a, 0x05,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x70, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61,
	0x6c, 0x70, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x73, 0x12, 0x47, 0x0a, 0x10,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x5a, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x61, 0x6e, 0x67, 0x65,
	0x73, 0x12, 0x67, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x69, 0x64,
	0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x6f, 0x0a,
	0x09, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x3b, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6c, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x09, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4c, 0x65, 0x6e, 0x22, 0xb7,
	0x03, 0x0a, 0x0d, 0x4c, 0x34, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x5a, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f,
	0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x71, 0x0a, 0x11,
	0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63,
	0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x34, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x48, 0x00, 0x52, 0x10, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x12, 0x6f, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x74,
	0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x36, 0x0a, 0x17, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x04, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x28, 0x0a, 0x12, 0x4c, 0x37, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xdd, 0x04, 0x0a, 0x0d, 0x4c, 0x37, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54, 0x0a, 0x05, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e,
	0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x4c, 0x37, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x05, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74,
	0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x52, 0x0a, 0x08, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c,
	0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x4c, 0x37, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12,
	0x6f, 0x0a, 0x13, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x68,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e,
	0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x66, 0x66, 0x69,
	0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x12, 0x74, 0x72,
	0x61, 0x66, 0x66, 0x69, 0x63, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x78, 0x66, 0x63, 0x63,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x58, 0x66, 0x63, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x57, 0x0a, 0x0b, 0x78, 0x66, 0x63, 0x63, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x2e, 0x58, 0x46, 0x43, 0x43, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a, 0x78,
	0x66, 0x63, 0x63, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x61, 0x72,
	0x73, 0x65, 0x5f, 0x78, 0x66, 0x63, 0x63, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70, 0x61, 0x72, 0x73, 0x65, 0x58, 0x66, 0x63, 0x63,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x69,
	0x63, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x17, 0x6d, 0x61,
	0x78, 0x5f, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x04, 0x52, 0x15, 0x6d, 0x61, 0x78,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x22, 0x31, 0x0a, 0x0e, 0x53, 0x4e, 0x49, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50,
	0x72, 0x65, 0x66, 0x69, 0x78, 0x2a, 0x55, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a,
	0x11, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x42, 0x4f, 0x55,
	0x4e, 0x44, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4f, 0x55, 0x54, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x2a, 0x54, 0x0a, 0x12,
	0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x45, 0x58, 0x41, 0x43, 0x54,
	0x10, 0x01, 0x2a, 0x71, 0x0a, 0x0a, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x1a, 0x0a, 0x16, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x50, 0x41, 0x52, 0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21,
	0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4c, 0x37, 0x5f, 0x50, 0x52,
	0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54,
	0x59, 0x5f, 0x4c, 0x34, 0x5f, 0x54, 0x4c, 0x53, 0x5f, 0x49, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x02, 0x2a, 0xa7, 0x01, 0x0a, 0x0a, 0x58, 0x46, 0x43, 0x43, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x18, 0x0a, 0x14, 0x58, 0x46, 0x43, 0x43, 0x5f, 0x50, 0x4f, 0x4c,
	0x49, 0x43, 0x59, 0x5f, 0x53, 0x41, 0x4e, 0x49, 0x54, 0x49, 0x5a, 0x45, 0x10, 0x00, 0x12, 0x1c,
	0x0a, 0x18, 0x58, 0x46, 0x43, 0x43, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x46, 0x4f,
	0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a,
	0x58, 0x46, 0x43, 0x43, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x41, 0x50, 0x50, 0x45,
	0x4e, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18,
	0x58, 0x46, 0x43, 0x43, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x53, 0x41, 0x4e, 0x49,
	0x54, 0x49, 0x5a, 0x45, 0x5f, 0x53, 0x45, 0x54, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x58, 0x46,
	0x43, 0x43, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53,
	0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x04, 0x2a,
	0x4f, 0x0a, 0x0a, 0x4c, 0x37, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x14, 0x0a,
	0x10, 0x4c, 0x37, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x48, 0x54, 0x54,
	0x50, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4c, 0x37, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43,
	0x4f, 0x4c, 0x5f, 0x48, 0x54, 0x54, 0x50, 0x32, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x37,
	0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x5f, 0x47, 0x52, 0x50, 0x43, 0x10, 0x02,
	0x42, 0xd3, 0x02, 0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x6d, 0x65, 0x73, 0x68, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x70, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x68, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x63, 0x6f, 0x6e, 0x73, 0x75,
	0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x2f, 0x70,
	0x62, 0x6d, 0x65, 0x73, 0x68, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x70, 0x62,
	0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xa2, 0x02, 0x05, 0x48, 0x43, 0x4d,
	0x56, 0x50, 0xaa, 0x02, 0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x43,
	0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x2e, 0x56, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xca,
	0x02, 0x2a, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73,
	0x75, 0x6c, 0x5c, 0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c,
	0x50, 0x62, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0xe2, 0x02, 0x36, 0x48,
	0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72, 0x70, 0x5c, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x5c,
	0x4d, 0x65, 0x73, 0x68, 0x5c, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5c, 0x50, 0x62, 0x70,
	0x72, 0x6f, 0x78, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5c, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xea, 0x02, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x69, 0x63, 0x6f, 0x72,
	0x70, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x3a, 0x3a, 0x4d, 0x65, 0x73, 0x68, 0x3a,
	0x3a, 0x56, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3a, 0x3a, 0x50, 0x62, 0x70, 0x72, 0x6f, 0x78,
	0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescOnce sync.Once
	file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescData = file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDesc
)

func file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescGZIP() []byte {
	file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescOnce.Do(func() {
		file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescData = protoimpl.X.CompressGZIP(file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescData)
	})
	return file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDescData
}

var file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_pbmesh_v2beta1_pbproxystate_listener_proto_goTypes = []interface{}{
	(Direction)(0),                 // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.Direction
	(BalanceConnections)(0),        // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.BalanceConnections
	(Capability)(0),                // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.Capability
	(XFCCPolicy)(0),                // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.XFCCPolicy
	(L7Protocol)(0),                // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Protocol
	(*Listener)(nil),               // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener
	(*Router)(nil),                 // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.Router
	(*Match)(nil),                  // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.Match
	(*CidrRange)(nil),              // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.CidrRange
	(*L4Destination)(nil),          // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.L4Destination
	(*L7DestinationRoute)(nil),     // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.L7DestinationRoute
	(*L7Destination)(nil),          // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination
	(*SNIDestination)(nil),         // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.SNIDestination
	(*HostPortAddress)(nil),        // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.HostPortAddress
	(*UnixSocketAddress)(nil),      // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.UnixSocketAddress
	(*TransportSocket)(nil),        // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	(*wrapperspb.UInt32Value)(nil), // 16: google.protobuf.UInt32Value
	(*DestinationCluster)(nil),     // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationCluster
	(*L4WeightedClusterGroup)(nil), // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedClusterGroup
	(*TrafficPermissions)(nil),     // 19: hashicorp.consul.mesh.v2beta1.pbproxystate.TrafficPermissions
}
var file_pbmesh_v2beta1_pbproxystate_listener_proto_depIdxs = []int32{
	0,  // 0: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.direction:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Direction
	13, // 1: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.host_port:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.HostPortAddress
	14, // 2: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.unix_socket:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.UnixSocketAddress
	6,  // 3: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.routers:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Router
	6,  // 4: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.default_router:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Router
	2,  // 5: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.capabilities:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Capability
	1,  // 6: hashicorp.consul.mesh.v2beta1.pbproxystate.Listener.balance_connections:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.BalanceConnections
	7,  // 7: hashicorp.consul.mesh.v2beta1.pbproxystate.Router.match:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.Match
	9,  // 8: hashicorp.consul.mesh.v2beta1.pbproxystate.Router.l4:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L4Destination
	11, // 9: hashicorp.consul.mesh.v2beta1.pbproxystate.Router.l7:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination
	12, // 10: hashicorp.consul.mesh.v2beta1.pbproxystate.Router.sni:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.SNIDestination
	15, // 11: hashicorp.consul.mesh.v2beta1.pbproxystate.Router.inbound_tls:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TransportSocket
	16, // 12: hashicorp.consul.mesh.v2beta1.pbproxystate.Match.destination_port:type_name -> google.protobuf.UInt32Value
	8,  // 13: hashicorp.consul.mesh.v2beta1.pbproxystate.Match.prefix_ranges:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CidrRange
	8,  // 14: hashicorp.consul.mesh.v2beta1.pbproxystate.Match.source_prefix_ranges:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.CidrRange
	16, // 15: hashicorp.consul.mesh.v2beta1.pbproxystate.CidrRange.prefix_len:type_name -> google.protobuf.UInt32Value
	17, // 16: hashicorp.consul.mesh.v2beta1.pbproxystate.L4Destination.cluster:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.DestinationCluster
	18, // 17: hashicorp.consul.mesh.v2beta1.pbproxystate.L4Destination.weighted_clusters:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L4WeightedClusterGroup
	19, // 18: hashicorp.consul.mesh.v2beta1.pbproxystate.L4Destination.traffic_permissions:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TrafficPermissions
	10, // 19: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination.route:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L7DestinationRoute
	4,  // 20: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination.protocol:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.L7Protocol
	19, // 21: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination.traffic_permissions:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.TrafficPermissions
	3,  // 22: hashicorp.consul.mesh.v2beta1.pbproxystate.L7Destination.xfcc_policy:type_name -> hashicorp.consul.mesh.v2beta1.pbproxystate.XFCCPolicy
	23, // [23:23] is the sub-list for method output_type
	23, // [23:23] is the sub-list for method input_type
	23, // [23:23] is the sub-list for extension type_name
	23, // [23:23] is the sub-list for extension extendee
	0,  // [0:23] is the sub-list for field type_name
}

func init() { file_pbmesh_v2beta1_pbproxystate_listener_proto_init() }
func file_pbmesh_v2beta1_pbproxystate_listener_proto_init() {
	if File_pbmesh_v2beta1_pbproxystate_listener_proto != nil {
		return
	}
	file_pbmesh_v2beta1_pbproxystate_address_proto_init()
	file_pbmesh_v2beta1_pbproxystate_cluster_proto_init()
	file_pbmesh_v2beta1_pbproxystate_traffic_permissions_proto_init()
	file_pbmesh_v2beta1_pbproxystate_transport_socket_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Listener); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Router); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Match); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CidrRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L4Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7DestinationRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*L7Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SNIDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Listener_HostPort)(nil),
		(*Listener_UnixSocket)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Router_L4)(nil),
		(*Router_L7)(nil),
		(*Router_Sni)(nil),
	}
	file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*L4Destination_Cluster)(nil),
		(*L4Destination_WeightedClusters)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_pbmesh_v2beta1_pbproxystate_listener_proto_goTypes,
		DependencyIndexes: file_pbmesh_v2beta1_pbproxystate_listener_proto_depIdxs,
		EnumInfos:         file_pbmesh_v2beta1_pbproxystate_listener_proto_enumTypes,
		MessageInfos:      file_pbmesh_v2beta1_pbproxystate_listener_proto_msgTypes,
	}.Build()
	File_pbmesh_v2beta1_pbproxystate_listener_proto = out.File
	file_pbmesh_v2beta1_pbproxystate_listener_proto_rawDesc = nil
	file_pbmesh_v2beta1_pbproxystate_listener_proto_goTypes = nil
	file_pbmesh_v2beta1_pbproxystate_listener_proto_depIdxs = nil
}
