/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKeyBuilder;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;

@NonNullApi
public class DebuggingTaskOutputCachingBuildCacheKeyBuilder
implements TaskOutputCachingBuildCacheKeyBuilder {
    private static final Logger LOGGER = Logging.getLogger(DebuggingTaskOutputCachingBuildCacheKeyBuilder.class);
    private final TaskOutputCachingBuildCacheKeyBuilder delegate;

    public DebuggingTaskOutputCachingBuildCacheKeyBuilder(TaskOutputCachingBuildCacheKeyBuilder delegate) {
        this.delegate = delegate;
    }

    @Override
    public void appendTaskImplementation(ImplementationSnapshot taskImplementation) {
        this.log("taskClass", taskImplementation.getTypeName());
        if (!taskImplementation.hasUnknownClassLoader()) {
            this.log("classLoaderHash", taskImplementation.getClassLoaderHash());
        }
        this.delegate.appendTaskImplementation(taskImplementation);
    }

    @Override
    public void appendTaskActionImplementations(Collection<ImplementationSnapshot> taskActionImplementations) {
        for (ImplementationSnapshot actionImpl : taskActionImplementations) {
            this.log("actionType", actionImpl.getTypeName());
            this.log("actionClassLoaderHash", actionImpl.hasUnknownClassLoader() ? null : actionImpl.getClassLoaderHash());
        }
        this.delegate.appendTaskActionImplementations(taskActionImplementations);
    }

    @Override
    public void appendInputValuePropertyHash(String propertyName, HashCode hashCode) {
        LOGGER.lifecycle("Appending inputValuePropertyHash for '{}' to build cache key: {}", new Object[]{propertyName, hashCode});
        this.delegate.appendInputValuePropertyHash(propertyName, hashCode);
    }

    @Override
    public void appendInputFilesProperty(String propertyName, CurrentFileCollectionFingerprint fileCollectionFingerprint) {
        LOGGER.lifecycle("Appending inputFilePropertyHash for '{}' to build cache key: {}", new Object[]{propertyName, fileCollectionFingerprint.getHash()});
        this.delegate.appendInputFilesProperty(propertyName, fileCollectionFingerprint);
    }

    @Override
    public void inputPropertyLoadedByUnknownClassLoader(String propertyName) {
        LOGGER.lifecycle("The implementation of '{}' cannot be determined, because it was loaded by an unknown classloader", new Object[]{propertyName});
        this.delegate.inputPropertyLoadedByUnknownClassLoader(propertyName);
    }

    @Override
    public void appendOutputPropertyName(String propertyName) {
        this.log("outputPropertyName", propertyName);
        this.delegate.appendOutputPropertyName(propertyName);
    }

    @Override
    public TaskOutputCachingBuildCacheKey build() {
        return this.delegate.build();
    }

    private void log(String name, @Nullable Object value) {
        LOGGER.lifecycle("Appending {} to build cache key: {}", new Object[]{name, value});
    }
}

