/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.io.File;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.AbstractTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.DeferredUtil;

@NonNullApi
public class DefaultCacheableTaskOutputFilePropertySpec
extends AbstractTaskOutputPropertySpec
implements CacheableTaskOutputFilePropertySpec,
DeclaredTaskOutputFileProperty {
    private final TaskPropertyFileCollection files;
    private final OutputType outputType;
    private final PathToFileResolver resolver;
    private final ValidatingValue value;
    private final ValidationAction validationAction;

    public DefaultCacheableTaskOutputFilePropertySpec(String taskName, PathToFileResolver resolver, OutputType outputType, ValidatingValue path, ValidationAction validationAction) {
        this.resolver = resolver;
        this.outputType = outputType;
        this.value = path;
        this.validationAction = validationAction;
        this.files = new TaskPropertyFileCollection(taskName, "output", this, resolver, path);
    }

    @Override
    public FileCollection getPropertyFiles() {
        return this.files;
    }

    @Override
    public File getOutputFile() {
        Object unpackedOutput = DeferredUtil.unpack(this.value.call());
        if (unpackedOutput == null) {
            return null;
        }
        return this.resolver.resolve(unpackedOutput);
    }

    @Override
    public OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public void validate(TaskValidationContext context) {
        this.value.validate(this.getPropertyName(), this.isOptional(), this.validationAction, context);
    }
}

