# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{11..13} )
LLVM_COMPAT=( {16..21} )
inherit cmake llvm-r2 optfeature python-single-r1

DESCRIPTION="Super-parallel Python port of the C-Reduce"
HOMEPAGE="https://github.com/marxin/cvise"

if [[ ${PV} == 9999 ]] ; then
	EGIT_REPO_URI="https://github.com/marxin/cvise"
	inherit git-r3
else
	SRC_URI="
		https://github.com/marxin/cvise/archive/v${PV}.tar.gz -> ${P}.tar.gz
	"

	KEYWORDS="~amd64 ~arm ~arm64 ~loong ~ppc ~ppc64 ~riscv ~sparc ~x86"
fi

LICENSE="UoI-NCSA"
SLOT="0"
IUSE="test"
RESTRICT="!test? ( test )"
REQUIRED_USE="${PYTHON_REQUIRED_USE}"

DEPEND="
	$(llvm_gen_dep '
		llvm-core/clang:${LLVM_SLOT}
		llvm-core/llvm:${LLVM_SLOT}
	')
"
RDEPEND="
	${DEPEND}
	${PYTHON_DEPS}
	$(python_gen_cond_dep '
		dev-python/chardet[${PYTHON_USEDEP}]
		dev-python/jsonschema[${PYTHON_USEDEP}]
		dev-python/msgspec[${PYTHON_USEDEP}]
		dev-python/pebble[${PYTHON_USEDEP}]
		dev-python/psutil[${PYTHON_USEDEP}]
		dev-python/zstandard[${PYTHON_USEDEP}]
	')
	dev-util/unifdef
	app-alternatives/lex
"
BDEPEND="
	${PYTHON_DEPS}
	app-alternatives/lex
	dev-util/tree-sitter-cli
	test? (
		$(python_gen_cond_dep '
			dev-python/pytest[${PYTHON_USEDEP}]
			dev-python/pytest-mock[${PYTHON_USEDEP}]
			dev-python/pytest-subprocess[${PYTHON_USEDEP}]
		')
	)
"

EPYTEST_PLUGINS=( pytest-{mock,subprocess} )

pkg_setup() {
	python-single-r1_pkg_setup
	llvm-r2_pkg_setup
}

src_prepare() {
	sed -i -e 's:-Werror::' -e '/CMAKE_CXX_FLAGS_REL/d' CMakeLists.txt || die
	cmake_src_prepare
}

src_test() {
	cd "${BUILD_DIR}" || die
	epytest
}

src_install() {
	cmake_src_install

	python_fix_shebang "${ED}"
}

pkg_postinst() {
	optfeature "colorful --print-diff support" app-misc/colordiff
}
