# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999
#hackport: flags: sse42:cpu_flags_x86_sse4_2,+unsafe-tricks,-portable

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Mutable hash tables in the ST monad"
HOMEPAGE="https://github.com/gregorycollins/hashtables"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="bounds-checking cpu_flags_x86_sse4_2 debug detailed-profiling"

RDEPEND="
	=dev-haskell/hashable-1.4*:=[profile?]
	dev-haskell/primitive:=[profile?]
	>=dev-haskell/vector-0.7:=[profile?] <dev-haskell/vector-0.14
	>=dev-lang/ghc-8.10.6:=
"
DEPEND="
	${RDEPEND}
	>=dev-haskell/cabal-3.2.1.0
	test? (
		>=dev-haskell/hunit-1.2 <dev-haskell/hunit-2
		>=dev-haskell/mwc-random-0.8 <dev-haskell/mwc-random-0.16
		>=dev-haskell/quickcheck-2.3.0.2
		>=dev-haskell/test-framework-0.3.1 <dev-haskell/test-framework-0.9
		>=dev-haskell/test-framework-hunit-0.2.6 <dev-haskell/test-framework-hunit-3
		>=dev-haskell/test-framework-quickcheck2-0.2.6 <dev-haskell/test-framework-quickcheck2-0.4
	)
"

PATCHES=(
	"${FILESDIR}"/${PN}-1.3.1-clang-argument-must-be-a-constant-integer.patch
)

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag bounds-checking bounds-checking) \
		$(cabal_flag debug debug) \
		$(cabal_flag detailed-profiling detailed-profiling) \
		--flag=-portable \
		$(cabal_flag cpu_flags_x86_sse4_2 sse42) \
		--flag=unsafe-tricks
}
