# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	adler2@2.0.1
	aes@0.8.4
	aho-corasick@1.1.3
	allocator-api2@0.2.21
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	ashpd@0.11.0
	async-broadcast@0.7.2
	async-channel@2.5.0
	async-executor@1.13.3
	async-fs@2.1.3
	async-io@2.5.0
	async-lock@3.4.1
	async-net@2.0.0
	async-process@2.4.0
	async-recursion@1.1.1
	async-signal@0.2.12
	async-task@4.7.1
	async-trait@0.1.89
	atomic-waker@1.1.2
	autocfg@1.5.0
	bitflags@1.3.2
	bitflags@2.9.3
	block-buffer@0.10.4
	block-padding@0.3.3
	block@0.1.6
	blocking@1.6.2
	bytemuck@1.23.2
	byteorder-lite@0.1.0
	byteorder@1.5.0
	cairo-rs@0.21.1
	cairo-sys-rs@0.21.1
	cbc@0.1.2
	cc@1.2.34
	cfg-expr@0.18.0
	cfg-if@1.0.3
	cfg_aliases@0.2.1
	cipher@0.4.4
	colorchoice@1.0.4
	concurrent-queue@2.5.0
	cpufeatures@0.2.17
	crc32fast@1.5.0
	crossbeam-utils@0.8.21
	crypto-common@0.1.6
	digest@0.10.7
	displaydoc@0.2.5
	endi@1.1.0
	enumflags2@0.7.12
	enumflags2_derive@0.7.12
	env_filter@0.1.3
	env_logger@0.11.8
	equivalent@1.0.2
	errno@0.3.13
	event-listener-strategy@0.5.4
	event-listener@5.4.1
	fastrand@2.3.0
	fdeflate@0.3.7
	field-offset@0.3.6
	flate2@1.1.2
	foldhash@0.1.5
	form_urlencoded@1.2.2
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-lite@2.6.1
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	gdk-pixbuf-sys@0.21.1
	gdk-pixbuf@0.21.1
	gdk4-sys@0.10.0
	gdk4@0.10.0
	generic-array@0.14.7
	getrandom@0.2.16
	getrandom@0.3.3
	gettext-rs@0.7.2
	gettext-sys@0.22.5
	gio-sys@0.21.1
	gio@0.21.1
	git-version-macro@0.3.9
	git-version@0.3.9
	glib-macros@0.21.0
	glib-sys@0.21.1
	glib@0.21.1
	gobject-sys@0.21.1
	graphene-rs@0.21.1
	graphene-sys@0.21.1
	gsk4-sys@0.10.0
	gsk4@0.10.0
	gtk4-macros@0.10.0
	gtk4-sys@0.10.0
	gtk4@0.10.0
	hashbrown@0.15.5
	heck@0.5.0
	hermit-abi@0.5.2
	hex@0.4.3
	hkdf@0.12.4
	hmac@0.12.1
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.1.0
	idna_adapter@1.2.1
	image@0.25.6
	indexmap@2.11.0
	inout@0.1.4
	is_terminal_polyfill@1.70.1
	jiff-static@0.2.15
	jiff@0.2.15
	lazy_static@1.5.0
	libadwaita-sys@0.8.0
	libadwaita@0.8.0
	libc@0.2.175
	libm@0.2.15
	linux-raw-sys@0.9.4
	litemap@0.8.0
	locale_config@0.3.0
	log@0.4.27
	lru@0.16.0
	malloc_buf@0.0.6
	md-5@0.10.6
	memchr@2.7.5
	memoffset@0.9.1
	miniz_oxide@0.8.9
	nix@0.30.1
	num-bigint-dig@0.8.4
	num-bigint@0.4.6
	num-complex@0.4.6
	num-integer@0.1.46
	num-iter@0.1.45
	num-rational@0.4.2
	num-traits@0.2.19
	num@0.4.3
	objc-foundation@0.1.1
	objc@0.2.7
	objc_id@0.1.1
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	oo7@0.4.3
	ordered-stream@0.2.0
	pango-sys@0.21.1
	pango@0.21.1
	parking@2.2.1
	pbkdf2@0.12.2
	percent-encoding@2.3.2
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	piper@0.2.4
	pkg-config@0.3.32
	png@0.17.16
	polling@3.10.0
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.3
	ppv-lite86@0.2.21
	proc-macro-crate@3.3.0
	proc-macro2@1.0.101
	quote@1.0.40
	r-efi@5.3.0
	rand@0.8.5
	rand@0.9.2
	rand_chacha@0.3.1
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	regex-automata@0.4.10
	regex-syntax@0.8.6
	regex@1.11.2
	rustc_version@0.4.1
	rustix@1.0.8
	semver@1.0.26
	serde@1.0.219
	serde_derive@1.0.219
	serde_repr@0.1.20
	serde_spanned@0.6.9
	sha2@0.10.9
	shell-words@1.1.0
	shlex@1.3.0
	signal-hook-registry@1.4.6
	simd-adler32@0.3.7
	slab@0.4.11
	smallvec@1.15.1
	spin@0.9.8
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	subtle@2.6.1
	syn@2.0.106
	synstructure@0.13.2
	system-deps@7.0.5
	target-lexicon@0.13.2
	temp-dir@0.1.16
	tempfile@3.21.0
	tinystr@0.8.1
	toml@0.8.23
	toml_datetime@0.6.11
	toml_edit@0.22.27
	tracing-attributes@0.1.30
	tracing-core@0.1.34
	tracing@0.1.41
	typenum@1.18.0
	uds_windows@1.1.0
	unicode-ident@1.0.18
	url@2.5.7
	utf8_iter@1.0.4
	utf8parse@0.2.2
	version-compare@0.2.0
	version_check@0.9.5
	wasi@0.11.1+wasi-snapshot-preview1
	wasi@0.14.3+wasi-0.2.4
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-link@0.1.3
	windows-sys@0.60.2
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.53.0
	winnow@0.7.13
	wit-bindgen@0.45.0
	writeable@0.6.1
	yoke-derive@0.8.0
	yoke@0.8.0
	zbus@5.10.0
	zbus_macros@5.10.0
	zbus_names@4.2.0
	zerocopy-derive@0.8.26
	zerocopy@0.8.26
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zeroize@1.8.1
	zeroize_derive@1.4.2
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.4
	zvariant@5.7.0
	zvariant_derive@5.7.0
	zvariant_utils@3.2.1
"

RUST_MIN_VER="1.83"

inherit cargo gnome.org gnome2 meson xdg

DESCRIPTION="A document viewer for the GNOME desktop"
HOMEPAGE="https://apps.gnome.org/Papers"

# SRC_URI is set by gnome.org eclass.
SRC_URI+=" ${CARGO_CRATE_URIS}"

LICENSE="GPL-2+ MIT"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 Apache-2.0-with-LLVM-exceptions BSD-2 BSD MIT Unicode-3.0
	ZLIB
"

# subslot = ppsd4.0.(suffix of libppsdocument-4.0)-ppsv4.0.(suffix of libppsview-4.0)
SLOT="0/ppsd4.0.6-ppsv4.0.5"

KEYWORDS="~amd64"

IUSE="+comics djvu doc gnome-keyring introspection nautilus +spell sysprof test tiff"
RESTRICT="!test? ( test )"

BDEPEND="
	virtual/pkgconfig
	>=dev-build/meson-1.8.0
	dev-util/blueprint-compiler
	dev-libs/appstream
	dev-libs/appstream-glib
	doc? ( dev-util/gi-docgen )
"

# sys-crates in pycargoebuild order
DEPEND="
	x11-libs/cairo
	x11-libs/gdk-pixbuf[introspection?]
	sys-devel/gettext
	media-libs/graphene
	media-libs/libraw
	x11-libs/pango[introspection?]
"
# meson.build file
DEPEND+="
	>=dev-libs/glib-2.75.0:2
	>=gui-libs/gtk-4.17.1:4
	>=gui-libs/libadwaita-1.8_alpha:1
	media-libs/exempi:2
	>=x11-libs/cairo-1.14.0
	virtual/zlib:=

	sysprof? ( dev-util/sysprof-capture:4 )

	nautilus? ( >=gnome-base/nautilus-43 )
	introspection? ( >=dev-libs/gobject-introspection-1.82.0-r2 )
	spell? ( >=app-text/libspelling-0.2 )
	comics? ( >=app-arch/libarchive-3.6.0 )
	djvu? ( >=app-text/djvu-3.5.22 )

	>=app-text/poppler-25.01.0[cairo]
	x11-libs/cairo

	tiff? ( >=media-libs/tiff-4 )

"
RDEPEND="${DEPEND}
	gnome-keyring? ( app-crypt/libsecret )
"

QA_FLAGS_IGNORED="usr/bin/papers usr/bin/papers-thumbnailer"

src_configure() {
	local emesonargs=(
		$(meson_feature sysprof)
		$(meson_use nautilus)
		$(meson_feature comics)
		$(meson_feature djvu)
		-Dpdf=enabled
		$(meson_feature tiff)
		$(meson_use test tests)
		$(meson_use doc documentation)
		$(meson_use doc user_doc)
		$(meson_feature introspection)
		$(meson_feature sysprof)
		$(meson_feature gnome-keyring keyring)
		$(meson_feature spell spell_check)
	)
	meson_src_configure
	ln -s "${CARGO_HOME}" "${BUILD_DIR}/cargo-home" || die
}

src_install() {
	meson_src_install
	if use doc; then
		mv "${ED}"/usr/share/doc/{libpps*,${PF}/.} || die
	fi
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
