/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;

public class CollationMap
implements Serializable {
    private Configuration config;
    private String defaultCollationName;
    private HashMap<String, StringCollator> map;

    public CollationMap(Configuration config) {
        this.config = config;
        this.defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public CollationMap(CollationMap in) {
        if (in.map != null) {
            this.map = new HashMap<String, StringCollator>(in.map);
        }
        this.config = in.config;
        this.defaultCollationName = in.defaultCollationName;
    }

    public void setDefaultCollationName(String name) {
        if (name == null) {
            throw new NullPointerException("defaultCollationName");
        }
        this.defaultCollationName = name;
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public StringCollator getDefaultCollation() {
        return this.getNamedCollation(this.defaultCollationName);
    }

    public void setNamedCollation(String absoluteURI, StringCollator collator) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(absoluteURI, collator);
    }

    public StringCollator getNamedCollation(String name) {
        StringCollator c;
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        if (this.map != null && (c = this.map.get(name)) != null) {
            return c;
        }
        return this.config.getCollationURIResolver().resolve(name, null, this.config);
    }
}

