/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.NamespaceImpl;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class ElementImpl
extends ParentNodeImpl
implements Element {
    private static AttributeCollection emptyAtts = new AttributeCollection((NamePool)null);
    protected int nameCode;
    protected DocumentImpl root;

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public void initialise(int n, AttributeCollection attributeCollection, NodeInfo nodeInfo, String string, int n2, int n3) {
        this.nameCode = n;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n3;
        this.root = (DocumentImpl)nodeInfo.getDocumentRoot();
        this.root.setLineNumber(n3, n2);
        this.root.setSystemId(n3, string);
    }

    public void setSystemId(String string) {
        this.root.setSystemId(this.sequence, string);
    }

    public DocumentInfo getDocumentRoot() {
        return this.root;
    }

    public final String getSystemId() {
        return ((DocumentImpl)this.getDocumentRoot()).getSystemId(this.sequence);
    }

    public String getBaseURI() {
        String string;
        String string2 = this.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
        if (string2 != null) {
            return string2;
        }
        String string3 = this.getSystemId();
        if (string3.equals(string = this.parent.getSystemId())) {
            return this.parent.getBaseURI();
        }
        return string3;
    }

    public void setLineNumber(int n) {
        ((DocumentImpl)this.getDocumentRoot()).setLineNumber(this.sequence, n);
    }

    public int getLineNumber() {
        return ((DocumentImpl)this.getDocumentRoot()).getLineNumber(this.sequence);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public String generateId() {
        return "e" + this.sequence;
    }

    public short getURICodeForPrefix(String string) throws NamespaceException {
        if (string.equals("xml")) {
            return 1;
        }
        if (this.parent.getNodeType() == 9) {
            if (string.equals("")) {
                return 0;
            }
            throw new NamespaceException(string);
        }
        return ((ElementImpl)this.parent).getURICodeForPrefix(string);
    }

    public String getPrefixForURI(String string) {
        if (this.parent.getNodeType() == 9) {
            return null;
        }
        return ((ElementImpl)this.parent).getPrefixForURI(string);
    }

    public final int makeNameCode(String string, boolean bl) throws NamespaceException {
        NamePool namePool = this.getNamePool();
        String string2 = Name.getPrefix(string);
        if (string2.equals("")) {
            short s = 0;
            if (bl) {
                s = this.getURICodeForPrefix(string2);
            }
            return namePool.allocate(string2, s, string);
        }
        String string3 = Name.getLocalName(string);
        short s = this.getURICodeForPrefix(string2);
        return namePool.allocate(string2, s, string3);
    }

    public void addNamespaceNodes(ElementImpl elementImpl, Vector vector, boolean bl) {
        if (this.parent.getNodeType() != 9) {
            ((ElementImpl)this.parent).addNamespaceNodes(elementImpl, vector, false);
        }
        if (bl) {
            int n = 65537;
            vector.addElement(new NamespaceImpl(this, n, vector.size() + 1));
        }
    }

    public void outputNamespaceNodes(Outputter outputter, boolean bl) throws TransformerException {
        if (bl && !(this.parent instanceof DocumentInfo)) {
            ((ElementImpl)this.parent).outputNamespaceNodes(outputter, true);
        }
    }

    public final short getNodeType() {
        return 1;
    }

    public AttributeCollection getAttributeList() {
        return emptyAtts;
    }

    public String getAttributeValue(String string) {
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public void copy(Outputter outputter) throws TransformerException {
        this.copy(outputter, true);
    }

    public void copy(Outputter outputter, boolean bl) throws TransformerException {
        int n = this.getNameCode();
        outputter.writeStartTag(n);
        this.outputNamespaceNodes(outputter, bl);
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            if (nodeImpl instanceof ElementImpl) {
                ((ElementImpl)nodeImpl).copy(outputter, false);
            } else {
                nodeImpl.copy(outputter);
            }
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
        outputter.writeEndTag(n);
    }
}

