/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// Auto-generated file. DO NOT EDIT!
// Generated by org.jetbrains.kotlin.generators.builtins.arrays.GenerateJvmArrays

@file:Suppress("NON_ABSTRACT_FUNCTION_WITH_NO_BODY", "PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED", "MUST_BE_INITIALIZED_OR_BE_ABSTRACT")

@file:kotlin.internal.JvmBuiltin
@file:kotlin.internal.SuppressBytecodeGeneration

package kotlin

/**
 * An array of bytes. When targeting the JVM, instances of this class are represented as `byte[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class ByteArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Byte)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Byte

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Byte): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [ByteIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): ByteIterator
}

/**
 * An array of chars. When targeting the JVM, instances of this class are represented as `char[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class CharArray
/**
 * Creates a new array of the specified [size], with all elements initialized to null char (`\u0000').
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Char)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Char

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Char): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [CharIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): CharIterator
}

/**
 * An array of shorts. When targeting the JVM, instances of this class are represented as `short[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class ShortArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Short)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Short

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Short): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [ShortIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): ShortIterator
}

/**
 * An array of ints. When targeting the JVM, instances of this class are represented as `int[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class IntArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Int)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Int

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Int): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [IntIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): IntIterator
}

/**
 * An array of longs. When targeting the JVM, instances of this class are represented as `long[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class LongArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Long)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Long

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Long): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [LongIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): LongIterator
}

/**
 * An array of floats. When targeting the JVM, instances of this class are represented as `float[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class FloatArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Float)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Float

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Float): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [FloatIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): FloatIterator
}

/**
 * An array of doubles. When targeting the JVM, instances of this class are represented as `double[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class DoubleArray
/**
 * Creates a new array of the specified [size], with all elements initialized to zero.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Double)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Double

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Double): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [DoubleIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): DoubleIterator
}

/**
 * An array of booleans. When targeting the JVM, instances of this class are represented as `boolean[]`.
 *
 * See [Kotlin language documentation](https://kotlinlang.org/docs/arrays.html)
 * for more information on arrays.
 */
public actual class BooleanArray
/**
 * Creates a new array of the specified [size], with all elements initialized to `false`.
 * @throws RuntimeException if the specified [size] is negative.
 */
public actual constructor(size: Int) {
    /**
     * Creates a new array of the specified [size], where each element is calculated by calling the specified
     * [init] function.
     *
     * The function [init] is called for each array element sequentially starting from the first one.
     * It should return the value for an array element given its index.
     *
     * @throws RuntimeException if the specified [size] is negative.
     */
    @Suppress("WRONG_MODIFIER_TARGET")
    public actual inline constructor(size: Int, init: (Int) -> Boolean)

    /**
     * Returns the array element at the given [index].
     *
     * This method can be called using the index operator:
     * ```
     * value = array[index]
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun get(index: Int): Boolean

    /**
     * Sets the array element at the given [index] to the given [value].
     *
     * This method can be called using the index operator:
     * ```
     * array[index] = value
     * ```
     *
     * If the [index] is out of bounds of this array, throws an [IndexOutOfBoundsException] except in Kotlin/JS
     * where the behavior is unspecified.
     */
    public actual operator fun set(index: Int, value: Boolean): Unit

    /**
     * Returns the number of elements in the array.
     */
    public actual val size: Int

    /** Creates a specialized [BooleanIterator] for iterating over the elements of the array. */
    public actual operator fun iterator(): BooleanIterator
}
