/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.layout.TextJustification;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetStripTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.ThemeTextStyle;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultFacetStripTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetStripTheme;", "direction", "", "options", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/lang/String;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "rectKey", "", "getRectKey$plot_builder", "()Ljava/util/List;", "suffix", "textKey", "getTextKey$plot_builder", "showStrip", "", "showStripBackground", "stripColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "stripFill", "stripLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "stripMargins", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "stripStrokeWidth", "", "stripTextJustification", "Lorg/jetbrains/letsPlot/core/plot/base/layout/TextJustification;", "stripTextStyle", "Lorg/jetbrains/letsPlot/core/plot/base/theme/ThemeTextStyle;", "plot-builder"})
public final class DefaultFacetStripTheme
extends ThemeValuesAccess
implements FacetStripTheme {
    @NotNull
    private final String suffix;
    @NotNull
    private final List<String> rectKey;
    @NotNull
    private final List<String> textKey;

    public DefaultFacetStripTheme(@NotNull String direction, @NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        this.suffix = '_' + direction;
        Object[] objectArray = new String[]{"strip_background" + this.suffix, "strip_background", "rect"};
        this.rectKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"strip_text" + this.suffix, "strip_text", "text"};
        this.textKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getRectKey$plot_builder() {
        return this.rectKey;
    }

    @NotNull
    public final List<String> getTextKey$plot_builder() {
        return this.textKey;
    }

    @Override
    public boolean showStrip() {
        return !this.isElemBlank(this.textKey);
    }

    @Override
    public boolean showStripBackground() {
        return this.showStrip() && !this.isElemBlank(this.rectKey);
    }

    @Override
    @NotNull
    public Color stripFill() {
        return this.getColor(this.getElemValue(this.rectKey), "fill");
    }

    @Override
    @NotNull
    public Color stripColor() {
        return this.getColor(this.getElemValue(this.rectKey), "color");
    }

    @Override
    public double stripStrokeWidth() {
        return this.getNumber(this.getElemValue(this.rectKey), "size");
    }

    @Override
    @NotNull
    public LineType stripLineType() {
        return this.getLineType(this.getElemValue(this.rectKey));
    }

    @Override
    @NotNull
    public ThemeTextStyle stripTextStyle() {
        return this.getTextStyle(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public Thickness stripMargins() {
        return this.getMargins(this.getElemValue(this.textKey));
    }

    @Override
    @NotNull
    public TextJustification stripTextJustification() {
        return this.getTextJustification(this.getElemValue(this.textKey));
    }
}

