/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;

public class CmdHistoryClient
extends BaseSvnClient
implements HistoryClient {
    /*
     * WARNING - void declaration
     */
    @Override
    public void doLog(@NotNull Target target, @NotNull Revision startRevision, @NotNull Revision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit, String @Nullable [] revisionProperties, @Nullable LogEntryConsumer logEntryConsumer) throws VcsException {
        void handler;
        if (target == null) {
            CmdHistoryClient.$$$reportNull$$$0(0);
        }
        if (startRevision == null) {
            CmdHistoryClient.$$$reportNull$$$0(1);
        }
        if (endRevision == null) {
            CmdHistoryClient.$$$reportNull$$$0(2);
        }
        List<String> parameters = CmdHistoryClient.prepareCommand(target, startRevision, endRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.log, parameters, null);
        CmdHistoryClient.parseOutput(command, (LogEntryConsumer)handler);
    }

    private static void parseOutput(@NotNull CommandExecutor command, @Nullable LogEntryConsumer handler) throws VcsException {
        if (command == null) {
            CmdHistoryClient.$$$reportNull$$$0(3);
        }
        try {
            LogInfo log = CommandUtil.parse(command.getOutput(), LogInfo.class);
            if (handler != null && log != null) {
                for (LogEntry.Builder entry : log.entries) {
                    CmdHistoryClient.iterateRecursively(entry, handler);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void iterateRecursively(@NotNull LogEntry.Builder entry, @NotNull LogEntryConsumer handler) throws SvnBindException {
        if (entry == null) {
            CmdHistoryClient.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            CmdHistoryClient.$$$reportNull$$$0(5);
        }
        handler.consume(entry.build());
        for (LogEntry.Builder childEntry : entry.getChildEntries()) {
            CmdHistoryClient.iterateRecursively(childEntry, handler);
        }
        if (entry.hasChildren()) {
            handler.consume(LogEntry.EMPTY);
        }
    }

    private static List<String> prepareCommand(@NotNull Target target, @NotNull Revision startRevision, @NotNull Revision endRevision, boolean stopOnCopy, boolean discoverChangedPaths, boolean includeMergedRevisions, long limit) {
        if (target == null) {
            CmdHistoryClient.$$$reportNull$$$0(6);
        }
        if (startRevision == null) {
            CmdHistoryClient.$$$reportNull$$$0(7);
        }
        if (endRevision == null) {
            CmdHistoryClient.$$$reportNull$$$0(8);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, startRevision, endRevision);
        CommandUtil.put(parameters, stopOnCopy, "--stop-on-copy");
        CommandUtil.put(parameters, discoverChangedPaths, "--verbose");
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        if (limit > 0L) {
            parameters.add("--limit");
            parameters.add(String.valueOf(limit));
        }
        parameters.add("--xml");
        return parameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevision";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRevision";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/history/CmdHistoryClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doLog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateRecursively";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @XmlRootElement(name="log")
    public static class LogInfo {
        @XmlElement(name="logentry")
        public List<LogEntry.Builder> entries = new ArrayList<LogEntry.Builder>();
    }
}

