/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.features;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.util.Version;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\tH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0014H\u0002R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u000e\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/completion/ml/features/MLFeaturesUtil;", "", "<init>", "()V", "getRawValue", "featureValue", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "getNames", "Lcom/intellij/completion/ml/features/MLFeaturesUtil$ClassNames;", "Ljava/lang/Class;", "THIRD_PARTY_NAME", "CLASS_NAMES_CACHE", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getClassNameSafe", "feature", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue$ClassNameValue;", "INVALID_VERSION", "getVersionSafe", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue$VersionValue;", "ClassNames", "intellij.completionMlRanking"})
public final class MLFeaturesUtil {
    @NotNull
    public static final MLFeaturesUtil INSTANCE = new MLFeaturesUtil();
    @NotNull
    private static final ClassNames THIRD_PARTY_NAME = new ClassNames("third.party", "third.party");
    @NotNull
    private static final Cache<String, ClassNames> CLASS_NAMES_CACHE;
    @NotNull
    private static final String INVALID_VERSION = "invalid.version";

    private MLFeaturesUtil() {
    }

    @NotNull
    public final Object getRawValue(@NotNull MLFeatureValue featureValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)featureValue, (String)"featureValue");
        MLFeatureValue mLFeatureValue = featureValue;
        if (mLFeatureValue instanceof MLFeatureValue.BinaryValue) {
            object = ((MLFeatureValue.BinaryValue)featureValue).getValue() != false ? 1 : 0;
        } else if (mLFeatureValue instanceof MLFeatureValue.FloatValue) {
            object = ((MLFeatureValue.FloatValue)featureValue).getValue();
        } else if (mLFeatureValue instanceof MLFeatureValue.CategoricalValue) {
            object = ((MLFeatureValue.CategoricalValue)featureValue).getValue();
        } else if (mLFeatureValue instanceof MLFeatureValue.ClassNameValue) {
            object = this.getClassNameSafe((MLFeatureValue.ClassNameValue)featureValue);
        } else if (mLFeatureValue instanceof MLFeatureValue.VersionValue) {
            object = this.getVersionSafe((MLFeatureValue.VersionValue)featureValue);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final ClassNames getNames(Class<?> $this$getNames) {
        String string = $this$getNames.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String string2 = $this$getNames.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new ClassNames(string, string2);
    }

    @NotNull
    public final String getClassNameSafe(@NotNull MLFeatureValue.ClassNameValue feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Class clazz = feature.getValue();
        Object object = CLASS_NAMES_CACHE.get((Object)clazz.getName(), arg_0 -> MLFeaturesUtil.getClassNameSafe$lambda$1(arg_0 -> MLFeaturesUtil.getClassNameSafe$lambda$0(clazz, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        ClassNames names = (ClassNames)object;
        return feature.getUseSimpleName() ? names.getSimpleName() : names.getFullName();
    }

    private final String getVersionSafe(MLFeatureValue.VersionValue featureValue) {
        Object object = Version.parseVersion((String)featureValue.getValue());
        if (object == null || (object = object.toString()) == null) {
            object = INVALID_VERSION;
        }
        return object;
    }

    private static final ClassNames getClassNameSafe$lambda$0(Class $clazz, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PluginInfoDetectorKt.getPluginInfo((Class)$clazz).isSafeToReport() ? INSTANCE.getNames($clazz) : THIRD_PARTY_NAME;
    }

    private static final ClassNames getClassNameSafe$lambda$1(Function1 $tmp0, Object p0) {
        return (ClassNames)$tmp0.invoke(p0);
    }

    static {
        Cache cache = Caffeine.newBuilder().maximumSize(100L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        CLASS_NAMES_CACHE = cache;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/completion/ml/features/MLFeaturesUtil$ClassNames;", "", "simpleName", "", "fullName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSimpleName", "()Ljava/lang/String;", "getFullName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.completionMlRanking"})
    private static final class ClassNames {
        @NotNull
        private final String simpleName;
        @NotNull
        private final String fullName;

        public ClassNames(@NotNull String simpleName, @NotNull String fullName) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            this.simpleName = simpleName;
            this.fullName = fullName;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        @NotNull
        public final String component1() {
            return this.simpleName;
        }

        @NotNull
        public final String component2() {
            return this.fullName;
        }

        @NotNull
        public final ClassNames copy(@NotNull String simpleName, @NotNull String fullName) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            return new ClassNames(simpleName, fullName);
        }

        public static /* synthetic */ ClassNames copy$default(ClassNames classNames, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = classNames.simpleName;
            }
            if ((n & 2) != 0) {
                string2 = classNames.fullName;
            }
            return classNames.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ClassNames(simpleName=" + this.simpleName + ", fullName=" + this.fullName + ")";
        }

        public int hashCode() {
            int result = this.simpleName.hashCode();
            result = result * 31 + this.fullName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassNames)) {
                return false;
            }
            ClassNames classNames = (ClassNames)other;
            if (!Intrinsics.areEqual((Object)this.simpleName, (Object)classNames.simpleName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fullName, (Object)classNames.fullName);
        }
    }
}

