/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryProtocolDataListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketTestDiscoveryProtocolDataListener
extends TestDiscoveryProtocolDataListener {
    private static final int SOCKET_BUFFER_SIZE = 131072;
    public static final String HOST_PROP = "test.discovery.data.host";
    public static final String PORT_PROP = "test.discovery.data.port";
    public static final String DATA_VERSION = "test.discovery.data.version";
    private static final byte DEFAULT_VERSION = 1;
    private final Socket mySocket;
    private final BlockingQueue<ByteBuffer> myData = new ArrayBlockingQueue<ByteBuffer>(10);
    private final NameEnumerator.Incremental incrementalNameEnumerator = new NameEnumerator.Incremental();
    private final DataOutputStream dos;
    private final OutputStream os;

    /*
     * WARNING - void declaration
     */
    public SocketTestDiscoveryProtocolDataListener() throws IOException {
        super(Byte.parseByte(System.getProperty(DATA_VERSION, "1")));
        void var2_2;
        void var1_1;
        String host = System.getProperty(HOST_PROP, "127.0.0.1");
        int port = Integer.parseInt(System.getProperty(PORT_PROP));
        this.mySocket = new Socket((String)var1_1, (int)var2_2);
        this.mySocket.setSendBufferSize(131072);
        this.mySocket.setTcpNoDelay(true);
        this.os = this.mySocket.getOutputStream();
        this.dos = new DataOutputStream(this.os);
        SocketTestDiscoveryProtocolDataListener socketTestDiscoveryProtocolDataListener = this;
        socketTestDiscoveryProtocolDataListener.start(socketTestDiscoveryProtocolDataListener.dos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void testFinished(String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, List<int[]> openedFiles) {
        IOException iOException;
        try {
            void var3_3;
            void var2_2;
            SocketTestDiscoveryProtocolDataListener socketTestDiscoveryProtocolDataListener = this;
            socketTestDiscoveryProtocolDataListener.writeTestFinished(socketTestDiscoveryProtocolDataListener.dos, (String)((Object)iOException), (String)var2_2, (Map<Integer, boolean[]>)var3_3, classToMethodNames, openedFiles);
            return;
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            iOException2.printStackTrace();
            return;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void testsFinished() {
        SocketTestDiscoveryProtocolDataListener socketTestDiscoveryProtocolDataListener = this;
        socketTestDiscoveryProtocolDataListener.finish(socketTestDiscoveryProtocolDataListener.dos);
        try {
            this.dos.close();
            this.os.close();
            this.mySocket.close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            IOException iOException3;
            try {
                iOException3 = iOException;
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    this.dos.close();
                    this.os.close();
                    this.mySocket.close();
                }
                catch (IOException iOException4) {
                    IOException iOException5 = iOException4;
                    iOException4.printStackTrace();
                }
                throw throwable;
            }
            try {
                this.dos.close();
                this.os.close();
                this.mySocket.close();
                return;
            }
            catch (IOException iOException6) {
                iOException3 = iOException6;
                iOException6.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addMetadata(Map<String, String> metadata) throws IOException {
        void var1_1;
        SocketTestDiscoveryProtocolDataListener socketTestDiscoveryProtocolDataListener = this;
        socketTestDiscoveryProtocolDataListener.writeMetadata(socketTestDiscoveryProtocolDataListener.dos, (Map<String, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addClassMetadata(List<ClassMetadata> metadata) throws IOException {
        void var1_1;
        SocketTestDiscoveryProtocolDataListener socketTestDiscoveryProtocolDataListener = this;
        socketTestDiscoveryProtocolDataListener.writeClassMetadata(socketTestDiscoveryProtocolDataListener.dos, (List<ClassMetadata>)var1_1);
    }

    @Override
    public NameEnumerator.Incremental getNameEnumerator() {
        return this.incrementalNameEnumerator;
    }
}

