/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration.mpp;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryCoordinates;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryDependencyKt;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinResolvedBinaryDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinUnresolvedBinaryDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.KlibExtra;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.KlibExtraKt;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.PrimitiveExtrasKt;
import org.jetbrains.kotlin.gradle.idea.tcs.extras.SourcesAndDocumentationExtrasKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.mpp.DependencyNodeUtilsKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.mpp.KotlinLibraryNameKt;
import org.jetbrains.kotlin.idea.gradleJava.configuration.utils.UtilsKt;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\"\u0010\u0000\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0002\u0018\u00010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0012"}, d2={"addDependency", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/LibraryDependencyData;", "Lorg/jetbrains/plugins/gradle/model/data/GradleSourceSetData;", "dependency", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinBinaryDependency;", "addToDependencyNode", "", "file", "Ljava/io/File;", "dependencyNode", "libraryPathType", "Lcom/intellij/openapi/externalSystem/model/project/LibraryPathType;", "refreshInVFSIfNecessary", "absolutePath", "Ljava/nio/file/Path;", "buildNativeDistributionInternalLibraryName", "", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\naddIdeaKotlinBinaryDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 addIdeaKotlinBinaryDependency.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/mpp/AddIdeaKotlinBinaryDependencyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1869#2,2:102\n1869#2,2:104\n1869#2,2:106\n*S KotlinDebug\n*F\n+ 1 addIdeaKotlinBinaryDependency.kt\norg/jetbrains/kotlin/idea/gradleJava/configuration/mpp/AddIdeaKotlinBinaryDependencyKt\n*L\n53#1:102,2\n58#1:104,2\n62#1:106,2\n*E\n"})
public final class AddIdeaKotlinBinaryDependencyKt {
    @Nullable
    public static final DataNode<? extends LibraryDependencyData> addDependency(@NotNull DataNode<GradleSourceSetData> $this$addDependency, @NotNull IdeaKotlinBinaryDependency dependency) {
        Intrinsics.checkNotNullParameter($this$addDependency, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        DataNode dataNode = DependencyNodeUtilsKt.findLibraryDependencyNode($this$addDependency, dependency);
        if (dataNode == null) {
            DataNode<GradleSourceSetData> $this$addDependency_u24lambda_u240 = $this$addDependency;
            boolean bl = false;
            IdeaKotlinBinaryCoordinates ideaKotlinBinaryCoordinates = dependency.getCoordinates();
            if (ideaKotlinBinaryCoordinates == null) {
                return null;
            }
            IdeaKotlinBinaryCoordinates coordinates = ideaKotlinBinaryCoordinates;
            LibraryData libraryData = KotlinLibraryNameKt.LibraryData-Ghqk1Vg(KotlinLibraryNameKt.KotlinLibraryName(coordinates), dependency instanceof IdeaKotlinUnresolvedBinaryDependency);
            LibraryLevel libraryLevel = PrimitiveExtrasKt.isIdeaProjectLevel((IdeaKotlinBinaryDependency)dependency) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
            libraryData.setGroup(coordinates.getGroup());
            libraryData.setArtifactId(coordinates.getModule());
            libraryData.setVersion(coordinates.getVersion());
            libraryData.setInternalName("Gradle: " + coordinates.getDisplayString());
            DataNode dataNode2 = $this$addDependency_u24lambda_u240.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)new LibraryDependencyData((ModuleData)$this$addDependency_u24lambda_u240.getData(), libraryData, libraryLevel));
            dataNode = dataNode2;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"run(...)");
        }
        DataNode dependencyNode = dataNode;
        if (PrimitiveExtrasKt.isIdeaProjectLevel((IdeaKotlinBinaryDependency)dependency)) {
            ((LibraryDependencyData)dependencyNode.getData()).setLevel(LibraryLevel.PROJECT);
            GradleProjectResolverUtil.linkProjectLibrary((DataNode)$this$addDependency.getParent(ProjectData.class), (LibraryData)((LibraryData)((LibraryDependencyData)dependencyNode.getData()).getTarget()));
        }
        if (PrimitiveExtrasKt.isNativeDistribution((IdeaKotlinBinaryDependency)dependency)) {
            ((LibraryData)((LibraryDependencyData)dependencyNode.getData()).getTarget()).setInternalName(AddIdeaKotlinBinaryDependencyKt.buildNativeDistributionInternalLibraryName(dependency));
        }
        if (dependency instanceof IdeaKotlinResolvedBinaryDependency) {
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            if (IdeaKotlinBinaryDependencyKt.isKotlinCompileBinaryType((IdeaKotlinResolvedBinaryDependency)((IdeaKotlinResolvedBinaryDependency)dependency))) {
                $this$forEach$iv = (Iterable)((IdeaKotlinResolvedBinaryDependency)dependency).getClasspath();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file = (File)element$iv;
                    boolean bl = false;
                    AddIdeaKotlinBinaryDependencyKt.addToDependencyNode(file, dependencyNode, LibraryPathType.BINARY);
                }
            }
            $this$forEach$iv = (Iterable)SourcesAndDocumentationExtrasKt.getSourcesClasspath((IdeaKotlinBinaryDependency)dependency);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                AddIdeaKotlinBinaryDependencyKt.addToDependencyNode(file, dependencyNode, LibraryPathType.SOURCE);
            }
            $this$forEach$iv = (Iterable)SourcesAndDocumentationExtrasKt.getDocumentationClasspath((IdeaKotlinBinaryDependency)dependency);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file = (File)element$iv;
                boolean bl = false;
                AddIdeaKotlinBinaryDependencyKt.addToDependencyNode(file, (DataNode<? extends LibraryDependencyData>)dependencyNode, LibraryPathType.DOC);
            }
        }
        return dependencyNode;
    }

    private static final void addToDependencyNode(File file, DataNode<? extends LibraryDependencyData> dependencyNode, LibraryPathType libraryPathType) {
        Path path2 = file.toPath().toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        AddIdeaKotlinBinaryDependencyKt.refreshInVFSIfNecessary(path2);
        ((LibraryData)((LibraryDependencyData)dependencyNode.getData()).getTarget()).addPath(libraryPathType, file.getAbsolutePath());
    }

    private static final void refreshInVFSIfNecessary(Path absolutePath) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        if (virtualFileManager2.findFileByNioPath(absolutePath) == null) {
            virtualFileManager2.refreshAndFindFileByNioPath(absolutePath);
        }
    }

    private static final String buildNativeDistributionInternalLibraryName(IdeaKotlinBinaryDependency dependency) {
        StringBuilder stringBuilder;
        block1: {
            KlibExtra klibExtra;
            StringBuilder $this$buildNativeDistributionInternalLibraryName_u24lambda_u245;
            block2: {
                KlibExtra klibExtra2;
                $this$buildNativeDistributionInternalLibraryName_u24lambda_u245 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$buildNativeDistributionInternalLibraryName_u24lambda_u245.append("Kotlin/Native");
                $this$buildNativeDistributionInternalLibraryName_u24lambda_u245.append(": ");
                IdeaKotlinBinaryCoordinates ideaKotlinBinaryCoordinates = dependency.getCoordinates();
                $this$buildNativeDistributionInternalLibraryName_u24lambda_u245.append(ideaKotlinBinaryCoordinates != null ? ideaKotlinBinaryCoordinates.getModule() : null);
                if (UtilsKt.ifNull(PrimitiveExtrasKt.isNativeStdlib((IdeaKotlinBinaryDependency)dependency), false)) break block1;
                KlibExtra klibExtra3 = KlibExtraKt.getKlibExtra((IdeaKotlinBinaryDependency)dependency);
                if (klibExtra3 == null) break block1;
                klibExtra = klibExtra2 = klibExtra3;
                boolean bl2 = false;
                if (klibExtra.getCommonizerTarget() == null) break block2;
                $this$buildNativeDistributionInternalLibraryName_u24lambda_u245.append(" | [" + klibExtra.getCommonizerTarget() + "]");
                break block1;
            }
            if (klibExtra.getNativeTargets() == null) break block1;
            List list2 = klibExtra.getNativeTargets();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            $this$buildNativeDistributionInternalLibraryName_u24lambda_u245.append(" | " + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        return stringBuilder.toString();
    }
}

