/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.statistics;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import io.opentelemetry.api.OpenTelemetry;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.statistics.KaStatisticsService;
import org.jetbrains.kotlin.analysis.api.platform.statistics.KotlinOpenTelemetryProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsScheduler;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLStatisticsDomain;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLSymbolProviderStatistics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject$low_level_api_fir", "()Lcom/intellij/openapi/project/Project;", "scheduler", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsScheduler;", "getScheduler$low_level_api_fir", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsScheduler;", "analysisSessions", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessions", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "symbolProviders", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLSymbolProviderStatistics;", "getSymbolProviders$low_level_api_fir", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLSymbolProviderStatistics;", "domains", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLStatisticsDomain;", "getDomains$low_level_api_fir", "()Ljava/util/List;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "getOpenTelemetry$low_level_api_fir", "()Lio/opentelemetry/api/OpenTelemetry;", "hasStarted", "", "start", "", "dispose", "Companion", "low-level-api-fir"})
public final class LLStatisticsService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LLStatisticsScheduler scheduler;
    @NotNull
    private final LLAnalysisSessionStatistics analysisSessions;
    @NotNull
    private final LLSymbolProviderStatistics symbolProviders;
    @NotNull
    private final List<LLStatisticsDomain> domains;
    private boolean hasStarted;

    public LLStatisticsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.scheduler = new LLStatisticsScheduler(this);
        this.analysisSessions = new LLAnalysisSessionStatistics(this);
        this.symbolProviders = new LLSymbolProviderStatistics(this);
        Object[] objectArray = new LLStatisticsDomain[]{this.analysisSessions, this.symbolProviders};
        this.domains = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Project getProject$low_level_api_fir() {
        return this.project;
    }

    @NotNull
    public final LLStatisticsScheduler getScheduler$low_level_api_fir() {
        return this.scheduler;
    }

    @NotNull
    public final LLAnalysisSessionStatistics getAnalysisSessions() {
        return this.analysisSessions;
    }

    @NotNull
    public final LLSymbolProviderStatistics getSymbolProviders$low_level_api_fir() {
        return this.symbolProviders;
    }

    @NotNull
    public final List<LLStatisticsDomain> getDomains$low_level_api_fir() {
        return this.domains;
    }

    @NotNull
    public final OpenTelemetry getOpenTelemetry$low_level_api_fir() {
        KotlinOpenTelemetryProvider kotlinOpenTelemetryProvider = KotlinOpenTelemetryProvider.Companion.getInstance(this.project);
        if (kotlinOpenTelemetryProvider == null || (kotlinOpenTelemetryProvider = kotlinOpenTelemetryProvider.getOpenTelemetry()) == null) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(LLStatisticsService.class).getSimpleName() + " should not be used when OpenTelemetry is not available.").toString());
        }
        return kotlinOpenTelemetryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        LLStatisticsService lLStatisticsService = this;
        synchronized (lLStatisticsService) {
            boolean bl = false;
            if (this.hasStarted) {
                return;
            }
            this.scheduler.schedule();
            this.hasStarted = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LLStatisticsService lLStatisticsService = this;
        synchronized (lLStatisticsService) {
            boolean bl = false;
            if (this.hasStarted) {
                this.scheduler.cancel();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService;", "project", "Lcom/intellij/openapi/project/Project;", "low-level-api-fir"})
    @SourceDebugExtension(value={"SMAP\nLLStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLStatisticsService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,88:1\n31#2,2:89\n*S KotlinDebug\n*F\n+ 1 LLStatisticsService.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/LLStatisticsService$Companion\n*L\n84#1:89,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LLStatisticsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!KaStatisticsService.Companion.getAreStatisticsEnabled()) {
                return null;
            }
            KotlinOpenTelemetryProvider kotlinOpenTelemetryProvider = KotlinOpenTelemetryProvider.Companion.getInstance(project);
            if ((kotlinOpenTelemetryProvider != null ? kotlinOpenTelemetryProvider.getOpenTelemetry() : null) == null) {
                return null;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LLStatisticsService> serviceClass$iv = LLStatisticsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LLStatisticsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

