/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.CoreJavaCodeStyleManager;
import com.intellij.core.CoreJavaCodeStyleSettingsFacade;
import com.intellij.core.CoreJavaFileCodeStyleFacade;
import com.intellij.core.CoreJavaFileManager;
import com.intellij.core.CoreJavaPsiImplementationHelper;
import com.intellij.core.CoreLanguageLevelProjectExtension;
import com.intellij.core.CorePackageIndex;
import com.intellij.core.CoreProjectEnvironment;
import com.intellij.lang.jvm.facade.JvmFacade;
import com.intellij.lang.jvm.facade.JvmFacadeImpl;
import com.intellij.mock.MockFileIndexFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JvmPsiConversionHelper;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.JvmPsiConversionHelperImpl;
import com.intellij.psi.impl.PsiElementFactoryImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JavaCoreProjectEnvironment
extends CoreProjectEnvironment {
    private final JavaFileManager myFileManager;
    private final PackageIndex myPackageIndex;

    public JavaCoreProjectEnvironment(@NotNull Disposable parentDisposable, @NotNull CoreApplicationEnvironment applicationEnvironment) {
        if (parentDisposable == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(0);
        }
        if (applicationEnvironment == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(1);
        }
        super(parentDisposable, applicationEnvironment);
        this.project.registerService(PsiElementFactory.class, (Object)new PsiElementFactoryImpl((Project)this.project));
        this.project.registerService(JavaPsiImplementationHelper.class, (Object)this.createJavaPsiImplementationHelper());
        this.project.registerService(PsiResolveHelper.class, (Object)new PsiResolveHelperImpl((Project)this.project));
        this.project.registerService(LanguageLevelProjectExtension.class, (Object)new CoreLanguageLevelProjectExtension());
        this.project.registerService(JavaResolveCache.class, (Object)new JavaResolveCache((Project)this.project));
        this.project.registerService(JavaCodeStyleSettingsFacade.class, (Object)new CoreJavaCodeStyleSettingsFacade());
        this.project.registerService(JavaFileCodeStyleFacade.class, (Object)new CoreJavaFileCodeStyleFacade());
        this.project.registerService(JavaCodeStyleManager.class, (Object)new CoreJavaCodeStyleManager());
        this.project.registerService(ControlFlowFactory.class, (Object)new ControlFlowFactory((Project)this.project));
        this.myPackageIndex = this.createCorePackageIndex();
        this.project.registerService(PackageIndex.class, (Object)this.myPackageIndex);
        this.myFileManager = this.createCoreFileManager();
        this.project.registerService(JavaFileManager.class, (Object)this.myFileManager);
        this.project.registerService(JvmPsiConversionHelper.class, (Object)new JvmPsiConversionHelperImpl());
        this.registerJavaPsiFacade();
        this.project.registerService(JvmFacade.class, (Object)new JvmFacadeImpl((Project)this.project));
    }

    protected void registerJavaPsiFacade() {
        JavaPsiFacadeImpl javaPsiFacade = new JavaPsiFacadeImpl((Project)this.project, null);
        this.project.registerService(JavaPsiFacade.class, (Object)javaPsiFacade);
    }

    protected CoreJavaPsiImplementationHelper createJavaPsiImplementationHelper() {
        return new CoreJavaPsiImplementationHelper((Project)this.project);
    }

    protected JavaFileManager createCoreFileManager() {
        return new CoreJavaFileManager((PsiManager)this.myPsiManager);
    }

    protected PackageIndex createCorePackageIndex() {
        return new CorePackageIndex();
    }

    public void addJarToClassPath(File path) {
        assert (path.isFile());
        VirtualFile root = this.getEnvironment().getJarFileSystem().findFileByPath(path + "!/");
        if (root == null) {
            throw new IllegalArgumentException("trying to add non-existing file to classpath: " + path);
        }
        this.addSourcesToClasspath(root);
    }

    public void addSourcesToClasspath(@NotNull VirtualFile root) {
        if (root == null) {
            JavaCoreProjectEnvironment.$$$reportNull$$$0(2);
        }
        assert (root.isDirectory());
        ((CoreJavaFileManager)this.myFileManager).addToClasspath(root);
        ((CorePackageIndex)this.myPackageIndex).addToClasspath(root);
        ((MockFileIndexFacade)this.myFileIndexFacade).addLibraryRoot(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationEnvironment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        objectArray2[1] = "com/intellij/core/JavaCoreProjectEnvironment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourcesToClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

