/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.compat;

import com.intellij.maven.server.m40.compat.MavenContextFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.api.cli.InvokerException;
import org.apache.maven.api.cli.InvokerRequest;
import org.apache.maven.api.services.Lookup;
import org.apache.maven.cling.invoker.mvn.MavenContext;
import org.apache.maven.cling.invoker.mvn.MavenInvoker;

public class CompatResidentMavenInvoker
extends MavenInvoker {
    private final ConcurrentHashMap<String, MavenContext> residentContext = new ConcurrentHashMap();

    public CompatResidentMavenInvoker(Lookup protoLookup) {
        super(protoLookup, null);
    }

    public void close() throws InvokerException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (MavenContext context : this.residentContext.values()) {
            try {
                context.doCloseContainer();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            InvokerException exception = new InvokerException("Could not cleanly shut down context pool");
            exceptions.forEach(arg_0 -> exception.addSuppressed(arg_0));
            throw exception;
        }
    }

    protected MavenContext createContext(InvokerRequest invokerRequest) {
        MavenContext result = this.residentContext.computeIfAbsent("resident", k -> MavenContextFactory.createMavenContext(invokerRequest));
        return this.copyIfDifferent(result, invokerRequest);
    }

    protected MavenContext copyIfDifferent(MavenContext mavenContext, InvokerRequest invokerRequest) {
        if (invokerRequest == mavenContext.invokerRequest) {
            return mavenContext;
        }
        MavenContext shadow = MavenContextFactory.createMavenContext(invokerRequest);
        shadow.containerCapsule = mavenContext.containerCapsule;
        shadow.lookup = mavenContext.lookup;
        shadow.eventSpyDispatcher = mavenContext.eventSpyDispatcher;
        shadow.maven = mavenContext.maven;
        return shadow;
    }
}

