/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server;

import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelConfigFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelConfigFactoryKt;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.ReplCompilerMode;
import org.jetbrains.kotlinx.jupyter.api.libraries.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.startup.KernelConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013j\u0002`\u0016H$J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0004\u001a\u00020\u0005H$\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/AbstractKotlinKernelConfigFactory;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/KernelConfigFactory;", "project", "Lcom/intellij/openapi/project/Project;", "notebookPath", "Ljava/nio/file/Path;", "replCompilerMode", "Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNotebookPath", "()Ljava/nio/file/Path;", "getReplCompilerMode", "()Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "create", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelConfig;", "getKernelPorts", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/JupyterSocketType;", "", "Lorg/jetbrains/kotlinx/jupyter/startup/KernelPorts;", "getDebugPortOrNull", "(Ljava/nio/file/Path;)Ljava/lang/Integer;", "getClasspath", "", "Ljava/io/File;", "getJvmTargetForSnippets", "Lcom/intellij/util/lang/JavaVersion;", "intellij.kotlin.jupyter.core"})
public abstract class AbstractKotlinKernelConfigFactory
implements KernelConfigFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Path notebookPath;
    @NotNull
    private final ReplCompilerMode replCompilerMode;

    public AbstractKotlinKernelConfigFactory(@NotNull Project project, @NotNull Path notebookPath, @NotNull ReplCompilerMode replCompilerMode2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        Intrinsics.checkNotNullParameter((Object)replCompilerMode2, (String)"replCompilerMode");
        this.project = project;
        this.notebookPath = notebookPath;
        this.replCompilerMode = replCompilerMode2;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Path getNotebookPath() {
        return this.notebookPath;
    }

    @NotNull
    protected final ReplCompilerMode getReplCompilerMode() {
        return this.replCompilerMode;
    }

    @Override
    @NotNull
    public final KernelConfig create() {
        JavaVersion javaVersion = this.getJvmTargetForSnippets(this.project);
        return new KernelConfig(null, this.getKernelPorts(), "tcp", "HmacSHA256", "x-x-x", this.getClasspath(), null, this.getDebugPortOrNull(this.notebookPath), "KOTLIN_NOTEBOOK", javaVersion != null ? javaVersion.toFeatureString() : null, this.replCompilerMode, 1, null);
    }

    @NotNull
    protected abstract Map<JupyterSocketType, Integer> getKernelPorts();

    @Nullable
    protected abstract Integer getDebugPortOrNull(@NotNull Path var1);

    @NotNull
    protected List<File> getClasspath() {
        return KernelConfigFactoryKt.access$getClasspathArtifacts(KotlinNotebookMavenArtifactsDownloader.Companion.getInstance(this.project), this.project);
    }

    @Nullable
    protected JavaVersion getJvmTargetForSnippets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LanguageLevel languageLevel = KernelConfigFactoryKt.chooseJvmTargetForSnippets(project);
        return languageLevel != null ? languageLevel.toJavaVersion() : null;
    }
}

