/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.diagnostic.FreezeProfiler;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.ultimate.async.AsyncFreezeProfilerKt;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.profiler.AsyncProfiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u0011H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\"2\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\u0011H\u0002R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\t\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncFreezeProfiler;", "Lcom/intellij/diagnostic/FreezeProfiler;", "<init>", "()V", "profiler", "Lone/profiler/AsyncProfiler;", "getProfiler", "()Lone/profiler/AsyncProfiler;", "profiler$delegate", "Lkotlin/Lazy;", "event", "", "getEvent$annotations", "getEvent", "()Ljava/lang/String;", "event$delegate", "disabledOnError", "", "DEBUG", "createSnapshotAttachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "file", "Ljava/nio/file/Path;", "start", "", "dir", "stop", "reportTimeout", "startNs", "", "timeoutSec", "", "checkCpuEventAvailable", "getAttachments", "", "reportDir", "checkCrash", "crashContent", "disabled", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncFreezeProfiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncFreezeProfiler.kt\ncom/intellij/profiler/ultimate/async/AsyncFreezeProfiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,177:1\n1#2:178\n212#3,12:179\n37#4:191\n36#4,3:192\n*S KotlinDebug\n*F\n+ 1 AsyncFreezeProfiler.kt\ncom/intellij/profiler/ultimate/async/AsyncFreezeProfiler\n*L\n104#1:179,12\n145#1:191\n145#1:192,3\n*E\n"})
final class AsyncFreezeProfiler
implements FreezeProfiler {
    @NotNull
    private final Lazy profiler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AsyncProfiler>((Object)AsyncProfilerExtractor.INSTANCE){

        public final AsyncProfiler invoke() {
            return ((AsyncProfilerExtractor)this.receiver).getAsyncProfilerInstance();
        }
    }));
    @NotNull
    private final Lazy event$delegate = LazyKt.lazy(() -> AsyncFreezeProfiler.event_delegate$lambda$0(this));
    private volatile boolean disabledOnError;
    private boolean DEBUG;

    public AsyncFreezeProfiler() {
        if (!this.DEBUG) {
            Application app = ApplicationManager.getApplication();
            if (PluginManagerCore.isRunningFromSources() || !app.isEAP() && !app.isInternal()) {
                throw ExtensionNotApplicableException.create();
            }
        }
    }

    private final AsyncProfiler getProfiler() {
        Lazy lazy = this.profiler$delegate;
        return (AsyncProfiler)lazy.getValue();
    }

    private final String getEvent() {
        Lazy lazy = this.event$delegate;
        return (String)lazy.getValue();
    }

    private static /* synthetic */ void getEvent$annotations() {
    }

    private final Attachment createSnapshotAttachment(Path file) {
        Attachment attachment;
        Attachment it = attachment = new Attachment("snapshot.jfr", file, "CPU Profiler snapshot");
        boolean bl = false;
        it.setIncluded(true);
        return attachment;
    }

    public void start(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.disabled()) {
            return;
        }
        String path = NioPathUtil.toCanonicalPath((Path)dir);
        if (!AsyncFreezeProfilerKt.access$getCurrentSession$p().compareAndSet(null, path)) {
            AsyncFreezeProfilerKt.access$getLOG().error("Cannot start profiling. Another session is already running.");
            return;
        }
        String cmd = null;
        try {
            Object object;
            String eventAdjusted;
            block8: {
                block7: {
                    eventAdjusted = Registry.Companion.is("freeze.reporter.profiling.all.threads") ? "wall" : this.getEvent();
                    object = AsyncProfilerExtractor.dbgHelpOption();
                    if (object == null) break block7;
                    String it = object;
                    boolean bl = false;
                    String string = "," + it;
                    object = string;
                    if (string != null) break block8;
                }
                object = "";
            }
            String dbgHelpOption = object;
            cmd = "start,interval=10ms,event=" + eventAdjusted + ",jfr,chunktime=10s,file=" + dir.resolve("snapshot.jfr") + dbgHelpOption;
            AsyncProfiler profiler2 = this.getProfiler();
            Object object2 = profiler2 != null ? profiler2.execute(cmd) : Boolean.valueOf(AsyncFreezeProfilerKt.access$getCurrentSession$p().compareAndSet(path, null));
        }
        catch (Exception e) {
            this.disabledOnError = true;
            AsyncFreezeProfilerKt.access$getCurrentSession$p().compareAndSet(path, null);
            AsyncFreezeProfilerKt.access$getLOG().warn(StringsKt.trimMargin$default((String)("\"\n        |Error starting async-profiler: " + cmd + "\n        |Async-profiler path: " + AsyncProfilerExtractor.getNativeAgentPath$default((AsyncProfilerExtractor)AsyncProfilerExtractor.INSTANCE, null, (int)1, null) + "\n      "), null, (int)1, null), (Throwable)e);
        }
    }

    public void stop(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.disabled()) {
            return;
        }
        String path = NioPathUtil.toCanonicalPath((Path)dir);
        if (!Intrinsics.areEqual(AsyncFreezeProfilerKt.access$getCurrentSession$p().get(), (Object)path)) {
            AsyncFreezeProfilerKt.access$getLOG().debug("Cannot stop profiling. Another session is running.");
            return;
        }
        int timeoutSec = 20;
        Ref.LongRef startNs = new Ref.LongRef();
        startNs.element = -1L;
        try {
            boolean $i$f$runAsync = false;
            AsyncPromise promise$iv = new AsyncPromise();
            AppExecutorUtil.getAppExecutorService().execute(new Runnable(promise$iv, startNs, this, path){
                final /* synthetic */ AsyncPromise $promise;
                final /* synthetic */ Ref.LongRef $startNs$inlined;
                final /* synthetic */ AsyncFreezeProfiler this$0;
                final /* synthetic */ String $path$inlined;
                {
                    this.$promise = $promise;
                    this.$startNs$inlined = longRef;
                    this.this$0 = asyncFreezeProfiler;
                    this.$path$inlined = string;
                }

                public final void run() {
                    Long l;
                    try {
                        boolean bl = false;
                        this.$startNs$inlined.element = System.nanoTime();
                        boolean $i$f$measureNanoTime = false;
                        long start$iv = System.nanoTime();
                        boolean bl2 = false;
                        AsyncProfiler asyncProfiler = AsyncFreezeProfiler.access$getProfiler(this.this$0);
                        if (asyncProfiler != null) {
                            asyncProfiler.stop();
                        }
                        AsyncFreezeProfilerKt.access$getCurrentSession$p().compareAndSet(this.$path$inlined, null);
                        l = System.nanoTime() - start$iv;
                    }
                    catch (Throwable e) {
                        this.$promise.setError(e);
                        return;
                    }
                    Long result = l;
                    this.$promise.setResult((Object)result);
                }
            });
            Long stopExecutionTime = (Long)((Promise)promise$iv).blockingGet(timeoutSec, TimeUnit.SECONDS);
            if (stopExecutionTime != null) {
                AsyncFreezeProfilerKt.access$getLOG().debug("Freeze profiler stop took " + TimeUnit.NANOSECONDS.toMillis(stopExecutionTime) + "ms");
            }
        }
        catch (TimeoutException timeoutException) {
            this.disabledOnError = true;
            this.reportTimeout(startNs.element, timeoutSec);
        }
        catch (Exception e) {
            this.disabledOnError = true;
            AsyncFreezeProfilerKt.access$getLOG().error((Throwable)e);
        }
    }

    private final void reportTimeout(long startNs, int timeoutSec) {
        Object object;
        List attachments = new ArrayList();
        long executionTime = -1L;
        if (startNs != -1L) {
            executionTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            AsyncFreezeProfiler asyncFreezeProfiler = this;
            try {
                StringWriter stringWriter;
                AsyncFreezeProfiler $this$reportTimeout_u24lambda_u247 = asyncFreezeProfiler;
                boolean bl = false;
                Object[] threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
                StringWriter it = stringWriter = new StringWriter();
                boolean bl2 = false;
                Iterator iterator2 = ArrayIteratorKt.iterator((Object[])threadInfos);
                while (iterator2.hasNext()) {
                    ThreadInfo threadInfo = (ThreadInfo)iterator2.next();
                    ThreadDumper.dumpThreadInfo((ThreadInfo)threadInfo, (Writer)it);
                }
                String string = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String threadDump = string;
                StringWriter $this$reportTimeout_u24lambda_u247_u24lambda_u246 = stringWriter = new Attachment("stopThreadDump.txt", threadDump);
                boolean bl3 = false;
                $this$reportTimeout_u24lambda_u247_u24lambda_u246.setIncluded(true);
                StringWriter attachment = stringWriter;
                object = Result.constructor-impl((Object)attachments.add(attachment));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
        }
        String message = StringsKt.trimIndent((String)("\n          Timeout while stopping freeze profiler (" + timeoutSec + " seconds).\n          Executed for: " + executionTime + " ms\n        "));
        Collection $this$toTypedArray$iv = attachments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        object = thisCollection$iv.toArray(new Attachment[0]);
        AsyncFreezeProfilerKt.access$getLOG().error(message, new Throwable(message), Arrays.copyOf(object, ((Attachment[])object).length));
    }

    private final boolean checkCpuEventAvailable() {
        boolean bl;
        try {
            Object object = this.getProfiler();
            bl = object != null && (object = object.execute("check,event=cpu")) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"OK", (boolean)false, (int)2, null) : true;
        }
        catch (Exception e) {
            AsyncFreezeProfilerKt.access$getLOG().warn((Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<Attachment> getAttachments(@NotNull Path reportDir) {
        Path snapshot;
        Intrinsics.checkNotNullParameter((Object)reportDir, (String)"reportDir");
        if (!this.disabledOnError && Files.exists(snapshot = reportDir.resolve("snapshot.jfr"), new LinkOption[0]) && Files.size(snapshot) > 16L) {
            Intrinsics.checkNotNull((Object)snapshot);
            return CollectionsKt.listOf((Object)this.createSnapshotAttachment(snapshot));
        }
        return CollectionsKt.emptyList();
    }

    public void checkCrash(@NotNull String crashContent) {
        Intrinsics.checkNotNullParameter((Object)crashContent, (String)"crashContent");
        CharSequence charSequence = crashContent;
        String string = this.getClass().getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalName(...)");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) {
            AsyncFreezeProfilerKt.access$getLOG().info("Disable AsyncFreezeProfiler (freeze.reporter.profiling registry) due to is caused a crash");
            Registry.Companion.get("freeze.reporter.profiling").setValue(false);
        }
    }

    private final boolean disabled() {
        return this.disabledOnError || !Registry.Companion.is("freeze.reporter.profiling", false);
    }

    private static final String event_delegate$lambda$0(AsyncFreezeProfiler this$0) {
        return SystemInfoRt.isLinux && !this$0.checkCpuEventAvailable() ? "itimer" : "cpu";
    }

    public static final /* synthetic */ AsyncProfiler access$getProfiler(AsyncFreezeProfiler $this) {
        return $this.getProfiler();
    }
}

