/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClassKt;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrMemberWithContainerSource;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@PhaseDescription(name="ExternalPackageParentPatcherLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ExternalPackageParentPatcherLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Visitor", "backend.jvm.lower"})
public final class ExternalPackageParentPatcherLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public ExternalPackageParentPatcherLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        if (this.context.getConfig().getUseFir()) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irFile), (IrVisitorVoid)new Visitor());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ExternalPackageParentPatcherLowering$Visitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/lower/ExternalPackageParentPatcherLowering;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitMemberAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "generateOrGetFacadeClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "deserializeTopLevelClass", "", "irClass", "handleProperty", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "newParent", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nExternalPackageParentPatcherLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalPackageParentPatcherLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/ExternalPackageParentPatcherLowering$Visitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    private final class Visitor
    extends IrVisitorVoid {
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
        }

        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            block3: {
                IrClass parentClass;
                IrMemberWithContainerSource callee;
                IrSymbolOwner irSymbolOwner;
                block4: {
                    Intrinsics.checkNotNullParameter(expression2, (String)"expression");
                    this.visitElement((IrElement)expression2);
                    irSymbolOwner = expression2.getSymbol().getOwner();
                    IrMemberWithContainerSource irMemberWithContainerSource = irSymbolOwner instanceof IrMemberWithContainerSource ? (IrMemberWithContainerSource)irSymbolOwner : null;
                    if (irMemberWithContainerSource == null) {
                        return;
                    }
                    callee = irMemberWithContainerSource;
                    if (!(callee.getParent() instanceof IrExternalPackageFragment)) break block3;
                    IrClass irClass = this.generateOrGetFacadeClass(callee);
                    if (irClass == null) {
                        return;
                    }
                    parentClass = irClass;
                    parentClass.setParent(callee.getParent());
                    callee.setParent((IrDeclarationParent)parentClass);
                    irSymbolOwner = callee;
                    if (!(irSymbolOwner instanceof IrProperty)) break block4;
                    this.handleProperty((IrProperty)callee, parentClass);
                    break block3;
                }
                if (!(irSymbolOwner instanceof IrSimpleFunction)) break block3;
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)callee).getCorrespondingPropertySymbol();
                if (irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null) {
                    IrPropertySymbol it = irPropertySymbol;
                    boolean bl = false;
                    this.handleProperty((IrProperty)it, parentClass);
                }
            }
        }

        private final IrClass generateOrGetFacadeClass(IrMemberWithContainerSource declaration) {
            IrClass irClass;
            DeserializedContainerSource deserializedContainerSource = declaration.getContainerSource();
            if (deserializedContainerSource == null) {
                return null;
            }
            DeserializedContainerSource deserializedSource = deserializedContainerSource;
            if (!(deserializedSource instanceof FacadeClassSource)) {
                return null;
            }
            JvmClassName jvmClassName = ((FacadeClassSource)deserializedSource).getFacadeClassName();
            if (jvmClassName == null) {
                jvmClassName = ((FacadeClassSource)deserializedSource).getClassName();
            }
            JvmClassName facadeName = jvmClassName;
            IrClass it = irClass = JvmFileFacadeClassKt.createJvmFileFacadeClass((IrDeclarationOrigin)(((FacadeClassSource)deserializedSource).getFacadeClassName() != null ? IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS() : IrDeclarationOrigin.Companion.getFILE_CLASS()), facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName(), (SourceElement)deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)arg_0 -> Visitor.generateOrGetFacadeClass$lambda$1(this, arg_0)));
            boolean bl = false;
            IrUtilsKt.createThisReceiverParameter((IrClass)it);
            JvmIrAttributesKt.setClassNameOverride(it, facadeName);
            return irClass;
        }

        private final boolean deserializeTopLevelClass(IrClass irClass) {
            return ExternalPackageParentPatcherLowering.this.getContext().getIrDeserializer().deserializeTopLevelClass(irClass, ExternalPackageParentPatcherLowering.this.getContext().getIrBuiltIns(), ExternalPackageParentPatcherLowering.this.getContext().getSymbolTable(), ExternalPackageParentPatcherLowering.this.getContext().getIrProviders(), ExternalPackageParentPatcherLowering.this.getContext().getGeneratorExtensions());
        }

        private final void handleProperty(IrProperty property2, IrClass newParent) {
            block2: {
                property2.setParent((IrDeclarationParent)newParent);
                IrSimpleFunction irSimpleFunction = property2.getGetter();
                if (irSimpleFunction != null) {
                    irSimpleFunction.setParent((IrDeclarationParent)newParent);
                }
                IrSimpleFunction irSimpleFunction2 = property2.getSetter();
                if (irSimpleFunction2 != null) {
                    irSimpleFunction2.setParent((IrDeclarationParent)newParent);
                }
                IrField irField = property2.getBackingField();
                if (irField == null) break block2;
                irField.setParent((IrDeclarationParent)newParent);
            }
        }

        private static final boolean generateOrGetFacadeClass$lambda$1(Visitor this$0, IrClass irClass) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            return this$0.deserializeTopLevelClass(irClass);
        }
    }
}

