// automatically generated by the FlatBuffers compiler, do not modify


#ifndef FLATBUFFERS_GENERATED_GRAPH_HIPDNN_SDK_DATA_OBJECTS_H_
#define FLATBUFFERS_GENERATED_GRAPH_HIPDNN_SDK_DATA_OBJECTS_H_

#include "flatbuffers/flatbuffers.h"

// Ensure the included flatbuffers.h is the same version as when this file was
// generated, otherwise it may not be compatible.
static_assert(FLATBUFFERS_VERSION_MAJOR == 25 &&
              FLATBUFFERS_VERSION_MINOR == 9 &&
              FLATBUFFERS_VERSION_REVISION == 23,
             "Non-compatible flatbuffers version included");

#include "batchnorm_attributes_generated.h"
#include "batchnorm_backward_attributes_generated.h"
#include "batchnorm_inference_attributes_generated.h"
#include "convolution_bwd_attributes_generated.h"
#include "convolution_fwd_attributes_generated.h"
#include "data_types_generated.h"
#include "pointwise_attributes_generated.h"
#include "tensor_attributes_generated.h"

namespace hipdnn_sdk {
namespace data_objects {

struct Node;
struct NodeBuilder;
struct NodeT;

struct Graph;
struct GraphBuilder;
struct GraphT;

bool operator==(const NodeT &lhs, const NodeT &rhs);
bool operator!=(const NodeT &lhs, const NodeT &rhs);
bool operator==(const GraphT &lhs, const GraphT &rhs);
bool operator!=(const GraphT &lhs, const GraphT &rhs);

enum class NodeAttributes : uint8_t {
  NONE = 0,
  BatchnormInferenceAttributes = 1,
  PointwiseAttributes = 2,
  BatchnormBackwardAttributes = 3,
  BatchnormAttributes = 4,
  ConvolutionFwdAttributes = 5,
  ConvolutionBwdAttributes = 6,
  MIN = NONE,
  MAX = ConvolutionBwdAttributes
};

inline const NodeAttributes (&EnumValuesNodeAttributes())[7] {
  static const NodeAttributes values[] = {
    NodeAttributes::NONE,
    NodeAttributes::BatchnormInferenceAttributes,
    NodeAttributes::PointwiseAttributes,
    NodeAttributes::BatchnormBackwardAttributes,
    NodeAttributes::BatchnormAttributes,
    NodeAttributes::ConvolutionFwdAttributes,
    NodeAttributes::ConvolutionBwdAttributes
  };
  return values;
}

inline const char * const *EnumNamesNodeAttributes() {
  static const char * const names[8] = {
    "NONE",
    "BatchnormInferenceAttributes",
    "PointwiseAttributes",
    "BatchnormBackwardAttributes",
    "BatchnormAttributes",
    "ConvolutionFwdAttributes",
    "ConvolutionBwdAttributes",
    nullptr
  };
  return names;
}

inline const char *EnumNameNodeAttributes(NodeAttributes e) {
  if (::flatbuffers::IsOutRange(e, NodeAttributes::NONE, NodeAttributes::ConvolutionBwdAttributes)) return "";
  const size_t index = static_cast<size_t>(e);
  return EnumNamesNodeAttributes()[index];
}

template<typename T> struct NodeAttributesTraits {
  static const NodeAttributes enum_value = NodeAttributes::NONE;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::BatchnormInferenceAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormInferenceAttributes;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::PointwiseAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::PointwiseAttributes;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::BatchnormBackwardAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormBackwardAttributes;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::BatchnormAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormAttributes;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::ConvolutionFwdAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::ConvolutionFwdAttributes;
};

template<> struct NodeAttributesTraits<hipdnn_sdk::data_objects::ConvolutionBwdAttributes> {
  static const NodeAttributes enum_value = NodeAttributes::ConvolutionBwdAttributes;
};

template<typename T> struct NodeAttributesUnionTraits {
  static const NodeAttributes enum_value = NodeAttributes::NONE;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::BatchnormInferenceAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormInferenceAttributes;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::PointwiseAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::PointwiseAttributes;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::BatchnormBackwardAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormBackwardAttributes;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::BatchnormAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::BatchnormAttributes;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::ConvolutionFwdAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::ConvolutionFwdAttributes;
};

template<> struct NodeAttributesUnionTraits<hipdnn_sdk::data_objects::ConvolutionBwdAttributesT> {
  static const NodeAttributes enum_value = NodeAttributes::ConvolutionBwdAttributes;
};

struct NodeAttributesUnion {
  NodeAttributes type;
  void *value;

  NodeAttributesUnion() : type(NodeAttributes::NONE), value(nullptr) {}
  NodeAttributesUnion(NodeAttributesUnion&& u) FLATBUFFERS_NOEXCEPT :
    type(NodeAttributes::NONE), value(nullptr)
    { std::swap(type, u.type); std::swap(value, u.value); }
  NodeAttributesUnion(const NodeAttributesUnion &);
  NodeAttributesUnion &operator=(const NodeAttributesUnion &u)
    { NodeAttributesUnion t(u); std::swap(type, t.type); std::swap(value, t.value); return *this; }
  NodeAttributesUnion &operator=(NodeAttributesUnion &&u) FLATBUFFERS_NOEXCEPT
    { std::swap(type, u.type); std::swap(value, u.value); return *this; }
  ~NodeAttributesUnion() { Reset(); }

  void Reset();

  template <typename T>
  void Set(T&& val) {
    typedef typename std::remove_reference<T>::type RT;
    Reset();
    type = NodeAttributesUnionTraits<RT>::enum_value;
    if (type != NodeAttributes::NONE) {
      value = new RT(std::forward<T>(val));
    }
  }

  static void *UnPack(const void *obj, NodeAttributes type, const ::flatbuffers::resolver_function_t *resolver);
  ::flatbuffers::Offset<void> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr) const;

  hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *AsBatchnormInferenceAttributes() {
    return type == NodeAttributes::BatchnormInferenceAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *AsBatchnormInferenceAttributes() const {
    return type == NodeAttributes::BatchnormInferenceAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(value) : nullptr;
  }
  hipdnn_sdk::data_objects::PointwiseAttributesT *AsPointwiseAttributes() {
    return type == NodeAttributes::PointwiseAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::PointwiseAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::PointwiseAttributesT *AsPointwiseAttributes() const {
    return type == NodeAttributes::PointwiseAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributesT *>(value) : nullptr;
  }
  hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *AsBatchnormBackwardAttributes() {
    return type == NodeAttributes::BatchnormBackwardAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *AsBatchnormBackwardAttributes() const {
    return type == NodeAttributes::BatchnormBackwardAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(value) : nullptr;
  }
  hipdnn_sdk::data_objects::BatchnormAttributesT *AsBatchnormAttributes() {
    return type == NodeAttributes::BatchnormAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::BatchnormAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::BatchnormAttributesT *AsBatchnormAttributes() const {
    return type == NodeAttributes::BatchnormAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributesT *>(value) : nullptr;
  }
  hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *AsConvolutionFwdAttributes() {
    return type == NodeAttributes::ConvolutionFwdAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *AsConvolutionFwdAttributes() const {
    return type == NodeAttributes::ConvolutionFwdAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(value) : nullptr;
  }
  hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *AsConvolutionBwdAttributes() {
    return type == NodeAttributes::ConvolutionBwdAttributes ?
      reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(value) : nullptr;
  }
  const hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *AsConvolutionBwdAttributes() const {
    return type == NodeAttributes::ConvolutionBwdAttributes ?
      reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(value) : nullptr;
  }
};


inline bool operator==(const NodeAttributesUnion &lhs, const NodeAttributesUnion &rhs) {
  if (lhs.type != rhs.type) return false;
  switch (lhs.type) {
    case NodeAttributes::NONE: {
      return true;
    }
    case NodeAttributes::BatchnormInferenceAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(rhs.value));
    }
    case NodeAttributes::PointwiseAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributesT *>(rhs.value));
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(rhs.value));
    }
    case NodeAttributes::BatchnormAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributesT *>(rhs.value));
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(rhs.value));
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      return *(reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(lhs.value)) ==
             *(reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(rhs.value));
    }
    default: {
      return false;
    }
  }
}

inline bool operator!=(const NodeAttributesUnion &lhs, const NodeAttributesUnion &rhs) {
    return !(lhs == rhs);
}

bool VerifyNodeAttributes(::flatbuffers::Verifier &verifier, const void *obj, NodeAttributes type);
bool VerifyNodeAttributesVector(::flatbuffers::Verifier &verifier, const ::flatbuffers::Vector<::flatbuffers::Offset<void>> *values, const ::flatbuffers::Vector<NodeAttributes> *types);

struct NodeT : public ::flatbuffers::NativeTable {
  typedef Node TableType;
  std::string name{};
  hipdnn_sdk::data_objects::NodeAttributesUnion attributes{};
};

struct Node FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef NodeT NativeTableType;
  typedef NodeBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_ATTRIBUTES_TYPE = 6,
    VT_ATTRIBUTES = 8
  };
  const ::flatbuffers::String *name() const {
    return GetPointer<const ::flatbuffers::String *>(VT_NAME);
  }
  ::flatbuffers::String *mutable_name() {
    return GetPointer<::flatbuffers::String *>(VT_NAME);
  }
  hipdnn_sdk::data_objects::NodeAttributes attributes_type() const {
    return static_cast<hipdnn_sdk::data_objects::NodeAttributes>(GetField<uint8_t>(VT_ATTRIBUTES_TYPE, 0));
  }
  const void *attributes() const {
    return GetPointer<const void *>(VT_ATTRIBUTES);
  }
  template<typename T> const T *attributes_as() const;
  const hipdnn_sdk::data_objects::BatchnormInferenceAttributes *attributes_as_BatchnormInferenceAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::BatchnormInferenceAttributes ? static_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributes *>(attributes()) : nullptr;
  }
  const hipdnn_sdk::data_objects::PointwiseAttributes *attributes_as_PointwiseAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::PointwiseAttributes ? static_cast<const hipdnn_sdk::data_objects::PointwiseAttributes *>(attributes()) : nullptr;
  }
  const hipdnn_sdk::data_objects::BatchnormBackwardAttributes *attributes_as_BatchnormBackwardAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::BatchnormBackwardAttributes ? static_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributes *>(attributes()) : nullptr;
  }
  const hipdnn_sdk::data_objects::BatchnormAttributes *attributes_as_BatchnormAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::BatchnormAttributes ? static_cast<const hipdnn_sdk::data_objects::BatchnormAttributes *>(attributes()) : nullptr;
  }
  const hipdnn_sdk::data_objects::ConvolutionFwdAttributes *attributes_as_ConvolutionFwdAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::ConvolutionFwdAttributes ? static_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributes *>(attributes()) : nullptr;
  }
  const hipdnn_sdk::data_objects::ConvolutionBwdAttributes *attributes_as_ConvolutionBwdAttributes() const {
    return attributes_type() == hipdnn_sdk::data_objects::NodeAttributes::ConvolutionBwdAttributes ? static_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributes *>(attributes()) : nullptr;
  }
  void *mutable_attributes() {
    return GetPointer<void *>(VT_ATTRIBUTES);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<uint8_t>(verifier, VT_ATTRIBUTES_TYPE, 1) &&
           VerifyOffset(verifier, VT_ATTRIBUTES) &&
           VerifyNodeAttributes(verifier, attributes(), attributes_type()) &&
           verifier.EndTable();
  }
  NodeT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(NodeT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<Node> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const NodeT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

template<> inline const hipdnn_sdk::data_objects::BatchnormInferenceAttributes *Node::attributes_as<hipdnn_sdk::data_objects::BatchnormInferenceAttributes>() const {
  return attributes_as_BatchnormInferenceAttributes();
}

template<> inline const hipdnn_sdk::data_objects::PointwiseAttributes *Node::attributes_as<hipdnn_sdk::data_objects::PointwiseAttributes>() const {
  return attributes_as_PointwiseAttributes();
}

template<> inline const hipdnn_sdk::data_objects::BatchnormBackwardAttributes *Node::attributes_as<hipdnn_sdk::data_objects::BatchnormBackwardAttributes>() const {
  return attributes_as_BatchnormBackwardAttributes();
}

template<> inline const hipdnn_sdk::data_objects::BatchnormAttributes *Node::attributes_as<hipdnn_sdk::data_objects::BatchnormAttributes>() const {
  return attributes_as_BatchnormAttributes();
}

template<> inline const hipdnn_sdk::data_objects::ConvolutionFwdAttributes *Node::attributes_as<hipdnn_sdk::data_objects::ConvolutionFwdAttributes>() const {
  return attributes_as_ConvolutionFwdAttributes();
}

template<> inline const hipdnn_sdk::data_objects::ConvolutionBwdAttributes *Node::attributes_as<hipdnn_sdk::data_objects::ConvolutionBwdAttributes>() const {
  return attributes_as_ConvolutionBwdAttributes();
}

struct NodeBuilder {
  typedef Node Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_name(::flatbuffers::Offset<::flatbuffers::String> name) {
    fbb_.AddOffset(Node::VT_NAME, name);
  }
  void add_attributes_type(hipdnn_sdk::data_objects::NodeAttributes attributes_type) {
    fbb_.AddElement<uint8_t>(Node::VT_ATTRIBUTES_TYPE, static_cast<uint8_t>(attributes_type), 0);
  }
  void add_attributes(::flatbuffers::Offset<void> attributes) {
    fbb_.AddOffset(Node::VT_ATTRIBUTES, attributes);
  }
  explicit NodeBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Node> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Node>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Node> CreateNode(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> name = 0,
    hipdnn_sdk::data_objects::NodeAttributes attributes_type = hipdnn_sdk::data_objects::NodeAttributes::NONE,
    ::flatbuffers::Offset<void> attributes = 0) {
  NodeBuilder builder_(_fbb);
  builder_.add_attributes(attributes);
  builder_.add_name(name);
  builder_.add_attributes_type(attributes_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<Node> CreateNodeDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    hipdnn_sdk::data_objects::NodeAttributes attributes_type = hipdnn_sdk::data_objects::NodeAttributes::NONE,
    ::flatbuffers::Offset<void> attributes = 0) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  return hipdnn_sdk::data_objects::CreateNode(
      _fbb,
      name__,
      attributes_type,
      attributes);
}

::flatbuffers::Offset<Node> CreateNode(::flatbuffers::FlatBufferBuilder &_fbb, const NodeT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);

struct GraphT : public ::flatbuffers::NativeTable {
  typedef Graph TableType;
  std::string name{};
  hipdnn_sdk::data_objects::DataType compute_type = hipdnn_sdk::data_objects::DataType::UNSET;
  hipdnn_sdk::data_objects::DataType intermediate_type = hipdnn_sdk::data_objects::DataType::UNSET;
  hipdnn_sdk::data_objects::DataType io_type = hipdnn_sdk::data_objects::DataType::UNSET;
  std::vector<std::unique_ptr<hipdnn_sdk::data_objects::TensorAttributesT>> tensors{};
  std::vector<std::unique_ptr<hipdnn_sdk::data_objects::NodeT>> nodes{};
  GraphT() = default;
  GraphT(const GraphT &o);
  GraphT(GraphT&&) FLATBUFFERS_NOEXCEPT = default;
  GraphT &operator=(GraphT o) FLATBUFFERS_NOEXCEPT;
};

struct Graph FLATBUFFERS_FINAL_CLASS : private ::flatbuffers::Table {
  typedef GraphT NativeTableType;
  typedef GraphBuilder Builder;
  enum FlatBuffersVTableOffset FLATBUFFERS_VTABLE_UNDERLYING_TYPE {
    VT_NAME = 4,
    VT_COMPUTE_TYPE = 6,
    VT_INTERMEDIATE_TYPE = 8,
    VT_IO_TYPE = 10,
    VT_TENSORS = 12,
    VT_NODES = 14
  };
  const ::flatbuffers::String *name() const {
    return GetPointer<const ::flatbuffers::String *>(VT_NAME);
  }
  ::flatbuffers::String *mutable_name() {
    return GetPointer<::flatbuffers::String *>(VT_NAME);
  }
  hipdnn_sdk::data_objects::DataType compute_type() const {
    return static_cast<hipdnn_sdk::data_objects::DataType>(GetField<int8_t>(VT_COMPUTE_TYPE, 0));
  }
  bool mutate_compute_type(hipdnn_sdk::data_objects::DataType _compute_type = static_cast<hipdnn_sdk::data_objects::DataType>(0)) {
    return SetField<int8_t>(VT_COMPUTE_TYPE, static_cast<int8_t>(_compute_type), 0);
  }
  hipdnn_sdk::data_objects::DataType intermediate_type() const {
    return static_cast<hipdnn_sdk::data_objects::DataType>(GetField<int8_t>(VT_INTERMEDIATE_TYPE, 0));
  }
  bool mutate_intermediate_type(hipdnn_sdk::data_objects::DataType _intermediate_type = static_cast<hipdnn_sdk::data_objects::DataType>(0)) {
    return SetField<int8_t>(VT_INTERMEDIATE_TYPE, static_cast<int8_t>(_intermediate_type), 0);
  }
  hipdnn_sdk::data_objects::DataType io_type() const {
    return static_cast<hipdnn_sdk::data_objects::DataType>(GetField<int8_t>(VT_IO_TYPE, 0));
  }
  bool mutate_io_type(hipdnn_sdk::data_objects::DataType _io_type = static_cast<hipdnn_sdk::data_objects::DataType>(0)) {
    return SetField<int8_t>(VT_IO_TYPE, static_cast<int8_t>(_io_type), 0);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> *tensors() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> *>(VT_TENSORS);
  }
  ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> *mutable_tensors() {
    return GetPointer<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> *>(VT_TENSORS);
  }
  const ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> *nodes() const {
    return GetPointer<const ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> *>(VT_NODES);
  }
  ::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> *mutable_nodes() {
    return GetPointer<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> *>(VT_NODES);
  }
  bool Verify(::flatbuffers::Verifier &verifier) const {
    return VerifyTableStart(verifier) &&
           VerifyOffset(verifier, VT_NAME) &&
           verifier.VerifyString(name()) &&
           VerifyField<int8_t>(verifier, VT_COMPUTE_TYPE, 1) &&
           VerifyField<int8_t>(verifier, VT_INTERMEDIATE_TYPE, 1) &&
           VerifyField<int8_t>(verifier, VT_IO_TYPE, 1) &&
           VerifyOffset(verifier, VT_TENSORS) &&
           verifier.VerifyVector(tensors()) &&
           verifier.VerifyVectorOfTables(tensors()) &&
           VerifyOffset(verifier, VT_NODES) &&
           verifier.VerifyVector(nodes()) &&
           verifier.VerifyVectorOfTables(nodes()) &&
           verifier.EndTable();
  }
  GraphT *UnPack(const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  void UnPackTo(GraphT *_o, const ::flatbuffers::resolver_function_t *_resolver = nullptr) const;
  static ::flatbuffers::Offset<Graph> Pack(::flatbuffers::FlatBufferBuilder &_fbb, const GraphT* _o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);
};

struct GraphBuilder {
  typedef Graph Table;
  ::flatbuffers::FlatBufferBuilder &fbb_;
  ::flatbuffers::uoffset_t start_;
  void add_name(::flatbuffers::Offset<::flatbuffers::String> name) {
    fbb_.AddOffset(Graph::VT_NAME, name);
  }
  void add_compute_type(hipdnn_sdk::data_objects::DataType compute_type) {
    fbb_.AddElement<int8_t>(Graph::VT_COMPUTE_TYPE, static_cast<int8_t>(compute_type), 0);
  }
  void add_intermediate_type(hipdnn_sdk::data_objects::DataType intermediate_type) {
    fbb_.AddElement<int8_t>(Graph::VT_INTERMEDIATE_TYPE, static_cast<int8_t>(intermediate_type), 0);
  }
  void add_io_type(hipdnn_sdk::data_objects::DataType io_type) {
    fbb_.AddElement<int8_t>(Graph::VT_IO_TYPE, static_cast<int8_t>(io_type), 0);
  }
  void add_tensors(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>>> tensors) {
    fbb_.AddOffset(Graph::VT_TENSORS, tensors);
  }
  void add_nodes(::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>>> nodes) {
    fbb_.AddOffset(Graph::VT_NODES, nodes);
  }
  explicit GraphBuilder(::flatbuffers::FlatBufferBuilder &_fbb)
        : fbb_(_fbb) {
    start_ = fbb_.StartTable();
  }
  ::flatbuffers::Offset<Graph> Finish() {
    const auto end = fbb_.EndTable(start_);
    auto o = ::flatbuffers::Offset<Graph>(end);
    return o;
  }
};

inline ::flatbuffers::Offset<Graph> CreateGraph(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    ::flatbuffers::Offset<::flatbuffers::String> name = 0,
    hipdnn_sdk::data_objects::DataType compute_type = hipdnn_sdk::data_objects::DataType::UNSET,
    hipdnn_sdk::data_objects::DataType intermediate_type = hipdnn_sdk::data_objects::DataType::UNSET,
    hipdnn_sdk::data_objects::DataType io_type = hipdnn_sdk::data_objects::DataType::UNSET,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>>> tensors = 0,
    ::flatbuffers::Offset<::flatbuffers::Vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>>> nodes = 0) {
  GraphBuilder builder_(_fbb);
  builder_.add_nodes(nodes);
  builder_.add_tensors(tensors);
  builder_.add_name(name);
  builder_.add_io_type(io_type);
  builder_.add_intermediate_type(intermediate_type);
  builder_.add_compute_type(compute_type);
  return builder_.Finish();
}

inline ::flatbuffers::Offset<Graph> CreateGraphDirect(
    ::flatbuffers::FlatBufferBuilder &_fbb,
    const char *name = nullptr,
    hipdnn_sdk::data_objects::DataType compute_type = hipdnn_sdk::data_objects::DataType::UNSET,
    hipdnn_sdk::data_objects::DataType intermediate_type = hipdnn_sdk::data_objects::DataType::UNSET,
    hipdnn_sdk::data_objects::DataType io_type = hipdnn_sdk::data_objects::DataType::UNSET,
    const std::vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> *tensors = nullptr,
    const std::vector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> *nodes = nullptr) {
  auto name__ = name ? _fbb.CreateString(name) : 0;
  auto tensors__ = tensors ? _fbb.CreateVector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>>(*tensors) : 0;
  auto nodes__ = nodes ? _fbb.CreateVector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>>(*nodes) : 0;
  return hipdnn_sdk::data_objects::CreateGraph(
      _fbb,
      name__,
      compute_type,
      intermediate_type,
      io_type,
      tensors__,
      nodes__);
}

::flatbuffers::Offset<Graph> CreateGraph(::flatbuffers::FlatBufferBuilder &_fbb, const GraphT *_o, const ::flatbuffers::rehasher_function_t *_rehasher = nullptr);


inline bool operator==(const NodeT &lhs, const NodeT &rhs) {
  return
      (lhs.name == rhs.name) &&
      (lhs.attributes == rhs.attributes);
}

inline bool operator!=(const NodeT &lhs, const NodeT &rhs) {
    return !(lhs == rhs);
}


inline NodeT *Node::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<NodeT>(new NodeT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void Node::UnPackTo(NodeT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); }
  { auto _e = attributes_type(); _o->attributes.type = _e; }
  { auto _e = attributes(); if (_e) _o->attributes.value = hipdnn_sdk::data_objects::NodeAttributesUnion::UnPack(_e, attributes_type(), _resolver); }
}

inline ::flatbuffers::Offset<Node> Node::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const NodeT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateNode(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<Node> CreateNode(::flatbuffers::FlatBufferBuilder &_fbb, const NodeT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const NodeT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _attributes_type = _o->attributes.type;
  auto _attributes = _o->attributes.Pack(_fbb);
  return hipdnn_sdk::data_objects::CreateNode(
      _fbb,
      _name,
      _attributes_type,
      _attributes);
}


inline bool operator==(const GraphT &lhs, const GraphT &rhs) {
  return
      (lhs.name == rhs.name) &&
      (lhs.compute_type == rhs.compute_type) &&
      (lhs.intermediate_type == rhs.intermediate_type) &&
      (lhs.io_type == rhs.io_type) &&
      (lhs.tensors.size() == rhs.tensors.size() && std::equal(lhs.tensors.cbegin(), lhs.tensors.cend(), rhs.tensors.cbegin(), [](std::unique_ptr<hipdnn_sdk::data_objects::TensorAttributesT> const &a, std::unique_ptr<hipdnn_sdk::data_objects::TensorAttributesT> const &b) { return (a == b) || (a && b && *a == *b); })) &&
      (lhs.nodes.size() == rhs.nodes.size() && std::equal(lhs.nodes.cbegin(), lhs.nodes.cend(), rhs.nodes.cbegin(), [](std::unique_ptr<hipdnn_sdk::data_objects::NodeT> const &a, std::unique_ptr<hipdnn_sdk::data_objects::NodeT> const &b) { return (a == b) || (a && b && *a == *b); }));
}

inline bool operator!=(const GraphT &lhs, const GraphT &rhs) {
    return !(lhs == rhs);
}


inline GraphT::GraphT(const GraphT &o)
      : name(o.name),
        compute_type(o.compute_type),
        intermediate_type(o.intermediate_type),
        io_type(o.io_type) {
  tensors.reserve(o.tensors.size());
  for (const auto &tensors_ : o.tensors) { tensors.emplace_back((tensors_) ? new hipdnn_sdk::data_objects::TensorAttributesT(*tensors_) : nullptr); }
  nodes.reserve(o.nodes.size());
  for (const auto &nodes_ : o.nodes) { nodes.emplace_back((nodes_) ? new hipdnn_sdk::data_objects::NodeT(*nodes_) : nullptr); }
}

inline GraphT &GraphT::operator=(GraphT o) FLATBUFFERS_NOEXCEPT {
  std::swap(name, o.name);
  std::swap(compute_type, o.compute_type);
  std::swap(intermediate_type, o.intermediate_type);
  std::swap(io_type, o.io_type);
  std::swap(tensors, o.tensors);
  std::swap(nodes, o.nodes);
  return *this;
}

inline GraphT *Graph::UnPack(const ::flatbuffers::resolver_function_t *_resolver) const {
  auto _o = std::unique_ptr<GraphT>(new GraphT());
  UnPackTo(_o.get(), _resolver);
  return _o.release();
}

inline void Graph::UnPackTo(GraphT *_o, const ::flatbuffers::resolver_function_t *_resolver) const {
  (void)_o;
  (void)_resolver;
  { auto _e = name(); if (_e) _o->name = _e->str(); }
  { auto _e = compute_type(); _o->compute_type = _e; }
  { auto _e = intermediate_type(); _o->intermediate_type = _e; }
  { auto _e = io_type(); _o->io_type = _e; }
  { auto _e = tensors(); if (_e) { _o->tensors.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { if(_o->tensors[_i]) { _e->Get(_i)->UnPackTo(_o->tensors[_i].get(), _resolver); } else { _o->tensors[_i] = std::unique_ptr<hipdnn_sdk::data_objects::TensorAttributesT>(_e->Get(_i)->UnPack(_resolver)); } } } else { _o->tensors.resize(0); } }
  { auto _e = nodes(); if (_e) { _o->nodes.resize(_e->size()); for (::flatbuffers::uoffset_t _i = 0; _i < _e->size(); _i++) { if(_o->nodes[_i]) { _e->Get(_i)->UnPackTo(_o->nodes[_i].get(), _resolver); } else { _o->nodes[_i] = std::unique_ptr<hipdnn_sdk::data_objects::NodeT>(_e->Get(_i)->UnPack(_resolver)); } } } else { _o->nodes.resize(0); } }
}

inline ::flatbuffers::Offset<Graph> Graph::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const GraphT* _o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  return CreateGraph(_fbb, _o, _rehasher);
}

inline ::flatbuffers::Offset<Graph> CreateGraph(::flatbuffers::FlatBufferBuilder &_fbb, const GraphT *_o, const ::flatbuffers::rehasher_function_t *_rehasher) {
  (void)_rehasher;
  (void)_o;
  struct _VectorArgs { ::flatbuffers::FlatBufferBuilder *__fbb; const GraphT* __o; const ::flatbuffers::rehasher_function_t *__rehasher; } _va = { &_fbb, _o, _rehasher}; (void)_va;
  auto _name = _o->name.empty() ? 0 : _fbb.CreateString(_o->name);
  auto _compute_type = _o->compute_type;
  auto _intermediate_type = _o->intermediate_type;
  auto _io_type = _o->io_type;
  auto _tensors = _o->tensors.size() ? _fbb.CreateVector<::flatbuffers::Offset<hipdnn_sdk::data_objects::TensorAttributes>> (_o->tensors.size(), [](size_t i, _VectorArgs *__va) { return CreateTensorAttributes(*__va->__fbb, __va->__o->tensors[i].get(), __va->__rehasher); }, &_va ) : 0;
  auto _nodes = _o->nodes.size() ? _fbb.CreateVector<::flatbuffers::Offset<hipdnn_sdk::data_objects::Node>> (_o->nodes.size(), [](size_t i, _VectorArgs *__va) { return CreateNode(*__va->__fbb, __va->__o->nodes[i].get(), __va->__rehasher); }, &_va ) : 0;
  return hipdnn_sdk::data_objects::CreateGraph(
      _fbb,
      _name,
      _compute_type,
      _intermediate_type,
      _io_type,
      _tensors,
      _nodes);
}

inline bool VerifyNodeAttributes(::flatbuffers::Verifier &verifier, const void *obj, NodeAttributes type) {
  switch (type) {
    case NodeAttributes::NONE: {
      return true;
    }
    case NodeAttributes::BatchnormInferenceAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case NodeAttributes::PointwiseAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case NodeAttributes::BatchnormAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributes *>(obj);
      return verifier.VerifyTable(ptr);
    }
    default: return true;
  }
}

inline bool VerifyNodeAttributesVector(::flatbuffers::Verifier &verifier, const ::flatbuffers::Vector<::flatbuffers::Offset<void>> *values, const ::flatbuffers::Vector<NodeAttributes> *types) {
  if (!values || !types) return !values && !types;
  if (values->size() != types->size()) return false;
  for (::flatbuffers::uoffset_t i = 0; i < values->size(); ++i) {
    if (!VerifyNodeAttributes(
        verifier,  values->Get(i), types->GetEnum<NodeAttributes>(i))) {
      return false;
    }
  }
  return true;
}

inline void *NodeAttributesUnion::UnPack(const void *obj, NodeAttributes type, const ::flatbuffers::resolver_function_t *resolver) {
  (void)resolver;
  switch (type) {
    case NodeAttributes::BatchnormInferenceAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    case NodeAttributes::PointwiseAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    case NodeAttributes::BatchnormAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributes *>(obj);
      return ptr->UnPack(resolver);
    }
    default: return nullptr;
  }
}

inline ::flatbuffers::Offset<void> NodeAttributesUnion::Pack(::flatbuffers::FlatBufferBuilder &_fbb, const ::flatbuffers::rehasher_function_t *_rehasher) const {
  (void)_rehasher;
  switch (type) {
    case NodeAttributes::BatchnormInferenceAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(value);
      return CreateBatchnormInferenceAttributes(_fbb, ptr, _rehasher).Union();
    }
    case NodeAttributes::PointwiseAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::PointwiseAttributesT *>(value);
      return CreatePointwiseAttributes(_fbb, ptr, _rehasher).Union();
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(value);
      return CreateBatchnormBackwardAttributes(_fbb, ptr, _rehasher).Union();
    }
    case NodeAttributes::BatchnormAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::BatchnormAttributesT *>(value);
      return CreateBatchnormAttributes(_fbb, ptr, _rehasher).Union();
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(value);
      return CreateConvolutionFwdAttributes(_fbb, ptr, _rehasher).Union();
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      auto ptr = reinterpret_cast<const hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(value);
      return CreateConvolutionBwdAttributes(_fbb, ptr, _rehasher).Union();
    }
    default: return 0;
  }
}

inline NodeAttributesUnion::NodeAttributesUnion(const NodeAttributesUnion &u) : type(u.type), value(nullptr) {
  switch (type) {
    case NodeAttributes::BatchnormInferenceAttributes: {
      value = new hipdnn_sdk::data_objects::BatchnormInferenceAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(u.value));
      break;
    }
    case NodeAttributes::PointwiseAttributes: {
      value = new hipdnn_sdk::data_objects::PointwiseAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::PointwiseAttributesT *>(u.value));
      break;
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      value = new hipdnn_sdk::data_objects::BatchnormBackwardAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(u.value));
      break;
    }
    case NodeAttributes::BatchnormAttributes: {
      value = new hipdnn_sdk::data_objects::BatchnormAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::BatchnormAttributesT *>(u.value));
      break;
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      value = new hipdnn_sdk::data_objects::ConvolutionFwdAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(u.value));
      break;
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      value = new hipdnn_sdk::data_objects::ConvolutionBwdAttributesT(*reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(u.value));
      break;
    }
    default:
      break;
  }
}

inline void NodeAttributesUnion::Reset() {
  switch (type) {
    case NodeAttributes::BatchnormInferenceAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::BatchnormInferenceAttributesT *>(value);
      delete ptr;
      break;
    }
    case NodeAttributes::PointwiseAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::PointwiseAttributesT *>(value);
      delete ptr;
      break;
    }
    case NodeAttributes::BatchnormBackwardAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::BatchnormBackwardAttributesT *>(value);
      delete ptr;
      break;
    }
    case NodeAttributes::BatchnormAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::BatchnormAttributesT *>(value);
      delete ptr;
      break;
    }
    case NodeAttributes::ConvolutionFwdAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionFwdAttributesT *>(value);
      delete ptr;
      break;
    }
    case NodeAttributes::ConvolutionBwdAttributes: {
      auto ptr = reinterpret_cast<hipdnn_sdk::data_objects::ConvolutionBwdAttributesT *>(value);
      delete ptr;
      break;
    }
    default: break;
  }
  value = nullptr;
  type = NodeAttributes::NONE;
}

inline const hipdnn_sdk::data_objects::Graph *GetGraph(const void *buf) {
  return ::flatbuffers::GetRoot<hipdnn_sdk::data_objects::Graph>(buf);
}

inline const hipdnn_sdk::data_objects::Graph *GetSizePrefixedGraph(const void *buf) {
  return ::flatbuffers::GetSizePrefixedRoot<hipdnn_sdk::data_objects::Graph>(buf);
}

inline Graph *GetMutableGraph(void *buf) {
  return ::flatbuffers::GetMutableRoot<Graph>(buf);
}

inline hipdnn_sdk::data_objects::Graph *GetMutableSizePrefixedGraph(void *buf) {
  return ::flatbuffers::GetMutableSizePrefixedRoot<hipdnn_sdk::data_objects::Graph>(buf);
}

inline bool VerifyGraphBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifyBuffer<hipdnn_sdk::data_objects::Graph>(nullptr);
}

inline bool VerifySizePrefixedGraphBuffer(
    ::flatbuffers::Verifier &verifier) {
  return verifier.VerifySizePrefixedBuffer<hipdnn_sdk::data_objects::Graph>(nullptr);
}

inline void FinishGraphBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<hipdnn_sdk::data_objects::Graph> root) {
  fbb.Finish(root);
}

inline void FinishSizePrefixedGraphBuffer(
    ::flatbuffers::FlatBufferBuilder &fbb,
    ::flatbuffers::Offset<hipdnn_sdk::data_objects::Graph> root) {
  fbb.FinishSizePrefixed(root);
}

inline std::unique_ptr<hipdnn_sdk::data_objects::GraphT> UnPackGraph(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<hipdnn_sdk::data_objects::GraphT>(GetGraph(buf)->UnPack(res));
}

inline std::unique_ptr<hipdnn_sdk::data_objects::GraphT> UnPackSizePrefixedGraph(
    const void *buf,
    const ::flatbuffers::resolver_function_t *res = nullptr) {
  return std::unique_ptr<hipdnn_sdk::data_objects::GraphT>(GetSizePrefixedGraph(buf)->UnPack(res));
}

}  // namespace data_objects
}  // namespace hipdnn_sdk

#endif  // FLATBUFFERS_GENERATED_GRAPH_HIPDNN_SDK_DATA_OBJECTS_H_
