package floatingip

import (
	"github.com/spf13/cobra"

	"github.com/hetznercloud/cli/internal/cmd/util"
	"github.com/hetznercloud/cli/internal/state"
)

func NewCommand(s state.State) *cobra.Command {
	cmd := &cobra.Command{
		Use:                   "floating-ip",
		Aliases:               []string{"floating-ips"},
		Short:                 "Manage Floating IPs",
		Args:                  util.Validate,
		TraverseChildren:      true,
		DisableFlagsInUseLine: true,
	}

	util.AddGroup(cmd, "general", "General",
		ListCmd.CobraCommand(s),
		DescribeCmd.CobraCommand(s),
		CreateCmd.CobraCommand(s),
		DeleteCmd.CobraCommand(s),
		UpdateCmd.CobraCommand(s),
		LabelCmds.AddCobraCommand(s),
		LabelCmds.RemoveCobraCommand(s),
	)

	util.AddGroup(cmd, "protection", "Protection",
		ChangeProtectionCmds.EnableCobraCommand(s),
		ChangeProtectionCmds.DisableCobraCommand(s),
	)

	util.AddGroup(cmd, "assign", "Assign",
		AssignCmd.CobraCommand(s),
		UnassignCmd.CobraCommand(s),
	)

	cmd.AddCommand(SetRDNSCmd.CobraCommand(s))
	return cmd
}
