// META: title=test WebNN API element-wise abs operation
// META: global=window
// META: variant=?cpu
// META: variant=?gpu
// META: variant=?npu
// META: script=../resources/utils.js
// META: timeout=long

'use strict';

// https://www.w3.org/TR/webnn/#api-mlgraphbuilder-unary
// Compute the absolute value of the input tensor, element-wise.
//
// MLOperand abs(MLOperand input);


const getAbsPrecisionTolerance = () => {
  return {metricType: 'ULP', value: 0};
};

const absTests = [
  // abs tests
  {
    'name': 'abs float32 positive 0D scalar',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [49.837242126464844],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [49.837242126464844],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 negative 0D scalar',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [-91.03521728515625],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [91.03521728515625],
          'descriptor': {shape: [], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 1D constant tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [24], dataType: 'float32'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 1D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [24], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 2D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [4, 6], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 3D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 4D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float32'}
        }
      }
    }
  },
  {
    'name': 'abs float32 5D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.837242126464844,  82.09291076660156,  3.1989054679870605,
            85.20904541015625,   88.94609069824219,  -91.03521728515625,
            31.4484920501709,    -29.31110954284668, -92.4477310180664,
            -15.520709991455078, 80.91279602050781,  -38.2097053527832,
            53.064762115478516,  99.6537094116211,   -21.285049438476562,
            90.01982879638672,   18.32451820373535,  -33.06915283203125,
            30.097660064697266,  -74.21503448486328, 95.60974884033203,
            6.614287376403809,   31.2832088470459,   -53.206058502197266
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.837242126464844, 82.09291076660156, 3.1989054679870605,
            85.20904541015625,  88.94609069824219, 91.03521728515625,
            31.4484920501709,   29.31110954284668, 92.4477310180664,
            15.520709991455078, 80.91279602050781, 38.2097053527832,
            53.064762115478516, 99.6537094116211,  21.285049438476562,
            90.01982879638672,  18.32451820373535, 33.06915283203125,
            30.097660064697266, 74.21503448486328, 95.60974884033203,
            6.614287376403809,  31.2832088470459,  53.206058502197266
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float32'}
        }
      }
    }
  },

  // float16 tests
  {
    'name': 'abs float16 positive 0D scalar',
    'graph': {
      'inputs': {
        'absInput':
            {'data': [49.84375], 'descriptor': {shape: [], dataType: 'float16'}}
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput':
            {'data': [49.84375], 'descriptor': {shape: [], dataType: 'float16'}}
      }
    }
  },
  {
    'name': 'abs float16 negative 0D scalar',
    'graph': {
      'inputs': {
        'absInput':
            {'data': [-91.0625], 'descriptor': {shape: [], dataType: 'float16'}}
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput':
            {'data': [91.0625], 'descriptor': {shape: [], dataType: 'float16'}}
      }
    }
  },
  {
    'name': 'abs float16 1D constant tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [24], dataType: 'float16'},
          'constant': true
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'abs float16 1D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [24], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'abs float16 2D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [4, 6], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'abs float16 3D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [2, 3, 4], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'abs float16 4D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [2, 2, 2, 3], dataType: 'float16'}
        }
      }
    }
  },
  {
    'name': 'abs float16 5D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            49.84375,  82.0625,  3.19921875, 85.1875,     88.9375,   -91.0625,
            31.453125, -29.3125, -92.4375,   -15.5234375, 80.9375,   -38.21875,
            53.0625,   99.625,   -21.28125,  90,          18.328125, -33.0625,
            30.09375,  -74.1875, 95.625,     6.61328125,  31.28125,  -53.21875
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [
            49.84375,  82.0625, 3.19921875, 85.1875,    88.9375,   91.0625,
            31.453125, 29.3125, 92.4375,    15.5234375, 80.9375,   38.21875,
            53.0625,   99.625,  21.28125,   90,         18.328125, 33.0625,
            30.09375,  74.1875, 95.625,     6.61328125, 31.28125,  53.21875
          ],
          'descriptor': {shape: [2, 1, 4, 1, 3], dataType: 'float16'}
        }
      }
    }
  },

  // int8 tests
  {
    'name': 'abs int8 4D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            // int8 range: [/* -(2**7) */ -128, /* 2**7 - 1 */ 127]
            // abs(-128) would overflow when data type is int8
            -127, 0, 126, 127
          ],
          'descriptor': {shape: [1, 2, 2, 1], dataType: 'int8'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [127, 0, 126, 127],
          'descriptor': {shape: [1, 2, 2, 1], dataType: 'int8'}
        }
      }
    }
  },

  // int32 tests
  {
    'name': 'abs int32 4D tensor',
    'graph': {
      'inputs': {
        'absInput': {
          'data': [
            // int32 range: [/* -(2**31) */ -2147483648, /* 2**31 - 1 */ 2147483647]
            // abs(-2147483648) would overflow when data type is int32
            -2147483647, 0, 2147483646, 2147483647
          ],
          'descriptor': {shape: [1, 2, 2, 1], dataType: 'int32'}
        }
      },
      'operators': [{
        'name': 'abs',
        'arguments': [{'input': 'absInput'}],
        'outputs': 'absOutput'
      }],
      'expectedOutputs': {
        'absOutput': {
          'data': [2147483647, 0, 2147483646, 2147483647],
          'descriptor': {shape: [1, 2, 2, 1], dataType: 'int32'}
        }
      }
    }
  }
];

if (navigator.ml) {
  absTests.forEach((test) => {
    webnn_conformance_test(
        buildAndExecuteGraph, getAbsPrecisionTolerance, test);
  });
} else {
  test(() => assert_implements(navigator.ml, 'missing navigator.ml'));
}
