/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.istack.internal.localization.Localizable;
import com.sun.istack.internal.localization.LocalizableMessage;
import com.sun.istack.internal.localization.LocalizableMessageFactory;
import com.sun.istack.internal.localization.Localizer;
import com.sun.istack.internal.localization.NullLocalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private static final long serialVersionUID = 1L;
    private transient Localizable msg;

    protected JAXWSExceptionBase(String key, Object ... args) {
        super(JAXWSExceptionBase.findNestedException(args));
        this.msg = new LocalizableMessage(this.getDefaultResourceBundleName(), key, args);
    }

    protected JAXWSExceptionBase(String message) {
        this(new NullLocalizable(message));
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable msg) {
        this.msg = msg;
    }

    protected JAXWSExceptionBase(Localizable msg, Throwable cause) {
        super(cause);
        this.msg = msg;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.msg.getResourceBundleName());
        out.writeObject(this.msg.getKey());
        Object[] args = this.msg.getArguments();
        if (args == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || args[i] instanceof Serializable) {
                out.writeObject(args[i]);
                continue;
            }
            out.writeObject(args[i].toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object[] args;
        in.defaultReadObject();
        String resourceBundleName = (String)in.readObject();
        String key = (String)in.readObject();
        int len = in.readInt();
        if (len < -1) {
            throw new NegativeArraySizeException();
        }
        if (len == -1) {
            args = null;
        } else if (len < 255) {
            args = new Object[len];
            for (int i = 0; i < args.length; ++i) {
                args[i] = in.readObject();
            }
        } else {
            ArrayList<Object> argList = new ArrayList<Object>(Math.min(len, 1024));
            for (int i = 0; i < len; ++i) {
                argList.add(in.readObject());
            }
            args = argList.toArray(new Object[argList.size()]);
        }
        this.msg = new LocalizableMessageFactory(resourceBundleName).getMessage(key, args);
    }

    private static Throwable findNestedException(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object o : args) {
            if (!(o instanceof Throwable)) continue;
            return (Throwable)o;
        }
        return null;
    }

    @Override
    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    @Override
    public final String getKey() {
        return this.msg.getKey();
    }

    @Override
    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    @Override
    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }
}

