// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 3
// RUN: %clang_cc1 -triple=x86_64 -verify -ffreestanding -std=c23 %s

/* WG14 N2683: Clang 18
 * Towards Integer Safety
 */
#include <stdckdint.h>
#include <stddef.h>
#include <stdint.h>

void test_semantic() {
  int64_t result64 = 0;
  int32_t result32 = 0;
  wchar_t wide_char = L'A'; // The ascii value of `A` is 65

  bool flag_add = ckd_add(&result64, INT32_MAX, 1);
  bool flag_sub = ckd_sub(&result32, INT32_MAX, -1);
  bool flag_mul = ckd_mul(&result64, INT64_MAX, 1);

  bool flag = ckd_add(&result64, wide_char, result32); // In C, wchar_t is a typedef to some integer type and is allowed.

  // FIXME: add static_assert calls to check the resulting values for correctness
  // once the constant expression interpreter is able to handle the checked arithmetic
  // builtins in C. Currently, they're only a valid constant expression in C++ due to
  // looking for an ICE in C. Also all values in the tests of n2683_2.c should be checked.
}

void test_invalid_input() {
  _BitInt(33) a33 = 1;
  char char_var = 'd'; // The ascii value of `d` is 100
  bool bool_var = 1;
  const int const_result = 0;
  enum week{Mon, Tue, Wed};
  enum week day = Mon;
  int a = 100;
  int b = 55;
  int result = 10;
  char plain_char[] = {U'牛'}; /* expected-warning {{implicit conversion from 'unsigned int' to 'char' changes value from 29275 to 91}}  */

  // invalid operand argument
  bool flag_no_bitint = ckd_add(&result, a33, a); /* expected-error {{operand argument to checked integer operation must be an integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('_BitInt(33)' invalid)}} */
  bool flag_no_bool = ckd_sub(&result, bool_var, b); /* expected-error {{operand argument to checked integer operation must be an integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('bool' invalid)}} */
  bool flag_no_char = ckd_mul(&result, char_var, a); /* expected-error {{operand argument to checked integer operation must be an integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('char' invalid)}} */
  bool flag_no_enum = ckd_mul(&result, day, b); /* expected-error {{operand argument to checked integer operation must be an integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('enum week' invalid)}} */

  // invalid result type
  bool flag_nostr = ckd_sub(&plain_char, a, b); /* expected-error {{result argument to checked integer operation must be a pointer to a non-const integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('char (*)[1]' invalid)}} */
  bool flag_nobool = ckd_mul(&bool_var, a, b); /* expected-error {{result argument to checked integer operation must be a pointer to a non-const integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('bool *' invalid)}} */
  bool flag_noptr = ckd_add(result, a, b); /* expected-error {{result argument to checked integer operation must be a pointer to a non-const integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('int' invalid)}} */
  bool flag_noconst = ckd_sub(&const_result, a, b); /* expected-error {{result argument to checked integer operation must be a pointer to a non-const integer type other than plain 'char', 'bool', bit-precise, or an enumeration ('const int *' invalid)}} */
}
