/*
** Copyright (c) 2018-2023 Valve Corporation
** Copyright (c) 2018-2025 LunarG, Inc.
** Copyright (c) 2023 Advanced Micro Devices, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos OpenXR XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_OPENXR_LAYER_FUNC_TABLE_H
#define  GFXRECON_GENERATED_OPENXR_LAYER_FUNC_TABLE_H

#if ENABLE_OPENXR_SUPPORT

#include "encode/custom_openxr_api_call_encoders.h"
#include "generated/generated_openxr_api_call_encoders.h"
#include "layer/layer_vulkan_entry.h"
#include "util/defines.h"

#include "format/platform_types.h"

#include "openxr/openxr.h"
#include "openxr/openxr_loader_negotiation.h"
#include "openxr/openxr_platform.h"

#include <unordered_map>

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
// This static function can be used to avoid issues with static variable initialization order.
static inline const std::unordered_map<std::string, PFN_xrVoidFunction> GetOpenXRLayerFuncTable() {
    return {
        { "xrGetInstanceProcAddr",                                                                               reinterpret_cast<PFN_xrVoidFunction>(openxr_layer::GetInstanceProcAddr) },
        { "xrEnumerateApiLayerProperties",                                                                       reinterpret_cast<PFN_xrVoidFunction>(openxr_layer::EnumerateApiLayerProperties) },
        { "xrEnumerateInstanceExtensionProperties",                                                              reinterpret_cast<PFN_xrVoidFunction>(openxr_layer::EnumerateInstanceExtensionProperties) },
        { "xrDestroyInstance",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyInstance) },
        { "xrGetInstanceProperties",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetInstanceProperties) },
        { "xrPollEvent",                                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrPollEvent) },
        { "xrResultToString",                                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrResultToString) },
        { "xrStructureTypeToString",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrStructureTypeToString) },
        { "xrGetSystem",                                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSystem) },
        { "xrGetSystemProperties",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSystemProperties) },
        { "xrEnumerateEnvironmentBlendModes",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateEnvironmentBlendModes) },
        { "xrCreateSession",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSession) },
        { "xrDestroySession",                                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySession) },
        { "xrEnumerateReferenceSpaces",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateReferenceSpaces) },
        { "xrCreateReferenceSpace",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateReferenceSpace) },
        { "xrGetReferenceSpaceBoundsRect",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetReferenceSpaceBoundsRect) },
        { "xrCreateActionSpace",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateActionSpace) },
        { "xrLocateSpace",                                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateSpace) },
        { "xrDestroySpace",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySpace) },
        { "xrEnumerateViewConfigurations",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateViewConfigurations) },
        { "xrGetViewConfigurationProperties",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetViewConfigurationProperties) },
        { "xrEnumerateViewConfigurationViews",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateViewConfigurationViews) },
        { "xrEnumerateSwapchainFormats",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateSwapchainFormats) },
        { "xrCreateSwapchain",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSwapchain) },
        { "xrDestroySwapchain",                                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySwapchain) },
        { "xrEnumerateSwapchainImages",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateSwapchainImages) },
        { "xrAcquireSwapchainImage",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrAcquireSwapchainImage) },
        { "xrWaitSwapchainImage",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrWaitSwapchainImage) },
        { "xrReleaseSwapchainImage",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrReleaseSwapchainImage) },
        { "xrBeginSession",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrBeginSession) },
        { "xrEndSession",                                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrEndSession) },
        { "xrRequestExitSession",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrRequestExitSession) },
        { "xrWaitFrame",                                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrWaitFrame) },
        { "xrBeginFrame",                                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrBeginFrame) },
        { "xrEndFrame",                                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrEndFrame) },
        { "xrLocateViews",                                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateViews) },
        { "xrStringToPath",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrStringToPath) },
        { "xrPathToString",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrPathToString) },
        { "xrCreateActionSet",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateActionSet) },
        { "xrDestroyActionSet",                                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyActionSet) },
        { "xrCreateAction",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateAction) },
        { "xrDestroyAction",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyAction) },
        { "xrSuggestInteractionProfileBindings",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrSuggestInteractionProfileBindings) },
        { "xrAttachSessionActionSets",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrAttachSessionActionSets) },
        { "xrGetCurrentInteractionProfile",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetCurrentInteractionProfile) },
        { "xrGetActionStateBoolean",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetActionStateBoolean) },
        { "xrGetActionStateFloat",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetActionStateFloat) },
        { "xrGetActionStateVector2f",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetActionStateVector2f) },
        { "xrGetActionStatePose",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetActionStatePose) },
        { "xrSyncActions",                                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrSyncActions) },
        { "xrEnumerateBoundSourcesForAction",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateBoundSourcesForAction) },
        { "xrGetInputSourceLocalizedName",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetInputSourceLocalizedName) },
        { "xrApplyHapticFeedback",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrApplyHapticFeedback) },
        { "xrStopHapticFeedback",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrStopHapticFeedback) },
        { "xrLocateSpaces",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateSpaces) },
        { "xrSetAndroidApplicationThreadKHR",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetAndroidApplicationThreadKHR) },
        { "xrCreateSwapchainAndroidSurfaceKHR",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSwapchainAndroidSurfaceKHR) },
        { "xrGetOpenGLGraphicsRequirementsKHR",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetOpenGLGraphicsRequirementsKHR) },
        { "xrGetOpenGLESGraphicsRequirementsKHR",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetOpenGLESGraphicsRequirementsKHR) },
        { "xrGetVulkanInstanceExtensionsKHR",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanInstanceExtensionsKHR) },
        { "xrGetVulkanDeviceExtensionsKHR",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanDeviceExtensionsKHR) },
        { "xrGetVulkanGraphicsDeviceKHR",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanGraphicsDeviceKHR) },
        { "xrGetVulkanGraphicsRequirementsKHR",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanGraphicsRequirementsKHR) },
        { "xrGetD3D11GraphicsRequirementsKHR",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetD3D11GraphicsRequirementsKHR) },
        { "xrGetD3D12GraphicsRequirementsKHR",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetD3D12GraphicsRequirementsKHR) },
        { "xrGetMetalGraphicsRequirementsKHR",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMetalGraphicsRequirementsKHR) },
        { "xrGetVisibilityMaskKHR",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVisibilityMaskKHR) },
        { "xrConvertWin32PerformanceCounterToTimeKHR",                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrConvertWin32PerformanceCounterToTimeKHR) },
        { "xrConvertTimeToWin32PerformanceCounterKHR",                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrConvertTimeToWin32PerformanceCounterKHR) },
        { "xrConvertTimespecTimeToTimeKHR",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrConvertTimespecTimeToTimeKHR) },
        { "xrConvertTimeToTimespecTimeKHR",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrConvertTimeToTimespecTimeKHR) },
        { "xrCreateVulkanInstanceKHR",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateVulkanInstanceKHR) },
        { "xrCreateVulkanDeviceKHR",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateVulkanDeviceKHR) },
        { "xrGetVulkanGraphicsDevice2KHR",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanGraphicsDevice2KHR) },
        { "xrGetVulkanGraphicsRequirements2KHR",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVulkanGraphicsRequirements2KHR) },
        { "xrLocateSpacesKHR",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateSpacesKHR) },
        { "xrPerfSettingsSetPerformanceLevelEXT",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrPerfSettingsSetPerformanceLevelEXT) },
        { "xrThermalGetTemperatureTrendEXT",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrThermalGetTemperatureTrendEXT) },
        { "xrSetDebugUtilsObjectNameEXT",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetDebugUtilsObjectNameEXT) },
        { "xrCreateDebugUtilsMessengerEXT",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateDebugUtilsMessengerEXT) },
        { "xrDestroyDebugUtilsMessengerEXT",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyDebugUtilsMessengerEXT) },
        { "xrSubmitDebugUtilsMessageEXT",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrSubmitDebugUtilsMessageEXT) },
        { "xrSessionBeginDebugUtilsLabelRegionEXT",                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrSessionBeginDebugUtilsLabelRegionEXT) },
        { "xrSessionEndDebugUtilsLabelRegionEXT",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrSessionEndDebugUtilsLabelRegionEXT) },
        { "xrSessionInsertDebugUtilsLabelEXT",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrSessionInsertDebugUtilsLabelEXT) },
        { "xrCreateSpatialAnchorMSFT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorMSFT) },
        { "xrCreateSpatialAnchorSpaceMSFT",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorSpaceMSFT) },
        { "xrDestroySpatialAnchorMSFT",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySpatialAnchorMSFT) },
        { "xrSetInputDeviceActiveEXT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetInputDeviceActiveEXT) },
        { "xrSetInputDeviceStateBoolEXT",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetInputDeviceStateBoolEXT) },
        { "xrSetInputDeviceStateFloatEXT",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetInputDeviceStateFloatEXT) },
        { "xrSetInputDeviceStateVector2fEXT",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetInputDeviceStateVector2fEXT) },
        { "xrSetInputDeviceLocationEXT",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetInputDeviceLocationEXT) },
        { "xrCreateSpatialGraphNodeSpaceMSFT",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialGraphNodeSpaceMSFT) },
        { "xrTryCreateSpatialGraphStaticNodeBindingMSFT",                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrTryCreateSpatialGraphStaticNodeBindingMSFT) },
        { "xrDestroySpatialGraphNodeBindingMSFT",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySpatialGraphNodeBindingMSFT) },
        { "xrGetSpatialGraphNodeBindingPropertiesMSFT",                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpatialGraphNodeBindingPropertiesMSFT) },
        { "xrCreateHandTrackerEXT",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateHandTrackerEXT) },
        { "xrDestroyHandTrackerEXT",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyHandTrackerEXT) },
        { "xrLocateHandJointsEXT",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateHandJointsEXT) },
        { "xrCreateHandMeshSpaceMSFT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateHandMeshSpaceMSFT) },
        { "xrUpdateHandMeshMSFT",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrUpdateHandMeshMSFT) },
        { "xrGetControllerModelKeyMSFT",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetControllerModelKeyMSFT) },
        { "xrLoadControllerModelMSFT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrLoadControllerModelMSFT) },
        { "xrGetControllerModelPropertiesMSFT",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetControllerModelPropertiesMSFT) },
        { "xrGetControllerModelStateMSFT",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetControllerModelStateMSFT) },
        { "xrCreateSpatialAnchorFromPerceptionAnchorMSFT",                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorFromPerceptionAnchorMSFT) },
        { "xrTryGetPerceptionAnchorFromSpatialAnchorMSFT",                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrTryGetPerceptionAnchorFromSpatialAnchorMSFT) },
        { "xrEnumerateReprojectionModesMSFT",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateReprojectionModesMSFT) },
        { "xrUpdateSwapchainFB",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrUpdateSwapchainFB) },
        { "xrGetSwapchainStateFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSwapchainStateFB) },
        { "xrCreateBodyTrackerFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateBodyTrackerFB) },
        { "xrDestroyBodyTrackerFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyBodyTrackerFB) },
        { "xrLocateBodyJointsFB",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateBodyJointsFB) },
        { "xrGetBodySkeletonFB",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetBodySkeletonFB) },
        { "xrEnumerateSceneComputeFeaturesMSFT",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateSceneComputeFeaturesMSFT) },
        { "xrCreateSceneObserverMSFT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSceneObserverMSFT) },
        { "xrDestroySceneObserverMSFT",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySceneObserverMSFT) },
        { "xrCreateSceneMSFT",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSceneMSFT) },
        { "xrDestroySceneMSFT",                                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySceneMSFT) },
        { "xrComputeNewSceneMSFT",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrComputeNewSceneMSFT) },
        { "xrGetSceneComputeStateMSFT",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSceneComputeStateMSFT) },
        { "xrGetSceneComponentsMSFT",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSceneComponentsMSFT) },
        { "xrLocateSceneComponentsMSFT",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrLocateSceneComponentsMSFT) },
        { "xrGetSceneMeshBuffersMSFT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSceneMeshBuffersMSFT) },
        { "xrDeserializeSceneMSFT",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrDeserializeSceneMSFT) },
        { "xrGetSerializedSceneFragmentDataMSFT",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSerializedSceneFragmentDataMSFT) },
        { "xrEnumerateDisplayRefreshRatesFB",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateDisplayRefreshRatesFB) },
        { "xrGetDisplayRefreshRateFB",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetDisplayRefreshRateFB) },
        { "xrRequestDisplayRefreshRateFB",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrRequestDisplayRefreshRateFB) },
        { "xrEnumerateViveTrackerPathsHTCX",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateViveTrackerPathsHTCX) },
        { "xrCreateFacialTrackerHTC",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateFacialTrackerHTC) },
        { "xrDestroyFacialTrackerHTC",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyFacialTrackerHTC) },
        { "xrGetFacialExpressionsHTC",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetFacialExpressionsHTC) },
        { "xrEnumerateColorSpacesFB",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateColorSpacesFB) },
        { "xrSetColorSpaceFB",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetColorSpaceFB) },
        { "xrGetHandMeshFB",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetHandMeshFB) },
        { "xrCreateSpatialAnchorFB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorFB) },
        { "xrGetSpaceUuidFB",                                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceUuidFB) },
        { "xrEnumerateSpaceSupportedComponentsFB",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateSpaceSupportedComponentsFB) },
        { "xrSetSpaceComponentStatusFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetSpaceComponentStatusFB) },
        { "xrGetSpaceComponentStatusFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceComponentStatusFB) },
        { "xrCreateFoveationProfileFB",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateFoveationProfileFB) },
        { "xrDestroyFoveationProfileFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyFoveationProfileFB) },
        { "xrQuerySystemTrackedKeyboardFB",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrQuerySystemTrackedKeyboardFB) },
        { "xrCreateKeyboardSpaceFB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateKeyboardSpaceFB) },
        { "xrCreateTriangleMeshFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateTriangleMeshFB) },
        { "xrDestroyTriangleMeshFB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyTriangleMeshFB) },
        { "xrTriangleMeshGetVertexBufferFB",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshGetVertexBufferFB) },
        { "xrTriangleMeshGetIndexBufferFB",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshGetIndexBufferFB) },
        { "xrTriangleMeshBeginUpdateFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshBeginUpdateFB) },
        { "xrTriangleMeshEndUpdateFB",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshEndUpdateFB) },
        { "xrTriangleMeshBeginVertexBufferUpdateFB",                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshBeginVertexBufferUpdateFB) },
        { "xrTriangleMeshEndVertexBufferUpdateFB",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrTriangleMeshEndVertexBufferUpdateFB) },
        { "xrCreatePassthroughFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreatePassthroughFB) },
        { "xrDestroyPassthroughFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyPassthroughFB) },
        { "xrPassthroughStartFB",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughStartFB) },
        { "xrPassthroughPauseFB",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughPauseFB) },
        { "xrCreatePassthroughLayerFB",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreatePassthroughLayerFB) },
        { "xrDestroyPassthroughLayerFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyPassthroughLayerFB) },
        { "xrPassthroughLayerPauseFB",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughLayerPauseFB) },
        { "xrPassthroughLayerResumeFB",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughLayerResumeFB) },
        { "xrPassthroughLayerSetStyleFB",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughLayerSetStyleFB) },
        { "xrCreateGeometryInstanceFB",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateGeometryInstanceFB) },
        { "xrDestroyGeometryInstanceFB",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyGeometryInstanceFB) },
        { "xrGeometryInstanceSetTransformFB",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGeometryInstanceSetTransformFB) },
        { "xrEnumerateRenderModelPathsFB",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateRenderModelPathsFB) },
        { "xrGetRenderModelPropertiesFB",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetRenderModelPropertiesFB) },
        { "xrLoadRenderModelFB",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrLoadRenderModelFB) },
        { "xrSetEnvironmentDepthEstimationVARJO",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetEnvironmentDepthEstimationVARJO) },
        { "xrSetMarkerTrackingVARJO",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetMarkerTrackingVARJO) },
        { "xrSetMarkerTrackingTimeoutVARJO",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetMarkerTrackingTimeoutVARJO) },
        { "xrSetMarkerTrackingPredictionVARJO",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetMarkerTrackingPredictionVARJO) },
        { "xrGetMarkerSizeVARJO",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerSizeVARJO) },
        { "xrCreateMarkerSpaceVARJO",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateMarkerSpaceVARJO) },
        { "xrSetViewOffsetVARJO",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetViewOffsetVARJO) },
        { "xrCreateSpaceFromCoordinateFrameUIDML",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpaceFromCoordinateFrameUIDML) },
        { "xrCreateMarkerDetectorML",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateMarkerDetectorML) },
        { "xrDestroyMarkerDetectorML",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyMarkerDetectorML) },
        { "xrSnapshotMarkerDetectorML",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrSnapshotMarkerDetectorML) },
        { "xrGetMarkerDetectorStateML",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerDetectorStateML) },
        { "xrGetMarkersML",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkersML) },
        { "xrGetMarkerReprojectionErrorML",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerReprojectionErrorML) },
        { "xrGetMarkerLengthML",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerLengthML) },
        { "xrGetMarkerNumberML",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerNumberML) },
        { "xrGetMarkerStringML",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetMarkerStringML) },
        { "xrCreateMarkerSpaceML",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateMarkerSpaceML) },
        { "xrEnableLocalizationEventsML",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnableLocalizationEventsML) },
        { "xrQueryLocalizationMapsML",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrQueryLocalizationMapsML) },
        { "xrRequestMapLocalizationML",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrRequestMapLocalizationML) },
        { "xrImportLocalizationMapML",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrImportLocalizationMapML) },
        { "xrCreateExportedLocalizationMapML",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateExportedLocalizationMapML) },
        { "xrDestroyExportedLocalizationMapML",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyExportedLocalizationMapML) },
        { "xrGetExportedLocalizationMapDataML",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetExportedLocalizationMapDataML) },
        { "xrCreateSpatialAnchorStoreConnectionMSFT",                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorStoreConnectionMSFT) },
        { "xrDestroySpatialAnchorStoreConnectionMSFT",                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySpatialAnchorStoreConnectionMSFT) },
        { "xrPersistSpatialAnchorMSFT",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrPersistSpatialAnchorMSFT) },
        { "xrEnumeratePersistedSpatialAnchorNamesMSFT",                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumeratePersistedSpatialAnchorNamesMSFT) },
        { "xrCreateSpatialAnchorFromPersistedNameMSFT",                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorFromPersistedNameMSFT) },
        { "xrUnpersistSpatialAnchorMSFT",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrUnpersistSpatialAnchorMSFT) },
        { "xrClearSpatialAnchorStoreMSFT",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrClearSpatialAnchorStoreMSFT) },
        { "xrGetSceneMarkerRawDataMSFT",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSceneMarkerRawDataMSFT) },
        { "xrGetSceneMarkerDecodedStringMSFT",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSceneMarkerDecodedStringMSFT) },
        { "xrQuerySpacesFB",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrQuerySpacesFB) },
        { "xrRetrieveSpaceQueryResultsFB",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrRetrieveSpaceQueryResultsFB) },
        { "xrSaveSpaceFB",                                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrSaveSpaceFB) },
        { "xrEraseSpaceFB",                                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrEraseSpaceFB) },
        { "xrGetAudioOutputDeviceGuidOculus",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetAudioOutputDeviceGuidOculus) },
        { "xrGetAudioInputDeviceGuidOculus",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetAudioInputDeviceGuidOculus) },
        { "xrShareSpacesFB",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrShareSpacesFB) },
        { "xrGetSpaceBoundingBox2DFB",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceBoundingBox2DFB) },
        { "xrGetSpaceBoundingBox3DFB",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceBoundingBox3DFB) },
        { "xrGetSpaceSemanticLabelsFB",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceSemanticLabelsFB) },
        { "xrGetSpaceBoundary2DFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceBoundary2DFB) },
        { "xrGetSpaceRoomLayoutFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceRoomLayoutFB) },
        { "xrSetDigitalLensControlALMALENCE",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetDigitalLensControlALMALENCE) },
        { "xrRequestSceneCaptureFB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrRequestSceneCaptureFB) },
        { "xrGetSpaceContainerFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceContainerFB) },
        { "xrGetFoveationEyeTrackedStateMETA",                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetFoveationEyeTrackedStateMETA) },
        { "xrCreateFaceTrackerFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateFaceTrackerFB) },
        { "xrDestroyFaceTrackerFB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyFaceTrackerFB) },
        { "xrGetFaceExpressionWeightsFB",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetFaceExpressionWeightsFB) },
        { "xrCreateEyeTrackerFB",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateEyeTrackerFB) },
        { "xrDestroyEyeTrackerFB",                                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyEyeTrackerFB) },
        { "xrGetEyeGazesFB",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetEyeGazesFB) },
        { "xrPassthroughLayerSetKeyboardHandsIntensityFB",                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrPassthroughLayerSetKeyboardHandsIntensityFB) },
        { "xrGetDeviceSampleRateFB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetDeviceSampleRateFB) },
        { "xrGetPassthroughPreferencesMETA",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetPassthroughPreferencesMETA) },
        { "xrCreateVirtualKeyboardMETA",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateVirtualKeyboardMETA) },
        { "xrDestroyVirtualKeyboardMETA",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyVirtualKeyboardMETA) },
        { "xrCreateVirtualKeyboardSpaceMETA",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateVirtualKeyboardSpaceMETA) },
        { "xrSuggestVirtualKeyboardLocationMETA",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrSuggestVirtualKeyboardLocationMETA) },
        { "xrGetVirtualKeyboardScaleMETA",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVirtualKeyboardScaleMETA) },
        { "xrSetVirtualKeyboardModelVisibilityMETA",                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetVirtualKeyboardModelVisibilityMETA) },
        { "xrGetVirtualKeyboardModelAnimationStatesMETA",                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVirtualKeyboardModelAnimationStatesMETA) },
        { "xrGetVirtualKeyboardDirtyTexturesMETA",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVirtualKeyboardDirtyTexturesMETA) },
        { "xrGetVirtualKeyboardTextureDataMETA",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetVirtualKeyboardTextureDataMETA) },
        { "xrSendVirtualKeyboardInputMETA",                                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrSendVirtualKeyboardInputMETA) },
        { "xrChangeVirtualKeyboardTextContextMETA",                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrChangeVirtualKeyboardTextContextMETA) },
        { "xrEnumerateExternalCamerasOCULUS",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateExternalCamerasOCULUS) },
        { "xrEnumeratePerformanceMetricsCounterPathsMETA",                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumeratePerformanceMetricsCounterPathsMETA) },
        { "xrSetPerformanceMetricsStateMETA",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetPerformanceMetricsStateMETA) },
        { "xrGetPerformanceMetricsStateMETA",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetPerformanceMetricsStateMETA) },
        { "xrQueryPerformanceMetricsCounterMETA",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrQueryPerformanceMetricsCounterMETA) },
        { "xrSaveSpaceListFB",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrSaveSpaceListFB) },
        { "xrCreateSpaceUserFB",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpaceUserFB) },
        { "xrGetSpaceUserIdFB",                                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceUserIdFB) },
        { "xrDestroySpaceUserFB",                                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroySpaceUserFB) },
        { "xrGetRecommendedLayerResolutionMETA",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetRecommendedLayerResolutionMETA) },
        { "xrCreatePassthroughColorLutMETA",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreatePassthroughColorLutMETA) },
        { "xrDestroyPassthroughColorLutMETA",                                                                    reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyPassthroughColorLutMETA) },
        { "xrUpdatePassthroughColorLutMETA",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrUpdatePassthroughColorLutMETA) },
        { "xrGetSpaceTriangleMeshMETA",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpaceTriangleMeshMETA) },
        { "xrCreateFaceTracker2FB",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateFaceTracker2FB) },
        { "xrDestroyFaceTracker2FB",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyFaceTracker2FB) },
        { "xrGetFaceExpressionWeights2FB",                                                                       reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetFaceExpressionWeights2FB) },
        { "xrCreateEnvironmentDepthProviderMETA",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateEnvironmentDepthProviderMETA) },
        { "xrDestroyEnvironmentDepthProviderMETA",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyEnvironmentDepthProviderMETA) },
        { "xrStartEnvironmentDepthProviderMETA",                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrStartEnvironmentDepthProviderMETA) },
        { "xrStopEnvironmentDepthProviderMETA",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrStopEnvironmentDepthProviderMETA) },
        { "xrCreateEnvironmentDepthSwapchainMETA",                                                               reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateEnvironmentDepthSwapchainMETA) },
        { "xrDestroyEnvironmentDepthSwapchainMETA",                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyEnvironmentDepthSwapchainMETA) },
        { "xrEnumerateEnvironmentDepthSwapchainImagesMETA",                                                      reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnumerateEnvironmentDepthSwapchainImagesMETA) },
        { "xrGetEnvironmentDepthSwapchainStateMETA",                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetEnvironmentDepthSwapchainStateMETA) },
        { "xrAcquireEnvironmentDepthImageMETA",                                                                  reinterpret_cast<PFN_xrVoidFunction>(encode::xrAcquireEnvironmentDepthImageMETA) },
        { "xrSetEnvironmentDepthHandRemovalMETA",                                                                reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetEnvironmentDepthHandRemovalMETA) },
        { "xrSetTrackingOptimizationSettingsHintQCOM",                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrSetTrackingOptimizationSettingsHintQCOM) },
        { "xrCreatePassthroughHTC",                                                                              reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreatePassthroughHTC) },
        { "xrDestroyPassthroughHTC",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyPassthroughHTC) },
        { "xrApplyFoveationHTC",                                                                                 reinterpret_cast<PFN_xrVoidFunction>(encode::xrApplyFoveationHTC) },
        { "xrCreateSpatialAnchorHTC",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreateSpatialAnchorHTC) },
        { "xrGetSpatialAnchorNameHTC",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetSpatialAnchorNameHTC) },
        { "xrApplyForceFeedbackCurlMNDX",                                                                        reinterpret_cast<PFN_xrVoidFunction>(encode::xrApplyForceFeedbackCurlMNDX) },
        { "xrCreatePlaneDetectorEXT",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrCreatePlaneDetectorEXT) },
        { "xrDestroyPlaneDetectorEXT",                                                                           reinterpret_cast<PFN_xrVoidFunction>(encode::xrDestroyPlaneDetectorEXT) },
        { "xrBeginPlaneDetectionEXT",                                                                            reinterpret_cast<PFN_xrVoidFunction>(encode::xrBeginPlaneDetectionEXT) },
        { "xrGetPlaneDetectionStateEXT",                                                                         reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetPlaneDetectionStateEXT) },
        { "xrGetPlaneDetectionsEXT",                                                                             reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetPlaneDetectionsEXT) },
        { "xrGetPlanePolygonBufferEXT",                                                                          reinterpret_cast<PFN_xrVoidFunction>(encode::xrGetPlanePolygonBufferEXT) },
        { "xrPollFutureEXT",                                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrPollFutureEXT) },
        { "xrCancelFutureEXT",                                                                                   reinterpret_cast<PFN_xrVoidFunction>(encode::xrCancelFutureEXT) },
        { "xrEnableUserCalibrationEventsML",                                                                     reinterpret_cast<PFN_xrVoidFunction>(encode::xrEnableUserCalibrationEventsML) },
    };
}

static const auto openxr_layer_func_table = GetOpenXRLayerFuncTable();

GFXRECON_END_NAMESPACE(gfxrecon)

#endif // ENABLE_OPENXR_SUPPORT

#endif // GFXRECON_GENERATED_OPENXR_LAYER_FUNC_TABLE_H
