create sequence Abstract_Seq
	start with 1001
	minvalue 1
	maxvalue 999999999
	nocache order 
/


create schema authorization Buro

	create table Language
	(
	    Lang_Code char(2) not null
		constraint Language_pk
		    primary key,
	    Lang_Name varchar(40) not null
		constraint Language_ak
		    unique
	)
	    organization index
		
		
	create table Country
	(
	    Ctr_Code char(2) not null
		constraint Country_pk
		    primary key,
	    Ctr_Name varchar(80) not null
		constraint Country_ak
		    unique,
	    Ctr_Population number(10) default 0 not null,
	    Ctr_Has_Region_Codes number(1) default 0 not null	    
	)
		
	
	
	create table Country_Synonym (
	    Ctr_Code constraint Country_Synonym_Country_fk 
	    	references Country
	    		on delete cascade,
	    Lang_Code references Language,
	    Syn_Name varchar(80) not null
	)
/

create index Country_Synonym_Code_Name_ui
    on Country_Synonym (Ctr_Code, Syn_Name)
/

alter table Country_Synonym
    add constraint Country_Synonym_pk
        primary key (Ctr_Code, Syn_Name)
            using index Country_Synonym_Code_Name_ui
/

create table Toponym
(
    Ctr_Code char(2) not null,
    Reg_Code varchar(6),
    Cty_Id number(6)
)
/

alter table Toponym
    add Topo_Name varchar(80) not null
    add Topo_Rowid rowid not null
/

alter table my_table_name
    modify (very_long_name_1 default 1,
            very_long_name_2 default 2,
            very_long_name_3 default 3,
            very_long_name_4 default 4,
            very_long_name_5 default 5)
/

create index Toponym_Name_i
    on Toponym (Topo_Name)
/

create materialized view Toponym
    on prebuilt table
as
select Ctr_Code,
       cast(null as varchar(6)) as Reg_Code,
       cast(null as number(6)) as Cty_Id,
       Ctr_Name as Topo_Name,
       Country.rowid as Topo_Rowid
from Country
union
select Ctr_Code,
       Reg_Code,
       cast(null as number(6)) as Cty_Id,
       Reg_Name as Topo_Name,
       Region.rowid  as Topo_Rowid
from Region
union
select Ctr_Code,
       Reg_Code,
       Cty_Id,
       Cty_Name as Topo_Name,
       City.rowid as Topo_Rowid
from City
/
