/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteProjectMacro
extends Macro {
    public static final DataKey<RemoteCredentials> REMOTE_TOOL_CREDENTIALS = DataKey.create((String)"REMOTE_TOOL_CREDENTIALS");

    @NotNull
    public String getName() {
        return "RemoteProjectFileDir";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDescription() {
        String string = WDBundle.message("macro.remote.project.file.dir.description", new Object[0]);
        if (string == null) {
            RemoteProjectMacro.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String expand(@NotNull DataContext dataContext) throws Macro.ExecutionCancelledException {
        Project project;
        if (dataContext == null) {
            RemoteProjectMacro.$$$reportNull$$$0(1);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return "";
        }
        RemoteCredentials remoteCredentials = (RemoteCredentials)dataContext.getData(REMOTE_TOOL_CREDENTIALS);
        if (remoteCredentials == null) {
            return "";
        }
        for (WebServerConfig config : GroupedServersConfigManager.getInstance(project).getFlattenedServers()) {
            SshConfig sshConfig;
            if (config.getAccessType() != AccessType.SFTP || (sshConfig = config.findSshConfig(project)) == null || sshConfig.getConnectionConfigPatch() != remoteCredentials.getConnectionConfigPatch()) continue;
            DeploymentPathMapping mapping = (DeploymentPathMapping)PublishConfig.getInstance((Project)project).getNearestMappingForLocal((String)project.getBasePath(), (boolean)false, (boolean)false, (boolean)false, (Mappable)config).first;
            return config.getFileTransferConfig().getRootFolder() + String.valueOf(mapping.mapToDeployPath(project.getBasePath(), (Mappable)config));
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/RemoteProjectMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/RemoteProjectMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

