/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystem;

public final class Webdav4FileSystemConfigBuilder
extends Http4FileSystemConfigBuilder {
    private static final Webdav4FileSystemConfigBuilder BUILDER = new Webdav4FileSystemConfigBuilder();
    private static final boolean DEFAULT_FOLLOW_REDIRECT = false;

    private Webdav4FileSystemConfigBuilder() {
        super("webdav4.");
    }

    public static Webdav4FileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setCreatorName(FileSystemOptions opts, String creatorName) {
        this.setParam(opts, "creatorName", creatorName);
    }

    public String getCreatorName(FileSystemOptions opts) {
        return this.getString(opts, "creatorName");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, "followRedirect", false);
    }

    public void setVersioning(FileSystemOptions opts, boolean versioning) {
        this.setParam(opts, "versioning", versioning);
    }

    public boolean isVersioning(FileSystemOptions opts) {
        return this.getBoolean(opts, "versioning", false);
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return Webdav4FileSystem.class;
    }
}

