/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.jupyter;

import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.jupyter.ImportDataSchema;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0000\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0001\"\u0016\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"importDataSchema", "", "getImportDataSchema", "()Ljava/lang/String;", "Lorg/jetbrains/kotlinx/dataframe/jupyter/ImportDataSchema;", "file", "Ljava/io/File;", "url", "Ljava/net/URL;", "path", "core"})
public final class ImportDataSchemaKt {
    @Language(value="kts")
    @NotNull
    private static final String importDataSchema = "/** Import the type-only data schema from [url]. */\nfun importDataSchema(url: URL, name: String) {\n    val formats = listOf(\n        OpenApi(),\n    )\n    val codeGenResult = org.jetbrains.dataframe.impl.codeGen.CodeGenerator.urlCodeGenReader(url, formats)\n    when (codeGenResult) {\n        is org.jetbrains.kotlinx.dataframe.impl.codeGen.CodeGenerationReadResult.Success -> {\n            val readDfMethod = codeGenResult.getReadDfMethod(url.toExternalForm())\n            val code = readDfMethod.additionalImports.joinToString(\"\\n\") + \n                \"\\n\" + \n                codeGenResult.code.converter(name)\n\n            EXECUTE(code)\n            DISPLAY(\"Data schema successfully imported as $name\")\n        }\n\n        is org.jetbrains.kotlinx.dataframe.impl.codeGen.CodeGenerationReadResult.Error -> {\n            DISPLAY(\"Failed to read data schema from $url: ${codeGenResult.reason}\")\n        }\n    }\n}\n\n/** Import the type-only data schema from [path]. */\nfun importDataSchema(path: String, name: String): Unit = importDataSchema(URL(path), name)\n\n/** Import the type-only data schema from [file]. */\nfun importDataSchema(file: File, name: String): Unit = importDataSchema(file.toURI().toURL(), name)";

    @NotNull
    public static final ImportDataSchema importDataSchema(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new ImportDataSchema(url);
    }

    @NotNull
    public static final ImportDataSchema importDataSchema(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new ImportDataSchema(path);
    }

    @NotNull
    public static final ImportDataSchema importDataSchema(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new ImportDataSchema(file);
    }

    @NotNull
    public static final String getImportDataSchema() {
        return importDataSchema;
    }
}

