/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.ForceResolvedColumn;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0096\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\u0011\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004H\u0096\u0001J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0001J\u0013\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u0019\u001a\u00020\u0012H\u0096\u0003J)\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\n\u0010\u001c\u001a\u00020\u001d\"\u00020\u0012H\u0096\u0003J\u0019\u0010\u0018\u001a\n\u0012\u0002\b\u00030\u001ej\u0002`\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0003J\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120#H\u0096\u0003J\u001d\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001e2\u0006\u0010$\u001a\u00020%H\u0096\u0003J\u001f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\u0010&\u001a\n\u0012\u0002\b\u00030'j\u0002`(H\u0096\u0003J+\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u001e2\b\u0010*\u001a\u0004\u0018\u00010\u00172\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0096\u0003J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u000e\u0010&\u001a\n\u0012\u0002\b\u00030'j\u0002`(H\u0016J \u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00042\u000e\u0010&\u001a\n\u0012\u0002\b\u00030'j\u0002`(H\u0016J\t\u0010.\u001a\u00020\u000fH\u0096\u0001J\b\u0010/\u001a\u00020\u0012H\u0016J\u0015\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000401H\u0096\u0003J\t\u00102\u001a\u000203H\u0096\u0001J\t\u00104\u001a\u00020!H\u0096\u0001J\t\u00105\u001a\u000206H\u0096\u0001J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00108\u001a\u00020!H\u0016J\"\u00109\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040;0:2\u0006\u0010<\u001a\u00020=H\u0016J\u001e\u0010>\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=H\u0016J\t\u0010?\u001a\u00020\u0012H\u0096\u0001J\u0015\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040:H\u0096\u0001J\u0015\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040BH\u0096\u0001J\b\u0010C\u001a\u00020!H\u0016J\t\u0010D\u001a\u00020EH\u0096\u0001J\u0015\u0010F\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040#H\u0096\u0001R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/ResolvingFrameColumn;", "T", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "Lorg/jetbrains/kotlinx/dataframe/impl/columns/ForceResolvedColumn;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "source", "(Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;)V", "schema", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "getSchema", "()Lkotlin/Lazy;", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "contains", "", "value", "countDistinct", "", "defaultValue", "distinct", "equals", "other", "", "get", "index", "Lorg/jetbrains/kotlinx/dataframe/columns/BaseColumn;", "firstIndex", "otherIndices", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "columnName", "", "indices", "", "range", "Lkotlin/ranges/IntRange;", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "getValueOrNull", "hasNulls", "hashCode", "iterator", "", "kind", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnKind;", "name", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "rename", "newName", "resolve", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "resolveSingle", "size", "toList", "toSet", "", "toString", "type", "Lkotlin/reflect/KType;", "values", "core"})
public final class ResolvingFrameColumn<T>
implements FrameColumn<T>,
ForceResolvedColumn<DataFrame<? extends T>> {
    @NotNull
    private final FrameColumn<T> source;

    public ResolvingFrameColumn(@NotNull FrameColumn<? extends T> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
    }

    @Override
    @NotNull
    public FrameColumn<T> getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public Lazy<DataFrameSchema> getSchema() {
        return this.source.getSchema();
    }

    @Override
    public boolean contains(@NotNull DataFrame<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.source.contains(value);
    }

    @Override
    public int countDistinct() {
        return this.source.countDistinct();
    }

    @Override
    @Nullable
    public DataFrame<T> defaultValue() {
        return (DataFrame)this.source.defaultValue();
    }

    @Override
    @NotNull
    public FrameColumn<T> distinct() {
        return this.source.distinct();
    }

    @Override
    @NotNull
    public DataFrame<T> get(int index) {
        return (DataFrame)this.source.get(index);
    }

    @Override
    @NotNull
    public BaseColumn<DataFrame<T>> get(int firstIndex, int ... otherIndices) {
        Intrinsics.checkNotNullParameter((Object)otherIndices, (String)"otherIndices");
        return this.source.get(firstIndex, otherIndices);
    }

    @Override
    @NotNull
    public DataColumn<?> get(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return this.source.get(columnName);
    }

    @Override
    @NotNull
    public FrameColumn<T> get(@NotNull Iterable<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        return this.source.get(indices);
    }

    @Override
    @NotNull
    public DataColumn<DataFrame<T>> get(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.source.get(range);
    }

    @Override
    @NotNull
    public DataFrame<T> get(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return (DataFrame)this.source.get(row);
    }

    @Override
    @NotNull
    public DataColumn<DataFrame<T>> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return this.source.getValue(thisRef, property);
    }

    @Override
    public boolean hasNulls() {
        return this.source.hasNulls();
    }

    @Override
    @NotNull
    public Iterator<DataFrame<T>> iterator() {
        return this.source.iterator();
    }

    @Override
    @NotNull
    public ColumnKind kind() {
        return this.source.kind();
    }

    @Override
    @NotNull
    public String name() {
        return this.source.name();
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return this.source.path();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    @NotNull
    public List<DataFrame<T>> toList() {
        return this.source.toList();
    }

    @Override
    @NotNull
    public Set<DataFrame<T>> toSet() {
        return this.source.toSet();
    }

    @Override
    @NotNull
    public KType type() {
        return this.source.type();
    }

    @Override
    @NotNull
    public Iterable<DataFrame<T>> values() {
        return this.source.values();
    }

    @Override
    @NotNull
    public List<ColumnWithPath<DataFrame<T>>> resolve(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return FrameColumn.DefaultImpls.resolve(this, context);
    }

    @Override
    @Nullable
    public ColumnWithPath<DataFrame<T>> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataColumn dataColumn = UtilsKt.getColumn((ColumnsContainer)context.getDf$core(), this.getSource().name(), context.getUnresolvedColumnsPolicy$core());
        return dataColumn != null ? UtilsKt.addPath(dataColumn) : null;
    }

    @Override
    @NotNull
    public DataFrame<T> getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return FrameColumn.DefaultImpls.getValue(this, row);
    }

    @Override
    @Nullable
    public DataFrame<T> getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return FrameColumn.DefaultImpls.getValueOrNull(this, row);
    }

    @Override
    @NotNull
    public ResolvingFrameColumn<T> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new ResolvingFrameColumn(this.getSource().rename(newName));
    }

    @NotNull
    public String toString() {
        return this.getSource().toString();
    }

    public boolean equals(@Nullable Object other) {
        return UtilsKt.checkEquals(this.getSource(), other);
    }

    public int hashCode() {
        return this.getSource().hashCode();
    }
}

