/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.ChatRequestValidationUtils;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.anthropic.AnthropicChatModelName;
import dev.langchain4j.model.anthropic.InternalAnthropicHelper;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCacheType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicTextContent;
import dev.langchain4j.model.anthropic.internal.api.AnthropicThinking;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.anthropic.internal.sanitizer.MessageSanitizer;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnthropicChatModel
implements ChatModel {
    private static final Logger log = LoggerFactory.getLogger(AnthropicChatModel.class);
    private final AnthropicClient client;
    private final String modelName;
    private final Double temperature;
    private final Double topP;
    private final Integer topK;
    private final int maxTokens;
    private final List<String> stopSequences;
    private final boolean cacheSystemMessages;
    private final boolean cacheTools;
    private final String thinkingType;
    private final Integer thinkingBudgetTokens;
    private final int maxRetries;
    private final List<ChatModelListener> listeners;

    private AnthropicChatModel(String baseUrl, String apiKey, String version, String beta, String modelName, Double temperature, Double topP, Integer topK, Integer maxTokens, List<String> stopSequences, Boolean cacheSystemMessages, Boolean cacheTools, String thinkingType, Integer thinkingBudgetTokens, Duration timeout2, Integer maxRetries, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners) {
        this.client = ((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)((AnthropicClient.Builder)AnthropicClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.anthropic.com/v1/"))).apiKey(apiKey)).version((String)Utils.getOrDefault((Object)version, (Object)"2023-06-01"))).beta(beta)).timeout((Duration)Utils.getOrDefault((Object)timeout2, (Object)Duration.ofSeconds(60L)))).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false))).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false))).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.temperature = temperature;
        this.topP = topP;
        this.topK = topK;
        this.maxTokens = (Integer)Utils.getOrDefault((Object)maxTokens, (Object)1024);
        this.stopSequences = stopSequences;
        this.cacheSystemMessages = (Boolean)Utils.getOrDefault((Object)cacheSystemMessages, (Object)false);
        this.cacheTools = (Boolean)Utils.getOrDefault((Object)cacheTools, (Object)false);
        this.thinkingType = thinkingType;
        this.thinkingBudgetTokens = thinkingBudgetTokens;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)2);
        this.listeners = listeners == null ? Collections.emptyList() : new ArrayList<ChatModelListener>(listeners);
    }

    public static AnthropicChatModelBuilder builder() {
        return new AnthropicChatModelBuilder();
    }

    public ChatResponse chat(ChatRequest chatRequest) {
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatRequestValidationUtils.validateParameters((ChatRequestParameters)parameters);
        ChatRequestValidationUtils.validate((ToolChoice)parameters.toolChoice());
        ChatRequestValidationUtils.validate((ResponseFormat)parameters.responseFormat());
        Response<AiMessage> response = this.generate(chatRequest.messages(), parameters.toolSpecifications());
        return ChatResponse.builder().aiMessage((AiMessage)response.content()).metadata(ChatResponseMetadata.builder().tokenUsage(response.tokenUsage()).finishReason(response.finishReason()).build()).build();
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        List<ChatMessage> sanitizedMessages = MessageSanitizer.sanitizeMessages(messages);
        List<AnthropicTextContent> systemPrompt = AnthropicMapper.toAnthropicSystemPrompt(messages, this.cacheSystemMessages ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE);
        AnthropicCreateMessageRequest request = AnthropicCreateMessageRequest.builder().model(this.modelName).messages(AnthropicMapper.toAnthropicMessages(sanitizedMessages)).system(systemPrompt).maxTokens(this.maxTokens).stopSequences(this.stopSequences).stream(false).temperature(this.temperature).topP(this.topP).topK(this.topK).tools(AnthropicMapper.toAnthropicTools(toolSpecifications, this.cacheTools ? AnthropicCacheType.EPHEMERAL : AnthropicCacheType.NO_CACHE)).thinking(AnthropicChatModel.toThinking(this.thinkingType, this.thinkingBudgetTokens)).build();
        ChatRequest listenerRequest = InternalAnthropicHelper.createListenerRequest(request, messages, toolSpecifications);
        ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        ChatModelRequestContext requestContext = new ChatModelRequestContext(listenerRequest, this.provider(), attributes);
        this.listeners.forEach(listener -> {
            try {
                listener.onRequest(requestContext);
            }
            catch (Exception e) {
                log.warn("Exception while calling model listener", e);
            }
        });
        try {
            AnthropicCreateMessageResponse response = (AnthropicCreateMessageResponse)RetryUtils.withRetryMappingExceptions(() -> this.client.createMessage(request), (int)this.maxRetries);
            Response responseMessage = Response.from((Object)AnthropicMapper.toAiMessage(response.content), (TokenUsage)AnthropicMapper.toTokenUsage(response.usage), (FinishReason)AnthropicMapper.toFinishReason(response.stopReason));
            ChatResponse listenerResponse = InternalAnthropicHelper.createListenerResponse(response.id, response.model, (Response<AiMessage>)responseMessage);
            ChatModelResponseContext responseContext = new ChatModelResponseContext(listenerResponse, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onResponse(responseContext);
                }
                catch (Exception e) {
                    log.warn("Exception while calling model listener", e);
                }
            });
            return Response.from((Object)AnthropicMapper.toAiMessage(response.content), (TokenUsage)AnthropicMapper.toTokenUsage(response.usage), (FinishReason)AnthropicMapper.toFinishReason(response.stopReason));
        }
        catch (RuntimeException e) {
            ChatModelErrorContext errorContext = InternalAnthropicHelper.createErrorContext(e, listenerRequest, this.provider(), attributes);
            this.listeners.forEach(listener -> {
                try {
                    listener.onError(errorContext);
                }
                catch (Exception e2) {
                    log.warn("Exception while calling model listener", e2);
                }
            });
            throw e;
        }
    }

    static AnthropicThinking toThinking(String thinkingType, Integer thinkingBudgetTokens) {
        if (thinkingType != null || thinkingBudgetTokens != null) {
            return AnthropicThinking.builder().type(thinkingType).budgetTokens(thinkingBudgetTokens).build();
        }
        return null;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.ANTHROPIC;
    }

    public static class AnthropicChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String version;
        private String beta;
        private String modelName;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Integer maxTokens;
        private List<String> stopSequences;
        private Boolean cacheSystemMessages;
        private Boolean cacheTools;
        private String thinkingType;
        private Integer thinkingBudgetTokens;
        private Duration timeout;
        private Integer maxRetries;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;

        public AnthropicChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public AnthropicChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AnthropicChatModelBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnthropicChatModelBuilder beta(String beta) {
            this.beta = beta;
            return this;
        }

        public AnthropicChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public AnthropicChatModelBuilder modelName(AnthropicChatModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public AnthropicChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AnthropicChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public AnthropicChatModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public AnthropicChatModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public AnthropicChatModelBuilder stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this;
        }

        public AnthropicChatModelBuilder cacheSystemMessages(Boolean cacheSystemMessages) {
            this.cacheSystemMessages = cacheSystemMessages;
            return this;
        }

        public AnthropicChatModelBuilder cacheTools(Boolean cacheTools) {
            this.cacheTools = cacheTools;
            return this;
        }

        public AnthropicChatModelBuilder thinkingType(String thinkingType) {
            this.thinkingType = thinkingType;
            return this;
        }

        public AnthropicChatModelBuilder thinkingBudgetTokens(Integer thinkingBudgetTokens) {
            this.thinkingBudgetTokens = thinkingBudgetTokens;
            return this;
        }

        public AnthropicChatModelBuilder timeout(Duration timeout2) {
            this.timeout = timeout2;
            return this;
        }

        public AnthropicChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public AnthropicChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public AnthropicChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public AnthropicChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public AnthropicChatModel build() {
            return new AnthropicChatModel(this.baseUrl, this.apiKey, this.version, this.beta, this.modelName, this.temperature, this.topP, this.topK, this.maxTokens, this.stopSequences, this.cacheSystemMessages, this.cacheTools, this.thinkingType, this.thinkingBudgetTokens, this.timeout, this.maxRetries, this.logRequests, this.logResponses, this.listeners);
        }
    }
}

