/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;
import org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;
import org.locationtech.jts.operation.distance.GeometryLocation;

public class IndexedFacetDistance {
    private static final FacetSequenceDistance FACET_SEQ_DIST = new FacetSequenceDistance();
    private STRtree cachedTree;
    private Geometry baseGeometry;

    public static double distance(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.distance(g2);
    }

    public static boolean isWithinDistance(Geometry g1, Geometry g2, double distance) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.isWithinDistance(g2, distance);
    }

    public static Coordinate[] nearestPoints(Geometry g1, Geometry g2) {
        IndexedFacetDistance dist = new IndexedFacetDistance(g1);
        return dist.nearestPoints(g2);
    }

    public IndexedFacetDistance(Geometry geom) {
        this.baseGeometry = geom;
        this.cachedTree = FacetSequenceTreeBuilder.build(geom);
    }

    public double distance(Geometry g) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g);
        Object[] obj2 = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        FacetSequence fs1 = (FacetSequence)obj2[0];
        FacetSequence fs2 = (FacetSequence)obj2[1];
        return fs1.distance(fs2);
    }

    public GeometryLocation[] nearestLocations(Geometry g) {
        STRtree tree2 = FacetSequenceTreeBuilder.build(g);
        Object[] obj2 = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        FacetSequence fs1 = (FacetSequence)obj2[0];
        FacetSequence fs2 = (FacetSequence)obj2[1];
        return fs1.nearestLocations(fs2);
    }

    public Coordinate[] nearestPoints(Geometry g) {
        GeometryLocation[] minDistanceLocation = this.nearestLocations(g);
        Coordinate[] nearestPts = IndexedFacetDistance.toPoints(minDistanceLocation);
        return nearestPts;
    }

    private static Coordinate[] toPoints(GeometryLocation[] locations) {
        if (locations == null) {
            return null;
        }
        Coordinate[] nearestPts = new Coordinate[]{locations[0].getCoordinate(), locations[1].getCoordinate()};
        return nearestPts;
    }

    public boolean isWithinDistance(Geometry g, double maxDistance) {
        double envDist = this.baseGeometry.getEnvelopeInternal().distance(g.getEnvelopeInternal());
        if (envDist > maxDistance) {
            return false;
        }
        STRtree tree2 = FacetSequenceTreeBuilder.build(g);
        return this.cachedTree.isWithinDistance(tree2, FACET_SEQ_DIST, maxDistance);
    }

    private static class FacetSequenceDistance
    implements ItemDistance {
        private FacetSequenceDistance() {
        }

        @Override
        public double distance(ItemBoundable item1, ItemBoundable item2) {
            FacetSequence fs1 = (FacetSequence)item1.getItem();
            FacetSequence fs2 = (FacetSequence)item2.getItem();
            return fs1.distance(fs2);
        }
    }
}

