/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.lexer;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.TokenPattern;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.lexer.PreprocessingLexer;
import java.util.regex.MatchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPreprocessingLexer
extends PreprocessingLexer {
    private final boolean myProcessStrings;
    private int myMatchedStep;
    private int myNameGroup;
    private int myStringState;
    private int myContentStart;

    private SqlPreprocessingLexer(@NotNull Lexer lexer, @Nullable TokenPattern userParamPattern, @Nullable String statementDelimiter, boolean processStrings) {
        if (lexer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(0);
        }
        super(lexer, userParamPattern, statementDelimiter);
        this.myStringState = -1;
        this.myContentStart = -1;
        this.myProcessStrings = processStrings;
    }

    @Override
    protected void onMatchFound() {
        IElementType type = this.getOriginalType();
        if (!SqlTokens.STRING_CONTENT_TOKENS.contains(type)) {
            super.onMatchFound();
            return;
        }
        int start2 = this.getOriginalStart();
        if (this.getMatchStart() == start2) {
            this.toParamState();
        } else if (SqlTokens.SQL_STRING_TOKEN == type) {
            this.myStringState = 0;
            int end = this.getOriginalEnd();
            this.myContentStart = StringUtil.indexOf((CharSequence)this.getBufferSequence(), (char)'\'', (int)start2, (int)end) + 1;
            if (this.myContentStart == 0) {
                this.myContentStart = start2;
            }
        } else {
            this.myStringState = 1;
            this.myContentStart = start2;
        }
        this.advanceIntoMatch(this.getState());
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(1);
        }
        this.myStringState = -1;
        super.start(buffer, startOffset, endOffset, initialState);
    }

    @Override
    protected boolean skipToken(IElementType tokenType, int s, int e, int ms, int me) {
        return SqlTokens.COMMENT_TOKENS.contains(tokenType) && s < ms || this.skipString(tokenType, s, e, ms, me) || tokenType == SqlTokens.SQL_IDENT_DELIMITED || tokenType == SqlTokens.SQL_RAW_INPUT || tokenType instanceof SqlTokenType.SqlInjectionMark;
    }

    private boolean skipString(IElementType tokenType, int s, int e, int ms, int me) {
        if (SqlTokens.STRING_QUOTE_TOKENS.contains(tokenType)) {
            return true;
        }
        if (!SqlTokens.STRING_CONTENT_TOKENS.contains(tokenType)) {
            return false;
        }
        if (!this.myProcessStrings) {
            return true;
        }
        if (tokenType == SqlTokens.SQL_STRING_TOKEN) {
            return s >= ms || me >= e;
        }
        return s > ms || me > e;
    }

    @Override
    protected void onNextMatched() {
        this.myNameGroup = 0;
        this.myMatchedStep = 0;
        if (this.isDelimiterMatch()) {
            return;
        }
        MatchResult match = this.getMatch();
        for (int i2 = match.groupCount(); i2 > 0; --i2) {
            if (match.start(i2) == -1) continue;
            this.myNameGroup = i2;
            this.myMatchedStep = match.end(i2) == match.end() ? 4 : 1;
        }
    }

    @Override
    protected boolean advanceInMatched() {
        if (this.myStringState == -1) {
            return this.advanceInMatchedImpl();
        }
        if (this.myStringState == 0) {
            int start2 = this.myContentStart;
            if (start2 == this.getMatchStart()) {
                this.toParamState();
            } else {
                this.toContentState(start2);
            }
        } else {
            if (this.myStringState == 3) {
                return this.finishStringMatch();
            }
            if (this.myStringState == 2) {
                int mEnd;
                if (this.advanceInMatchedImpl()) {
                    return true;
                }
                int end = this.getOriginalEnd();
                if (end == (mEnd = this.getMatchEnd())) {
                    return this.finishStringMatch();
                }
                this.findMatchFrom(mEnd);
                if (mEnd == this.getMatchStart()) {
                    this.toParamState();
                } else {
                    this.toContentState(mEnd);
                }
            } else if (this.myStringState == 1) {
                int end = this.getOriginalEnd();
                int mStart = this.getMatchStart();
                if (mStart >= end) {
                    if (this.getMatchedTokenEnd() == end - 1) {
                        this.myStringState = 3;
                        return true;
                    }
                    return this.finishStringMatch();
                }
                this.toParamState();
            } else {
                return this.finishStringMatch();
            }
        }
        return true;
    }

    private void toParamState() {
        this.myStringState = 2;
        this.onNextMatched();
    }

    private void toContentState(int start2) {
        if (this.getOriginalType() == SqlTokens.SQL_STRING_TOKEN && start2 == this.getOriginalEnd() - 1) {
            this.myStringState = 3;
        } else {
            this.myContentStart = start2;
            this.myStringState = 1;
        }
    }

    private boolean finishStringMatch() {
        this.myStringState = -1;
        return false;
    }

    private boolean advanceInMatchedImpl() {
        if (this.myNameGroup == 0 || this.myMatchedStep == 3 || this.myMatchedStep == 5) {
            return false;
        }
        ++this.myMatchedStep;
        return true;
    }

    @Override
    protected IElementType getMatchedTokenType() {
        if (this.isDelimiterMatch()) {
            return SqlCommonTokens.SQL_SEMICOLON;
        }
        if (this.myNameGroup == 0) {
            return SqlTokens.SQL_EXTERNAL_PARAM;
        }
        return switch (this.myMatchedStep) {
            case 1 -> SqlTokens.SQL_CUSTOM_PARAM_LQUOTE;
            case 2 -> SqlTokens.SQL_IDENT;
            case 3 -> SqlTokens.SQL_CUSTOM_PARAM_RQUOTE;
            case 4 -> SqlTokens.SQL_EXTERNAL_PARAM_PREFIX;
            case 5 -> SqlTokens.SQL_IDENT;
            default -> throw new AssertionError();
        };
    }

    @Override
    protected int getMatchedTokenStart() {
        if (this.myStringState == 0) {
            return this.getOriginalStart();
        }
        if (this.myStringState == 1) {
            return this.myContentStart;
        }
        if (this.myStringState == 3) {
            return this.getOriginalEnd() - 1;
        }
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenStart();
        }
        return switch (this.myMatchedStep) {
            case 1, 4 -> super.getMatchedTokenStart();
            case 2, 5 -> this.getMatch().start(this.myNameGroup);
            case 3 -> this.getMatch().end(this.myNameGroup);
            default -> throw new AssertionError();
        };
    }

    @Override
    protected int getMatchedTokenEnd() {
        if (this.myStringState == 0) {
            return this.myContentStart;
        }
        if (this.myStringState == 1) {
            return Math.min(this.getMatchStart(), this.getOriginalEnd() - (this.getOriginalType() == SqlTokens.SQL_STRING_TOKEN ? 1 : 0));
        }
        if (this.myStringState == 3) {
            return this.getOriginalEnd();
        }
        if (this.myNameGroup == 0) {
            return super.getMatchedTokenEnd();
        }
        return switch (this.myMatchedStep) {
            case 1, 4 -> this.getMatch().start(this.myNameGroup);
            case 2, 5 -> this.getMatch().end(this.myNameGroup);
            case 3 -> super.getMatchedTokenEnd();
            default -> throw new AssertionError();
        };
    }

    @Override
    @Nullable
    public IElementType getTokenType() {
        if (this.myStringState == 0) {
            return SqlTokens.SQL_CUSTOM_LQUOTE;
        }
        if (this.myStringState == 3) {
            return SqlTokens.SQL_CUSTOM_RQUOTE;
        }
        if (this.myStringState == 1) {
            return SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
        }
        return super.getTokenType();
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@Nullable Project project, @NotNull ParserDefinition parserDefinition, @Nullable Language hostLanguage) {
        if (parserDefinition == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(2);
        }
        return SqlPreprocessingLexer.withPreprocessingIfNeeded(parserDefinition.createLexer(project), parserDefinition.getFileNodeType().getLanguage(), hostLanguage, DatabaseSettings.getSettings());
    }

    @Nullable
    public static Language getHostLanguage(@Nullable PsiElement injectionHost) {
        if (injectionHost == null) {
            return null;
        }
        Language language = injectionHost.getLanguage();
        if (language != SqlLanguage.INSTANCE) {
            return language;
        }
        return SqlImplUtil.getSqlDialectSafe(injectionHost);
    }

    @NotNull
    public static Lexer withPreprocessingIfNeeded(@NotNull Lexer lexer, @NotNull Language language, @Nullable Language hostLanguage, @Nullable DatabaseSettings settings) {
        if (lexer == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(3);
        }
        if (language == null) {
            SqlPreprocessingLexer.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            Lexer lexer2 = lexer;
            if (lexer2 == null) {
                SqlPreprocessingLexer.$$$reportNull$$$0(5);
            }
            return lexer2;
        }
        TokenPattern userParamPattern = TokenPatternCache.getPattern(settings, hostLanguage, language);
        String statementDelimiter = settings.statementDelimiter;
        if (userParamPattern == null && statementDelimiter == null) {
            Lexer lexer3 = lexer;
            if (lexer3 == null) {
                SqlPreprocessingLexer.$$$reportNull$$$0(6);
            }
            return lexer3;
        }
        boolean processStrings = settings.userPatterns.processStrings;
        return new SqlPreprocessingLexer(lexer, userParamPattern, statementDelimiter, processStrings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/lexer/SqlPreprocessingLexer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withPreprocessingIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withPreprocessingIfNeeded";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

