/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import org.jetbrains.annotations.Nullable;

public enum ClusterType {
    INDEX('I'),
    HASH('H');

    final char code;

    private ClusterType(char code) {
        this.code = code;
    }

    @Nullable
    public static ClusterType of(char code) {
        return switch (code) {
            case 'I', 'i' -> INDEX;
            case 'H', 'h' -> HASH;
            default -> null;
        };
    }

    @Nullable
    public static ClusterType of(@Nullable String code) {
        return code != null && !code.isEmpty() ? ClusterType.of(code.charAt(0)) : null;
    }
}

