/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;

public final class RedisDomains
extends BaseDomainRegistry {
    public RedisDomains() {
        this.add(new UnknownDomain("null"));
        this.add(new TextDomain("string", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new IntegerDomain("long", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new SimpleDomain("array", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("map", ConversionPoint.MAP).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new SimpleDomain("object", ConversionPoint.JSON).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 127L, -1L, true, false));
    }
}

