/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.EitherKt;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducer;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteCloseable;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 S*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u00042\u00020\u0005:\u0005STUVWB\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJC\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H)0'\"\u0004\b\u0002\u0010)2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H)0.H\u0016\u00a2\u0006\u0002\u00100J)\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002010'2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u00020\u001fH\u0016J\u001d\u00104\u001a\u0002052\u0006\u0010*\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u00107J)\u00108\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002010'2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,H\u0002\u00a2\u0006\u0002\u00102J7\u00109\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020:0'2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,2\f\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010<H\u0002\u00a2\u0006\u0002\u0010=J!\u0010>\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00028\u00010'2\u0006\u0010*\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010?J\u0015\u0010@\u001a\u00028\u00012\u0006\u00106\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020\u001fH\u0014J'\u0010C\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010<0'2\u0006\u0010*\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010?J1\u0010D\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020:0'2\u0006\u0010*\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u00012\u0006\u0010E\u001a\u00020:H$\u00a2\u0006\u0002\u0010FJ%\u0010G\u001a\u00020:2\u0006\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020,2\u0006\u00106\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010HJ\u001d\u0010I\u001a\u00028\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010*\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010JJ/\u0010K\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0L0'2\u0006\u0010*\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010NJ\u0016\u0010O\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00028\u00010<H\u0002J\u0015\u0010P\u001a\u0002052\u0006\u0010Q\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010RR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0015X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006X"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "INPUT", "STATEMENT", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "getConfiguration", "()Lcom/intellij/database/dataSource/connection/statements/Configuration;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder;", "source", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementSource;", "getSource", "()Lcom/intellij/database/dataSource/connection/statements/SmartStatementSource;", "currentStatement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "running", "", "getRunning", "()Z", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "getDepartment", "()Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "execute", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "T", "input", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "callback", "Lkotlin/Function1;", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lkotlin/jvm/functions/Function1;)Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;)Lcom/intellij/database/dataSource/connection/Either;", "cancel", "configure", "", "statement", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "executeInCommonWay", "memorizeAndExecute", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "ref", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;)Lcom/intellij/database/dataSource/connection/Either;", "statementInstance", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/Either;", "updateStatementConfiguration", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/remote/jdbc/RemoteStatement;", "needToDisableEscapeProcessing", "getCurrentStatement", "after", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "executeJdbcStatement", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemoteStatement;", "before", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemoteStatement;)Lcom/intellij/database/dataSource/connection/Either;", "reportProcessed", "closeStatement", "it", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "Companion", "Parameterized", "Call", "Simple", "ExceptionTransformer", "intellij.database.core.impl"})
public abstract class JdbcBasedSmartStatement<INPUT, STATEMENT extends RemoteStatement>
implements SmartStatement<INPUT>,
SmartStatementMark {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ListenerAuditService auditService;
    @NotNull
    private final Configuration configuration;
    @Nullable
    private STATEMENT currentStatement;
    @NotNull
    private static final Logger LOG;

    public JdbcBasedSmartStatement(@NotNull DatabaseConnectionCore connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.connection = connection;
        this.auditService = auditService;
        this.configuration = configuration;
    }

    @NotNull
    protected final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    protected final ListenerAuditService getAuditService() {
        return this.auditService;
    }

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected abstract StatementHolder<STATEMENT> getStatementHolder();

    @Override
    @NotNull
    public SmartStatementSource getSource() {
        return this.configuration.getSource();
    }

    @Override
    public boolean getRunning() {
        return this.currentStatement != null;
    }

    @Override
    @NotNull
    public DatabaseDepartment getDepartment() {
        return this.configuration.getDepartment();
    }

    @Override
    @NotNull
    public <T> Either<StagedException, T> execute(INPUT input, @NotNull ExecutionMode mode, @NotNull Function1<? super ResultsProducer, ? extends T> callback) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return EitherKt.transformSafe(this.executeInCommonWay(input, mode), arg_0 -> JdbcBasedSmartStatement.execute$lambda$1(this, callback, arg_0));
    }

    @Override
    @NotNull
    public Either<StagedException, ClosableResultsProducer> execute(INPUT input, @NotNull ExecutionMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return this.executeInCommonWay(input, mode).shelter(JdbcBasedSmartStatement::execute$lambda$2);
    }

    @Override
    public boolean cancel() {
        STATEMENT current = this.currentStatement;
        if (current == null) {
            return true;
        }
        return SmartStatementsUtil.runWithoutReporting(this.connection, StagedException.Stage.CANCEL, this, () -> JdbcBasedSmartStatement.cancel$lambda$3(current)).isRight();
    }

    protected void configure(INPUT input, @NotNull STATEMENT statement) throws SQLException {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        JdbcHelper jdbcHelper = DbImplUtilCore.getJdbcHelper(this.connection.getDbms());
        Intrinsics.checkNotNullExpressionValue((Object)jdbcHelper, (String)"getJdbcHelper(...)");
        JdbcHelper helper = jdbcHelper;
        if (this.configuration.getMaxRows() != null && helper.supportsLimitMaxRows()) {
            statement.setMaxRows(this.configuration.getMaxRows().intValue());
        }
        if (this.configuration.getFetchSize() != null) {
            statement.setFetchSize(this.configuration.getFetchSize().intValue());
        }
    }

    private final Either<StagedException, ClosableResultsProducer> executeInCommonWay(INPUT input, ExecutionMode mode) {
        Either<StagedException, StatementHolder.CloseableRef<STATEMENT>> statementEither = this.getCurrentStatement(input);
        StatementHolder.CloseableRef<STATEMENT> statement = statementEither.getRight();
        return EitherKt.transformSafe(statementEither, arg_0 -> JdbcBasedSmartStatement.executeInCommonWay$lambda$4(this, input, mode, arg_0)).shelter(arg_0 -> JdbcBasedSmartStatement.executeInCommonWay$lambda$5(statement, this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Either<StagedException, ExecutionResult> memorizeAndExecute(INPUT input, ExecutionMode mode, StatementHolder.CloseableRef<STATEMENT> ref) {
        Either either;
        STATEMENT statement = ref.getValue();
        boolean error = false;
        try {
            this.currentStatement = statement;
            either = EitherKt.transformSafe(EitherKt.transformSafe(this.before(input, statement), arg_0 -> JdbcBasedSmartStatement.memorizeAndExecute$lambda$7(this, input, mode, statement, arg_0)), arg_0 -> JdbcBasedSmartStatement.memorizeAndExecute$lambda$8(this, input, statement, arg_0));
        }
        catch (Throwable t) {
            try {
                error = true;
                throw t;
            }
            catch (Throwable throwable) {
                this.auditService.afterStatement(this);
                this.currentStatement = null;
                if (error) {
                    this.reportProcessed(ref);
                }
                throw throwable;
            }
        }
        this.auditService.afterStatement(this);
        this.currentStatement = null;
        return either.ifLeft((Function0<Unit>)((Function0)() -> JdbcBasedSmartStatement.memorizeAndExecute$lambda$9(this, ref)));
    }

    private final Either<StagedException, STATEMENT> statementInstance(INPUT input) {
        return EitherKt.transformSafe(SmartStatementsUtil.runReporting(this.connection, StagedException.Stage.CREATE_STATEMENT, this, () -> JdbcBasedSmartStatement.statementInstance$lambda$10(this, input)), arg_0 -> JdbcBasedSmartStatement.statementInstance$lambda$13(this, input, arg_0));
    }

    private final STATEMENT updateStatementConfiguration(STATEMENT statement) {
        if (this.needToDisableEscapeProcessing()) {
            try {
                statement.setEscapeProcessing(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return statement;
    }

    protected boolean needToDisableEscapeProcessing() {
        return Registry.Companion.is("database.disable.escape.processing");
    }

    @NotNull
    protected final Either<StagedException, StatementHolder.CloseableRef<STATEMENT>> getCurrentStatement(INPUT input) {
        return (Either)this.getStatementHolder().invoke(() -> JdbcBasedSmartStatement.getCurrentStatement$lambda$14(this, input));
    }

    @NotNull
    protected abstract Either<StagedException, ExecutionResult> after(INPUT var1, @NotNull STATEMENT var2, @NotNull ExecutionResult var3);

    @NotNull
    protected abstract ExecutionResult executeJdbcStatement(INPUT var1, @NotNull ExecutionMode var2, @NotNull STATEMENT var3) throws SQLException;

    @NotNull
    protected abstract STATEMENT createStatement(@NotNull DatabaseConnectionCore var1, INPUT var2) throws SQLException;

    @NotNull
    protected abstract Either<StagedException, List<RemoteCloseable>> before(INPUT var1, @NotNull STATEMENT var2) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void reportProcessed(StatementHolder.CloseableRef<STATEMENT> statement) {
        try {
            this.auditService.resultsProcessed(this);
        }
        finally {
            DbImplUtilCore.closeSafe(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeStatement(STATEMENT it) {
        try {
            this.connection.getAuditService().beforeStatementClosing((RemoteStatement)it, this);
        }
        finally {
            JdbcNativeUtil.performSafe(() -> it.close());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object execute$lambda$1$lambda$0(ClosableResultsProducer $it, Function1 $callback) {
        Object object;
        AutoCloseable autoCloseable = $it;
        Throwable throwable = null;
        try {
            object = $callback.invoke((Object)autoCloseable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }

    private static final Either execute$lambda$1(JdbcBasedSmartStatement this$0, Function1 $callback, ClosableResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SmartStatementsUtil.runReporting(this$0.connection, StagedException.Stage.RESULTS_PROCESSING, this$0, () -> JdbcBasedSmartStatement.execute$lambda$1$lambda$0(it, $callback));
    }

    private static final ClosableResultsProducer execute$lambda$2(ClosableResultsProducer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExceptionTransformer(it);
    }

    private static final Unit cancel$lambda$3(RemoteStatement $current) {
        $current.cancel();
        return Unit.INSTANCE;
    }

    private static final Either executeInCommonWay$lambda$4(JdbcBasedSmartStatement this$0, Object $input, ExecutionMode $mode, StatementHolder.CloseableRef it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.memorizeAndExecute($input, $mode, it);
    }

    private static final ClosableResultsProducer executeInCommonWay$lambda$5(StatementHolder.CloseableRef $statement, JdbcBasedSmartStatement this$0, ExecutionResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StatementHolder.CloseableRef closeableRef = $statement;
        Intrinsics.checkNotNull((Object)closeableRef);
        return new UniversalResultsProducer(closeableRef, this$0, this$0.configuration, this$0.connection, it);
    }

    private static final Pair memorizeAndExecute$lambda$7$lambda$6(List $filesToClose, JdbcBasedSmartStatement this$0, Object $input, ExecutionMode $mode, RemoteStatement $statement) {
        return new Pair((Object)$filesToClose, (Object)this$0.executeJdbcStatement($input, $mode, $statement));
    }

    private static final Either memorizeAndExecute$lambda$7(JdbcBasedSmartStatement this$0, Object $input, ExecutionMode $mode, RemoteStatement $statement, List filesToClose) {
        Intrinsics.checkNotNullParameter((Object)filesToClose, (String)"filesToClose");
        return SmartStatementsUtil.runReporting(this$0.connection, StagedException.Stage.EXECUTE, this$0, () -> JdbcBasedSmartStatement.memorizeAndExecute$lambda$7$lambda$6(filesToClose, this$0, $input, $mode, $statement));
    }

    private static final Either memorizeAndExecute$lambda$8(JdbcBasedSmartStatement this$0, Object $input, RemoteStatement $statement, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        List filesToClose = (List)pair.component1();
        ExecutionResult result2 = (ExecutionResult)pair.component2();
        for (RemoteCloseable closeable : filesToClose) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
        }
        return this$0.after($input, $statement, result2);
    }

    private static final Unit memorizeAndExecute$lambda$9(JdbcBasedSmartStatement this$0, StatementHolder.CloseableRef $ref) {
        this$0.reportProcessed($ref);
        return Unit.INSTANCE;
    }

    private static final RemoteStatement statementInstance$lambda$10(JdbcBasedSmartStatement this$0, Object $input) {
        Object statement = this$0.createStatement(this$0.connection, $input);
        this$0.updateStatementConfiguration(statement);
        this$0.connection.getAuditService().statementOpened((RemoteStatement)statement, this$0);
        return statement;
    }

    private static final RemoteStatement statementInstance$lambda$13$lambda$11(JdbcBasedSmartStatement this$0, Object $input, RemoteStatement $it) {
        this$0.configure($input, $it);
        return $it;
    }

    private static final Unit statementInstance$lambda$13$lambda$12(JdbcBasedSmartStatement this$0, RemoteStatement $it) {
        this$0.closeStatement($it);
        return Unit.INSTANCE;
    }

    private static final Either statementInstance$lambda$13(JdbcBasedSmartStatement this$0, Object $input, RemoteStatement it) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            either = SmartStatementsUtil.runReporting(this$0.connection, StagedException.Stage.CONFIGURE_STATEMENT, this$0, () -> JdbcBasedSmartStatement.statementInstance$lambda$13$lambda$11(this$0, $input, it)).ifLeft((Function0<Unit>)((Function0)() -> JdbcBasedSmartStatement.statementInstance$lambda$13$lambda$12(this$0, it)));
        }
        catch (Throwable t) {
            this$0.closeStatement(it);
            throw t;
        }
        return either;
    }

    private static final Either getCurrentStatement$lambda$14(JdbcBasedSmartStatement this$0, Object $input) {
        return this$0.statementInstance($input);
    }

    static {
        Logger logger2 = Logger.getInstance(JdbcBasedSmartStatement.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\r\u001a\u00028\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0014\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00028\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Call;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "basis", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "input", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "after", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "statement", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "configure", "", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)V", "createStatement", "Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "intellij.database.core.impl"})
    public static abstract class Call<INPUT>
    extends Parameterized<INPUT> {
        public Call(@NotNull DatabaseConnectionCore connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection, auditService, configuration);
        }

        @NotNull
        public abstract CallableStatementBasis basis(INPUT var1);

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(INPUT input, @NotNull RemotePreparedStatement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return EitherKt.transformSafe(super.after(input, statement, result2), arg_0 -> Call.after$lambda$0(this, input, arg_0));
        }

        @Override
        protected void configure(INPUT input, @NotNull RemotePreparedStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            super.configure(input, (RemoteStatement)statement);
            List<OutParameter<?>> outParameters = this.basis(input).getOutParameters();
            if (!((Collection)outParameters).isEmpty()) {
                RemoteCallableStatement callableStatement = (RemoteCallableStatement)statement;
                for (OutParameter<?> parameter : outParameters) {
                    parameter.register(callableStatement);
                }
            }
        }

        @Override
        @NotNull
        protected RemoteCallableStatement createStatement(@NotNull DatabaseConnectionCore connection, INPUT input) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            RemoteCallableStatement remoteCallableStatement = connection.getRemoteConnection().prepareCall(this.basis(input).getSql());
            Intrinsics.checkNotNullExpressionValue((Object)remoteCallableStatement, (String)"prepareCall(...)");
            return remoteCallableStatement;
        }

        private static final Either after$lambda$0(Call this$0, Object $input, ExecutionResult executionResult) {
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            return Either.Companion.right(executionResult.parametrize(this$0.basis($input).getOutParameters()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J!\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0002\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016J!\u0010\u0011\u001a\u0002H\f\"\u0004\b\u0002\u0010\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\f0\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$ExceptionTransformer;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "delegate", "<init>", "(Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;)V", "getDelegate", "()Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "close", "", "advance", "", "processCurrent", "T", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "processRemaining", "getParameterValue", "parameter", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "(Lcom/intellij/database/dataSource/connection/statements/OutParameter;)Ljava/lang/Object;", "", "index", "", "intellij.database.core.impl"})
    private static final class ExceptionTransformer
    implements ClosableResultsProducer {
        @NotNull
        private final ClosableResultsProducer delegate;

        public ExceptionTransformer(@NotNull ClosableResultsProducer delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public final ClosableResultsProducer getDelegate() {
            return this.delegate;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean advance() {
            try {
                return this.delegate.advance();
            }
            catch (StagedException e) {
                throw e.getBase();
            }
        }

        @Override
        public <T> T processCurrent(@NotNull ResultsProducer.Processor<T> processor) {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            try {
                return this.delegate.processCurrent(processor);
            }
            catch (StagedException e) {
                throw e.getBase();
            }
        }

        @Override
        public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor) {
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            try {
                this.delegate.processRemaining(processor);
                return;
            }
            catch (StagedException e) {
                throw e.getBase();
            }
        }

        @Override
        public <T> T getParameterValue(@NotNull OutParameter<T> parameter) {
            Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
            try {
                return this.delegate.getParameterValue(parameter);
            }
            catch (StagedException e) {
                throw e.getBase();
            }
        }

        @Override
        @Nullable
        public Object getParameterValue(int index) {
            try {
                return this.delegate.getParameterValue(index);
            }
            catch (StagedException e) {
                throw e.getBase();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0002\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00028\u0002H&\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u001d\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u0019J/\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001b2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u001f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010 J1\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\"H\u0014\u00a2\u0006\u0002\u0010$J%\u0010%\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010(J#\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010*\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010+\u00a8\u0006,"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized;", "INPUT", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "extract", "", "input", "(Ljava/lang/Object;)Ljava/lang/String;", "escapeIndexes", "Ljava/util/BitSet;", "(Ljava/lang/Object;)Ljava/util/BitSet;", "decoration", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "(Ljava/lang/Object;)Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "needToDisableEscapeProcessing", "", "createStatement", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Ljava/lang/Object;)Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "statement", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)Lcom/intellij/database/dataSource/connection/Either;", "after", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "result", "(Ljava/lang/Object;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)Lcom/intellij/database/dataSource/connection/Either;", "executeJdbcStatement", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "(Ljava/lang/Object;Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;)Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "completeStatement", "data", "(Lcom/intellij/database/remote/jdbc/RemotePreparedStatement;Ljava/lang/Object;)Ljava/util/List;", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nJdbcBasedSmartStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcBasedSmartStatement.kt\ncom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,343:1\n1617#2,9:344\n1869#2:353\n1870#2:355\n1626#2:356\n1#3:354\n*S KotlinDebug\n*F\n+ 1 JdbcBasedSmartStatement.kt\ncom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Parameterized\n*L\n209#1:344,9\n209#1:353\n209#1:355\n209#1:356\n209#1:354\n*E\n"})
    public static abstract class Parameterized<INPUT>
    extends JdbcBasedSmartStatement<INPUT, RemotePreparedStatement> {
        public Parameterized(@NotNull DatabaseConnectionCore connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection, auditService, configuration);
        }

        @NotNull
        public abstract String extract(INPUT var1);

        @NotNull
        public abstract BitSet escapeIndexes(INPUT var1);

        @NotNull
        public abstract ParameterizedStatementDecoration decoration(INPUT var1);

        @Override
        protected boolean needToDisableEscapeProcessing() {
            return false;
        }

        @Override
        @NotNull
        protected RemotePreparedStatement createStatement(@NotNull DatabaseConnectionCore connection, INPUT input) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            RemotePreparedStatement remotePreparedStatement = connection.getRemoteConnection().prepareStatement(this.extract(input));
            Intrinsics.checkNotNullExpressionValue((Object)remotePreparedStatement, (String)"prepareStatement(...)");
            return remotePreparedStatement;
        }

        @Override
        @NotNull
        protected Either<StagedException, List<RemoteCloseable>> before(INPUT input, @NotNull RemotePreparedStatement statement) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return SmartStatementsUtil.runReporting(this.getConnection(), StagedException.Stage.PARAMETERS_COMPLETION, this, () -> Parameterized.before$lambda$0(this, statement, input));
        }

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(INPUT input, @NotNull RemotePreparedStatement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return Either.Companion.right(result2);
        }

        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(INPUT input, @NotNull ExecutionMode mode, @NotNull RemotePreparedStatement statement) {
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return mode.execute(statement);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected final List<RemoteCloseable> completeStatement(@NotNull RemotePreparedStatement statement, INPUT data) throws Exception {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            BitSet escape = this.escapeIndexes(data);
            Iterable $this$mapNotNull$iv = this.decoration(data).getInParameters();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                RemoteCloseable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                CallableStatementData.InParameter parameter = (CallableStatementData.InParameter)element$iv$iv;
                boolean bl2 = false;
                if (DbImplUtilCore.setStatementParameter(statement, (JdbcColumnDescriptor)parameter.getData(), parameter.getData().getObject(), this.getConnection().getDbms(), escape.get(parameter.getIndex() - 1), parameter.getIndex(), parameter.getFormatsCache(), parameter.getFormatterCreator()) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private static final List before$lambda$0(Parameterized this$0, RemotePreparedStatement $statement, Object $input) {
            return this$0.completeStatement($statement, $input);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J*\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u00132\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\rH\u0014J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Simple;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement;", "", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "executeJdbcStatement", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "input", "mode", "Lcom/intellij/database/dataSource/connection/statements/ExecutionMode;", "statement", "before", "Lcom/intellij/database/dataSource/connection/Either;", "Lcom/intellij/database/dataSource/connection/statements/StagedException;", "", "Lcom/intellij/database/remote/jdbc/RemoteCloseable;", "after", "result", "createStatement", "scrollableIfPossible", "intellij.database.core.impl"})
    public static abstract class Simple
    extends JdbcBasedSmartStatement<String, RemoteStatement> {
        public Simple(@NotNull DatabaseConnectionCore connection, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            super(connection, auditService, configuration);
        }

        @Override
        @NotNull
        protected ExecutionResult executeJdbcStatement(@NotNull String input, @NotNull ExecutionMode mode, @NotNull RemoteStatement statement) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return mode.execute(input, statement);
        }

        @Override
        @NotNull
        protected Either<StagedException, List<RemoteCloseable>> before(@NotNull String input, @NotNull RemoteStatement statement) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            return Either.Companion.right(CollectionsKt.emptyList());
        }

        @Override
        @NotNull
        protected Either<StagedException, ExecutionResult> after(@NotNull String input, @NotNull RemoteStatement statement, @NotNull ExecutionResult result2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            return Either.Companion.right(result2);
        }

        @Override
        @NotNull
        protected RemoteStatement createStatement(@NotNull DatabaseConnectionCore connection, @NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            RemoteStatement remoteStatement = this.scrollableIfPossible(connection, this.getConfiguration());
            if (remoteStatement == null) {
                RemoteStatement remoteStatement2 = connection.getRemoteConnection().createStatement();
                remoteStatement = remoteStatement2;
                Intrinsics.checkNotNullExpressionValue((Object)remoteStatement2, (String)"createStatement(...)");
            }
            return remoteStatement;
        }

        private final RemoteStatement scrollableIfPossible(DatabaseConnectionCore connection, Configuration configuration) {
            if (!configuration.getScrollable() || !Registry.Companion.is("database.scrollable.result.sets")) {
                return null;
            }
            try {
                if (connection.getDbms().isDb2()) {
                    return null;
                }
                RemoteDatabaseMetaData metaData = connection.getRemoteMetaData();
                if (metaData != null && metaData.supportsResultSetType(1004)) {
                    return connection.getRemoteConnection().createStatement(1004, 1007);
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to create a statement with a scrollable result set type", (Throwable)e);
            }
            return null;
        }
    }
}

