/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.AbstractProfilerToolWindowPanel;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.diff.ProfilerCallStackElementsCombiner;
import com.intellij.profiler.diff.ProfilerSnapshotComparator;
import com.intellij.profiler.statistics.FusAwareActionGroup;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0006*\u00020\u0010H\u0002J6\u0010\u0011\u001a\u001b\u0012\u0017\u0012\u0015\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00130\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\nH\u0002\u00a2\u0006\u0002\u0010\u0018J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/ui/diff/CompareSnapshotsActionGroup;", "Lcom/intellij/profiler/statistics/FusAwareActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "currentComponent", "Lcom/intellij/profiler/ui/MainCallTreeDataComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ui/MainCallTreeDataComponent;)V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getCallTreeComponentOrNull", "Ljavax/swing/JComponent;", "getMatchingComponents", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "allTabs", "Lcom/intellij/ui/content/Content;", "([Lcom/intellij/ui/content/Content;)Ljava/util/List;", "compareWith", "", "baselineName", "newName", "baselineComponent", "profilerPanel", "Lcom/intellij/profiler/AbstractProfilerToolWindowPanel;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nCompareSnapshotsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareSnapshotsActionGroup.kt\ncom/intellij/profiler/ui/diff/CompareSnapshotsActionGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1563#3:84\n1634#3,3:85\n*S KotlinDebug\n*F\n+ 1 CompareSnapshotsActionGroup.kt\ncom/intellij/profiler/ui/diff/CompareSnapshotsActionGroup\n*L\n43#1:84\n43#1:85,3\n*E\n"})
public final class CompareSnapshotsActionGroup
extends FusAwareActionGroup
implements DumbAware {
    @NotNull
    private final Project project;
    @NotNull
    private final MainCallTreeDataComponent currentComponent;

    public CompareSnapshotsActionGroup(@NotNull Project project, @NotNull MainCallTreeDataComponent currentComponent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)currentComponent, (String)"currentComponent");
        super(ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_COMPARE_WITH_BASELINE, null, 2, null);
        this.project = project;
        this.currentComponent = currentComponent;
        this.getTemplatePresentation().setText(CommonProfilerBundleKt.profilerMessage("ui.diff.compare.action.text", new Object[0]));
        this.getTemplatePresentation().setIcon(AllIcons.Actions.Diff);
        this.setPopup(true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Content content;
        Content content2;
        Content[] allTabs;
        block4: {
            Content[] contentArray = allTabs = ProfilerToolWindowManager.Companion.getInstance(this.project).getAllTabs();
            int n = contentArray.length;
            for (int i = 0; i < n; ++i) {
                Content it = content2 = contentArray[i];
                boolean bl = false;
                JComponent jComponent = it.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                if (!(this.getCallTreeComponentOrNull(jComponent) == this.currentComponent)) continue;
                content = content2;
                break block4;
            }
            content = null;
        }
        if (content == null) {
            boolean $i$a$-requireNotNull-CompareSnapshotsActionGroup$getChildren$currentTab$32 = false;
            String $i$a$-requireNotNull-CompareSnapshotsActionGroup$getChildren$currentTab$32 = "Couldn't find tab related to passed component (project: " + this.project + ") (component: " + this.currentComponent + ")";
            throw new IllegalArgumentException($i$a$-requireNotNull-CompareSnapshotsActionGroup$getChildren$currentTab$32.toString());
        }
        Content currentTab = content;
        JComponent jComponent = currentTab.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        if (!(component instanceof AbstractProfilerToolWindowPanel)) {
            return new AnAction[0];
        }
        List<Pair<String, MainCallTreeDataComponent>> matchingComponents = this.getMatchingComponents(allTabs);
        Iterable iterable = matchingComponents;
        boolean $i$f$map = false;
        content2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String baselineName = (String)pair.component1();
            MainCallTreeDataComponent baselineComponent = (MainCallTreeDataComponent)pair.component2();
            collection.add(new DumbAwareAction(baselineName, this, currentTab, baselineComponent, component){
                final /* synthetic */ String $baselineName;
                final /* synthetic */ CompareSnapshotsActionGroup this$0;
                final /* synthetic */ Content $currentTab;
                final /* synthetic */ MainCallTreeDataComponent $baselineComponent;
                final /* synthetic */ JComponent $component;
                {
                    this.$baselineName = $baselineName;
                    this.this$0 = $receiver;
                    this.$currentTab = $currentTab;
                    this.$baselineComponent = $baselineComponent;
                    this.$component = $component;
                    super($baselineName);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ProfilerUsageTriggerCollector.logSnapshotInteraction$default(ProfilerUsageTriggerCollector.INSTANCE, ProfilerUsageTriggerCollector.SnapshotActionFusDescriptor.PROFILER_CREATE_DIFF, e, null, 4, null);
                    String string = this.$currentTab.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
                    MainCallTreeDataComponent mainCallTreeDataComponent = this.$baselineComponent;
                    Intrinsics.checkNotNull((Object)mainCallTreeDataComponent);
                    CompareSnapshotsActionGroup.access$compareWith(this.this$0, this.$baselineName, string, mainCallTreeDataComponent, (AbstractProfilerToolWindowPanel)((Object)this.$component));
                }
            });
        }
        return (AnAction[])UtilKt.toArray((Collection)((List)destination$iv$iv), (Object[])new AnAction[0]);
    }

    private final MainCallTreeDataComponent getCallTreeComponentOrNull(JComponent $this$getCallTreeComponentOrNull) {
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3 = $this$getCallTreeComponentOrNull;
        MainCallTreeDataComponent mainCallTreeDataComponent = jComponent3 instanceof ProfilerDumpPanel ? ((jComponent2 = ((ProfilerDumpPanel)((Object)$this$getCallTreeComponentOrNull)).getTopLevelComponent()) instanceof MainCallTreeDataComponent ? (MainCallTreeDataComponent)((Object)jComponent2) : null) : (jComponent3 instanceof ProfilerProcessPanel ? ((jComponent = ((ProfilerProcessPanel)((Object)$this$getCallTreeComponentOrNull)).getContent()) instanceof MainCallTreeDataComponent ? (MainCallTreeDataComponent)((Object)jComponent) : null) : null);
        return mainCallTreeDataComponent;
    }

    private final List<Pair<String, MainCallTreeDataComponent>> getMatchingComponents(Content[] allTabs) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])allTabs), arg_0 -> CompareSnapshotsActionGroup.getMatchingComponents$lambda$3(this, arg_0)), arg_0 -> CompareSnapshotsActionGroup.getMatchingComponents$lambda$4(this, arg_0)));
    }

    private final void compareWith(String baselineName, String newName, MainCallTreeDataComponent baselineComponent, AbstractProfilerToolWindowPanel profilerPanel) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, () -> CompareSnapshotsActionGroup.compareWith$lambda$5(newName, baselineName, this, profilerPanel, baselineComponent));
    }

    private static final Pair getMatchingComponents$lambda$3(CompareSnapshotsActionGroup this$0, Content it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getDisplayName();
        JComponent jComponent = it.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return TuplesKt.to((Object)string, (Object)this$0.getCallTreeComponentOrNull(jComponent));
    }

    private static final boolean getMatchingComponents$lambda$4(CompareSnapshotsActionGroup this$0, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        MainCallTreeDataComponent component = (MainCallTreeDataComponent)pair.component2();
        return component != null && !component.isDiff() && !Intrinsics.areEqual((Object)component, (Object)this$0.currentComponent);
    }

    private static final void compareWith$lambda$5(String $newName, String $baselineName, CompareSnapshotsActionGroup this$0, AbstractProfilerToolWindowPanel $profilerPanel, MainCallTreeDataComponent $baselineComponent) {
        Object[] objectArray = new Object[]{$newName, $baselineName};
        String tabName = CommonProfilerBundleKt.profilerMessage("ui.diff.tab.name", objectArray);
        ProfilerToolWindowManager.addProfilerDumpTab$default(ProfilerToolWindowManager.Companion.getInstance(this$0.project), new ProfilerDumpPanel(this$0.project, new ProfilerSnapshotComparator(this$0.project, ProfilerCallStackElementsCombiner.Companion.find($profilerPanel)).compare($baselineComponent.getProfilerData$intellij_profiler_common(), this$0.currentComponent.getProfilerData$intellij_profiler_common()), tabName, null, null, null), false, 2, null);
    }

    public static final /* synthetic */ void access$compareWith(CompareSnapshotsActionGroup $this, String baselineName, String newName, MainCallTreeDataComponent baselineComponent, AbstractProfilerToolWindowPanel profilerPanel) {
        $this.compareWith(baselineName, newName, baselineComponent, profilerPanel);
    }
}

