/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.defaultTheme;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.theme.FontFamilyRegistry;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.builder.defaultTheme.ThemeValuesAccess;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/DefaultPanelGridTheme;", "Lorg/jetbrains/letsPlot/core/plot/builder/defaultTheme/ThemeValuesAccess;", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "axis", "", "options", "", "", "fontFamilyRegistry", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;", "(Ljava/lang/String;Ljava/util/Map;Lorg/jetbrains/letsPlot/core/plot/base/theme/FontFamilyRegistry;)V", "majorLineKey", "", "getMajorLineKey$plot_builder", "()Ljava/util/List;", "minorLineKey", "getMinorLineKey$plot_builder", "ontopKey", "suffix", "isOntop", "", "majorLineColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "majorLineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "majorLineWidth", "", "minorLineColor", "minorLineType", "minorLineWidth", "showMajor", "showMinor", "plot-builder"})
public final class DefaultPanelGridTheme
extends ThemeValuesAccess
implements PanelGridTheme {
    @NotNull
    private final String suffix;
    @NotNull
    private final List<String> ontopKey;
    @NotNull
    private final List<String> majorLineKey;
    @NotNull
    private final List<String> minorLineKey;

    public DefaultPanelGridTheme(@NotNull String axis, @NotNull Map<String, ? extends Object> options, @NotNull FontFamilyRegistry fontFamilyRegistry) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)fontFamilyRegistry, (String)"fontFamilyRegistry");
        super(options, fontFamilyRegistry);
        this.suffix = '_' + axis;
        Object[] objectArray = new String[]{"panel_grid_ontop" + this.suffix, "panel_grid_ontop"};
        this.ontopKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"panel_grid_major" + this.suffix, "panel_grid_major", "panel_grid" + this.suffix, "panel_grid", "line"};
        this.majorLineKey = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"panel_grid_minor" + this.suffix, "panel_grid_minor", "panel_grid" + this.suffix, "panel_grid", "line"};
        this.minorLineKey = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final List<String> getMajorLineKey$plot_builder() {
        return this.majorLineKey;
    }

    @NotNull
    public final List<String> getMinorLineKey$plot_builder() {
        return this.minorLineKey;
    }

    @Override
    public boolean isOntop() {
        return this.getBoolean(this.ontopKey);
    }

    @Override
    public boolean showMajor() {
        return !this.isElemBlank(this.majorLineKey);
    }

    @Override
    public boolean showMinor() {
        return !this.isElemBlank(this.minorLineKey);
    }

    @Override
    public double majorLineWidth() {
        return this.getNumber(this.getElemValue(this.majorLineKey), "size");
    }

    @Override
    public double minorLineWidth() {
        return this.getNumber(this.getElemValue(this.minorLineKey), "size");
    }

    @Override
    @NotNull
    public Color majorLineColor() {
        return this.getColor(this.getElemValue(this.majorLineKey), "color");
    }

    @Override
    @NotNull
    public Color minorLineColor() {
        return this.getColor(this.getElemValue(this.minorLineKey), "color");
    }

    @Override
    @NotNull
    public LineType majorLineType() {
        return this.getLineType(this.getElemValue(this.majorLineKey));
    }

    @Override
    @NotNull
    public LineType minorLineType() {
        return this.getLineType(this.getElemValue(this.minorLineKey));
    }
}

