/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ErrorBorderCapable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J8\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/charts/settings/ui/TokenFieldBorder;", "Ljavax/swing/border/Border;", "Ljavax/swing/plaf/UIResource;", "Lcom/intellij/openapi/ui/ErrorBorderCapable;", "<init>", "()V", "getBorderInsets", "Ljava/awt/Insets;", "c", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "isFocused", "clipForBorder", "g2", "Ljava/awt/Graphics2D;", "intellij.charts"})
public final class TokenFieldBorder
implements Border,
UIResource,
ErrorBorderCapable {
    @Override
    @NotNull
    public Insets getBorderInsets(@Nullable Component c) {
        JBInsets jBInsets = JBUI.insets((int)5);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x2, int y2, int width2, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle r = new Rectangle(x2, y2, width2, height);
        boolean focused = this.isFocused(c);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            JBInsets.removeFrom((Rectangle)r, (Insets)DarculaUIUtil.paddings());
            g2.translate(r.x, r.y);
            this.clipForBorder(g2, r.width, r.height);
            DarculaUIUtil.Outline op = DarculaUIUtil.getOutline((JComponent)((JComponent)c));
            if (c.isEnabled() && op != null) {
                DarculaUIUtil.paintOutlineBorder((Graphics2D)g2, (int)r.width, (int)r.height, (float)0.0f, (boolean)true, (boolean)focused, (DarculaUIUtil.Outline)op);
            }
        }
        finally {
            g2.dispose();
        }
    }

    private final boolean isFocused(Component c) {
        return c instanceof JScrollPane ? ((JScrollPane)c).getViewport().getView().hasFocus() : c.hasFocus();
    }

    private final void clipForBorder(Graphics2D g2, int width2, int height) {
        Area area2 = new Area(new Rectangle2D.Float(0.0f, 0.0f, width2, height));
        float lw = DarculaUIUtil.LW.getFloat();
        float bw = DarculaUIUtil.BW.getFloat();
        area2.subtract(new Area(new Rectangle2D.Float(bw + lw, bw + lw, (float)width2 - (bw + lw) * (float)2, (float)height - (bw + lw) * (float)2)));
        area2.intersect(new Area(g2.getClip()));
        g2.setClip(area2);
    }
}

