/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.ui;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.scientific.figures.image.ImageVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.images.ImagesBundle;
import org.intellij.images.editor.ImageFileEditor;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.intellij.images.ui.ImageComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/python/scientific/ui/ScientificImageEditorUIConfigurator;", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/vfs/VirtualFile;)V", "configure", "", "createBottomPanel", "Ljavax/swing/JPanel;", "image", "Ljava/awt/image/BufferedImage;", "addMouseMovementListener", "imageComponent", "Lorg/intellij/images/ui/ImageComponent;", "bottomPanel", "setupPopupMenu", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nScientificImageEditorUIConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScientificImageEditorUIConfigurator.kt\ncom/intellij/python/scientific/ui/ScientificImageEditorUIConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n1#2:120\n1869#3:121\n1869#3,2:133\n1870#3:135\n4135#4,11:122\n*S KotlinDebug\n*F\n+ 1 ScientificImageEditorUIConfigurator.kt\ncom/intellij/python/scientific/ui/ScientificImageEditorUIConfigurator\n*L\n112#1:121\n113#1:133,2\n112#1:135\n113#1:122,11\n*E\n"})
public final class ScientificImageEditorUIConfigurator {
    @NotNull
    private final FileEditor editor;
    @NotNull
    private final VirtualFile virtualFile;

    public ScientificImageEditorUIConfigurator(@NotNull FileEditor editor, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.editor = editor;
        this.virtualFile = virtualFile;
    }

    public final void configure() {
        JComponent jComponent = this.editor.getPreferredFocusedComponent();
        ImageComponent imageComponent = jComponent instanceof ImageComponent ? (ImageComponent)jComponent : null;
        if (imageComponent == null) {
            return;
        }
        ImageComponent imageComponent2 = imageComponent;
        VirtualFile virtualFile = this.virtualFile;
        ImageVirtualFile imageVirtualFile = virtualFile instanceof ImageVirtualFile ? (ImageVirtualFile)virtualFile : null;
        BufferedImage image = imageVirtualFile != null ? imageVirtualFile.getImage() : null;
        JPanel bottomPanel = this.createBottomPanel(image, this.virtualFile);
        this.addMouseMovementListener(imageComponent2, bottomPanel);
        this.setupPopupMenu(imageComponent2);
        FileEditor fileEditor = this.editor;
        Intrinsics.checkNotNull((Object)fileEditor, (String)"null cannot be cast to non-null type org.intellij.images.editor.ImageFileEditor");
        JComponent jComponent2 = ((ImageFileEditor)fileEditor).getImageEditor().getComponent();
        Intrinsics.checkNotNull((Object)jComponent2, (String)"null cannot be cast to non-null type org.intellij.images.editor.impl.ImageEditorUI");
        ImageEditorUI imageEditorUI = (ImageEditorUI)jComponent2;
        imageEditorUI.add((Component)bottomPanel, (Object)"South");
    }

    private final JPanel createBottomPanel(BufferedImage image, VirtualFile virtualFile) {
        JPanel jPanel;
        JPanel jPanel2;
        String string;
        String dataType;
        Object object = new Object[2];
        BufferedImage bufferedImage = image;
        object[0] = bufferedImage != null ? bufferedImage.getHeight() : 0;
        BufferedImage bufferedImage2 = image;
        object[1] = bufferedImage2 != null ? bufferedImage2.getWidth() : 0;
        Object $this$createBottomPanel_u24lambda_u240 = object = new JLabel(ImagesBundle.message((String)"scientific.data.dimensions", (Object[])object));
        boolean $i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22 = false;
        ((JComponent)$this$createBottomPanel_u24lambda_u240).setForeground((Color)JBColor.DARK_GRAY);
        Object dimensionsLabel = object;
        Object $i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22 = virtualFile.getUserData(ScientificUtils.INSTANCE.getDATA_TYPE_KEY());
        Object[] it = (Object[])$i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22;
        boolean bl = false;
        String string2 = (String)(!Intrinsics.areEqual((Object)it, (Object)"None") ? $i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22 : null);
        if (string2 == null) {
            string2 = "";
        }
        if (StringsKt.isBlank((CharSequence)(dataType = string2))) {
            string = "";
        } else {
            it = new Object[]{dataType};
            String string3 = ImagesBundle.message((String)"scientific.data.type", (Object[])it);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        Object $this$createBottomPanel_u24lambda_u242 = $i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22 = new JLabel(string);
        boolean bl2 = false;
        ((JComponent)$this$createBottomPanel_u24lambda_u242).setForeground((Color)JBColor.DARK_GRAY);
        Object dataTypeLabel = $i$a$-apply-ScientificImageEditorUIConfigurator$createBottomPanel$dimensionsLabel$22;
        JLabel positionLabel = new JLabel();
        JLabel valueLabel = new JLabel();
        JPanel $this$createBottomPanel_u24lambda_u243 = jPanel2 = new JPanel(new FlowLayout(0, 10, 5));
        boolean bl3 = false;
        $this$createBottomPanel_u24lambda_u243.add(positionLabel);
        JPanel leftPanel = jPanel2;
        JPanel $this$createBottomPanel_u24lambda_u244 = $this$createBottomPanel_u24lambda_u243 = new JPanel(new FlowLayout(1, 10, 5));
        boolean bl4 = false;
        $this$createBottomPanel_u24lambda_u244.add(valueLabel);
        JPanel centerPanel = $this$createBottomPanel_u24lambda_u243;
        JPanel $this$createBottomPanel_u24lambda_u245 = jPanel = new JPanel(new FlowLayout(2, 10, 5));
        boolean bl5 = false;
        $this$createBottomPanel_u24lambda_u245.add((Component)dimensionsLabel);
        $this$createBottomPanel_u24lambda_u245.add((Component)dataTypeLabel);
        JPanel rightPanel = jPanel;
        JPanel $this$createBottomPanel_u24lambda_u246 = jPanel = new JPanel(new BorderLayout());
        boolean bl6 = false;
        $this$createBottomPanel_u24lambda_u246.add((Component)leftPanel, "West");
        $this$createBottomPanel_u24lambda_u246.add((Component)centerPanel, "Center");
        $this$createBottomPanel_u24lambda_u246.add((Component)rightPanel, "East");
        return jPanel;
    }

    private final void addMouseMovementListener(ImageComponent imageComponent, JPanel bottomPanel) {
        Component component = bottomPanel.getComponent(0);
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        Component component2 = ((JPanel)component).getComponent(0);
        Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JLabel");
        JLabel positionLabel = (JLabel)component2;
        Component component3 = bottomPanel.getComponent(1);
        Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        Component component4 = ((JPanel)component3).getComponent(0);
        Intrinsics.checkNotNull((Object)component4, (String)"null cannot be cast to non-null type javax.swing.JLabel");
        JLabel valueLabel = (JLabel)component4;
        Function0 clearLabels = () -> ScientificImageEditorUIConfigurator.addMouseMovementListener$lambda$7(positionLabel, valueLabel);
        imageComponent.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(imageComponent, positionLabel, valueLabel, (Function0<Unit>)clearLabels){
            final /* synthetic */ ImageComponent $imageComponent;
            final /* synthetic */ JLabel $positionLabel;
            final /* synthetic */ JLabel $valueLabel;
            final /* synthetic */ Function0<Unit> $clearLabels;
            {
                this.$imageComponent = $imageComponent;
                this.$positionLabel = $positionLabel;
                this.$valueLabel = $valueLabel;
                this.$clearLabels = $clearLabels;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.isPopupTrigger()) {
                    return;
                }
                double zoom = this.$imageComponent.getZoomFactor();
                BufferedImage image = this.$imageComponent.getDocument().getValue();
                int x = (int)((double)(e.getX() - 2) / zoom);
                int y = (int)((double)(e.getY() - 2) / zoom);
                if (image != null) {
                    boolean bl = 0 <= x ? x < image.getWidth() : false;
                    if (bl) {
                        boolean bl2 = 0 <= y ? y < image.getHeight() : false;
                        if (bl2) {
                            WritableRaster raster = image.getRaster();
                            int numBands = raster.getNumBands();
                            int[] pixel = new int[numBands];
                            raster.getPixel(x, y, pixel);
                            Object[] objectArray = switch (numBands) {
                                case 1, 2 -> {
                                    Object[] var12_9 = new Object[]{pixel[0]};
                                    yield ImagesBundle.message((String)"scientific.pixel.value.grayscale", (Object[])var12_9);
                                }
                                case 3, 4 -> {
                                    Object[] var12_9 = new Object[]{pixel[0], pixel[1], pixel[2]};
                                    yield ImagesBundle.message((String)"scientific.pixel.value.rgb", (Object[])var12_9);
                                }
                                default -> "";
                            };
                            Intrinsics.checkNotNull((Object)objectArray);
                            Object[] label = objectArray;
                            objectArray = new Object[]{x, y};
                            this.$positionLabel.setText(ImagesBundle.message((String)"scientific.cursor.position", (Object[])objectArray));
                            this.$valueLabel.setText((String)label);
                            return;
                        }
                    }
                }
                this.$clearLabels.invoke();
            }
        });
        imageComponent.addMouseListener((MouseListener)new MouseAdapter((Function0<Unit>)clearLabels){
            final /* synthetic */ Function0<Unit> $clearLabels;
            {
                this.$clearLabels = $clearLabels;
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$clearLabels.invoke();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void setupPopupMenu(ImageComponent imageComponent) {
        List list = UIUtil.findComponentsOfType((JComponent)imageComponent.getRootPane(), JBLayeredPane.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findComponentsOfType(...)");
        List panes = list;
        Iterable $this$forEach$iv = panes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            JBLayeredPane pane = (JBLayeredPane)element$iv;
            boolean bl = false;
            MouseListener[] mouseListenerArray = pane.getMouseListeners();
            Intrinsics.checkNotNullExpressionValue((Object)mouseListenerArray, (String)"getMouseListeners(...)");
            Object $this$filterIsInstance$iv = mouseListenerArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PopupHandler)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PopupHandler it = (PopupHandler)element$iv2;
                boolean bl2 = false;
                pane.removeMouseListener((MouseListener)it);
            }
        }
        Intrinsics.checkNotNull((Object)imageComponent, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        PopupHandler.installPopupMenu((JComponent)((JComponent)imageComponent), (String)"Images.EditorPopupMenu", (String)"popup");
    }

    private static final Unit addMouseMovementListener$lambda$7(JLabel $positionLabel, JLabel $valueLabel) {
        $positionLabel.setText("");
        $valueLabel.setText("");
        return Unit.INSTANCE;
    }
}

