/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.debugger.remote;

import com.intellij.DynamicBundle;
import com.intellij.execution.util.PathMappingsComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.python.pro.debugger.remote.PyRemoteDebugConfiguration;
import com.intellij.python.pro.debugger.remote.PyRemoteDebugConfigurationParams;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyRemoteDebugConfigurationForm
implements PyRemoteDebugConfigurationParams {
    protected JPanel generatedPanel;
    private LabeledComponent<JTextField> myPortComponent;
    private JTextField myPortField;
    private LabeledComponent<JTextField> myLocalHostComponent;
    private JTextField myHostField;
    private JTextArea myInfoTextField;
    private LabeledComponent<JCheckBox> myRedirectOutputComponent;
    private JCheckBox myRedirectOutputCheckBox;
    private JCheckBox mySuspendAfterConnectCheckBox;
    private JCheckBox myUsePathMappingCheckBox;
    private JPanel myPathMappingPanel;
    private final Project myProject;
    private final PyRemoteDebugConfiguration myConfiguration;
    private PathMappingsComponent myPathMappingsComponent;
    private JTextArea myPipTextField;
    public static final String REMOTE_DEBUG_IMPORT = "import pydevd_pycharm";
    public static final String REMOTE_DEBUG_SETTRACE_CALL = "pydevd_pycharm.settrace('$SERVER_HOST$', port=$PORT_NUMBER$$REDIRECT_OUTPUT$$SUSPEND_AFTER_CONNECT$)";
    private static final String REMOTE_PORT = "$PORT_NUMBER$";
    private static final String SERVER_HOST = "$SERVER_HOST$";
    private static final String REDIRECT_OUTPUT = "$REDIRECT_OUTPUT$";
    private static final String SUSPEND_AFTER_CONNECT = "$SUSPEND_AFTER_CONNECT$";

    public PyRemoteDebugConfigurationForm(@NotNull Project project, @NotNull PyRemoteDebugConfiguration configuration) {
        if (project == null) {
            PyRemoteDebugConfigurationForm.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            PyRemoteDebugConfigurationForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.initComponents();
    }

    protected void initComponents() {
        this.myPortField.getDocument().addDocumentListener((DocumentListener)this.createListener());
        this.myHostField.getDocument().addDocumentListener((DocumentListener)this.createListener());
        this.myRedirectOutputCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PyRemoteDebugConfigurationForm.this.updateInfoText();
            }
        });
        this.mySuspendAfterConnectCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PyRemoteDebugConfigurationForm.this.updateInfoText();
            }
        });
        this.updateInfoText();
        this.setHost(this.myConfiguration.getHost());
        this.setPort(this.myConfiguration.getPort());
        this.setMappingSettings(this.myConfiguration.getMappingSettings());
        this.setRedirectOutput(this.myConfiguration.isRedirectOutput());
        this.setSuspendAfterConnect(this.myConfiguration.isSuspendAfterConnect());
        this.initMappingTree(this.myConfiguration.getMappingSettings());
    }

    private void initMappingTree(PathMappingSettings settings) {
        this.myPathMappingsComponent.setMappingSettings(settings);
    }

    private DocumentAdapter createListener() {
        return new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                PyRemoteDebugConfigurationForm.this.updateInfoText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/python/pro/debugger/remote/PyRemoteDebugConfigurationForm$3", "textChanged"));
            }
        };
    }

    private void updateInfoText() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        this.myPipTextField.setText(PyBundle.message((String)"remote.debug.server.hint3", (Object[])new Object[0]) + "~=" + buildNumber.asStringWithoutProductCode());
        this.myInfoTextField.setText("import pydevd_pycharm\n" + PyRemoteDebugConfigurationForm.getSettraceCallText(this.myHostField.getText(), this.getPort(), this.myRedirectOutputCheckBox.isSelected(), this.mySuspendAfterConnectCheckBox.isSelected()));
    }

    public static String getSettraceCallText(String host, int port, boolean redirect, boolean suspend) {
        return REMOTE_DEBUG_SETTRACE_CALL.replace(REMOTE_PORT, PyRemoteDebugConfigurationForm.getPortSubstituteText(port)).replace(SERVER_HOST, PyRemoteDebugConfigurationForm.getHostSubstituteText(host)).replace(REDIRECT_OUTPUT, PyRemoteDebugConfigurationForm.getRedirectOutputSubstituteText(redirect)).replace(SUSPEND_AFTER_CONNECT, PyRemoteDebugConfigurationForm.getSuspendAfterConnectSubstituteText(suspend));
    }

    private static String getPortSubstituteText(int port) {
        if (port == 0) {
            return "$SERVER_PORT";
        }
        return Integer.toString(port);
    }

    private static String getHostSubstituteText(String host) {
        if (host.isEmpty()) {
            return "localhost";
        }
        return host;
    }

    private static String getRedirectOutputSubstituteText(boolean doRedirect) {
        if (doRedirect) {
            return ", stdout_to_server=True, stderr_to_server=True";
        }
        return "";
    }

    private static String getSuspendAfterConnectSubstituteText(boolean doSuspend) {
        if (!doSuspend) {
            return ", suspend=False";
        }
        return "";
    }

    private static FileChooserDescriptor addFolderChooser(@Nls String title, TextFieldWithBrowseButton textField, Project project) {
        FileChooserDescriptor folderChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title);
        textField.addBrowseFolderListener(project, folderChooserDescriptor);
        return folderChooserDescriptor;
    }

    private void createUIComponents() {
    }

    public JComponent getPanel() {
        return this.generatedPanel;
    }

    @Override
    public int getPort() {
        return PyRemoteDebugConfiguration.textToPort(this.myPortField.getText());
    }

    @Override
    public void setPort(int port) {
        this.myPortField.setText(Integer.toString(port));
    }

    @Override
    public String getHost() {
        return this.myHostField.getText();
    }

    @Override
    public void setHost(String host) {
        if (host == null || "null".equals(host) || host.isEmpty()) {
            host = "localhost";
        }
        this.myHostField.setText(host);
    }

    @Override
    public boolean isRedirectOutput() {
        return this.myRedirectOutputCheckBox.isSelected();
    }

    @Override
    public void setRedirectOutput(boolean redirectOutput) {
        this.myRedirectOutputCheckBox.setSelected(redirectOutput);
    }

    @Override
    public boolean isSuspendAfterConnect() {
        return this.mySuspendAfterConnectCheckBox.isSelected();
    }

    @Override
    public void setSuspendAfterConnect(boolean suspendAfterConnect) {
        this.mySuspendAfterConnectCheckBox.setSelected(suspendAfterConnect);
    }

    @Override
    public void setMappingSettings(PathMappingSettings mappingSettings) {
        this.myPathMappingsComponent.setMappingSettings(mappingSettings);
    }

    @Override
    public PathMappingSettings getMappingSettings() {
        return this.myPathMappingsComponent.getMappingSettings();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        PathMappingsComponent pathMappingsComponent;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextArea jTextArea;
        JTextArea jTextArea2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.generatedPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(20, 0, 20, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.local.host"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.port"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostField = jTextField2 = new JTextField();
        jTextField2.setToolTipText(DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteDebugConfigurationForm.class).getString("python.debug.host.name.tooltip"));
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPortField = jTextField = new JTextField();
        jTextField.setToolTipText(DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteDebugConfigurationForm.class).getString("python.debug.port.tooltip"));
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint1.5"));
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint2"));
        jPanel3.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint4"));
        jPanel3.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoTextField = jTextArea2 = new JTextArea();
        jTextArea2.setEditable(false);
        jPanel3.add((Component)jTextArea2, new GridConstraints(5, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myPipTextField = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.server.hint3"));
        jPanel3.add((Component)jTextArea, new GridConstraints(3, 0, 1, 1, 0, 1, 6, 0, null, new Dimension(150, 20), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(20, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRedirectOutputCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.redirect.output"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySuspendAfterConnectCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyRemoteDebugConfigurationForm.class).getString("remote.debug.suspend.on.connect"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPathMappingsComponent = pathMappingsComponent = new PathMappingsComponent();
        pathMappingsComponent.setLabelLocation("West");
        pathMappingsComponent.setText(DynamicBundle.getBundle((String)"messages/PythonProBundle", PyRemoteDebugConfigurationForm.class).getString("python.debug.path.mappings"));
        jPanel.add((Component)pathMappingsComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.generatedPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pro/debugger/remote/PyRemoteDebugConfigurationForm";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

