/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstTypeCommentOwner;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyTypeCommentOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyTypeCommentOwnerStub;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyBaseElementImpl<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements PyElement {
    public PyBaseElementImpl(T stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public PyBaseElementImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PythonLanguage getLanguage() {
        PythonLanguage pythonLanguage = (PythonLanguage)PythonFileType.INSTANCE.getLanguage();
        if (pythonLanguage == null) {
            PyBaseElementImpl.$$$reportNull$$$0(0);
        }
        return pythonLanguage;
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos >= 0) {
            className = className.substring(pos + 1);
        }
        className = StringUtil.trimEnd((String)className, (String)"Impl");
        return className;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PyBaseElementImpl.$$$reportNull$$$0(1);
        }
        PyUtil.verboseOnly(() -> PyPsiUtils.assertValid((PsiElement)this));
        if (visitor2 instanceof PyElementVisitor) {
            PyElementVisitor pyVisitor = (PyElementVisitor)visitor2;
            this.acceptPyVisitor(pyVisitor);
        } else if (visitor2 instanceof PyAstElementVisitor) {
            PyAstElementVisitor pyVisitor = (PyAstElementVisitor)visitor2;
            this.acceptPyVisitor(pyVisitor);
        } else {
            super.accept(visitor2);
        }
    }

    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyElement(this);
    }

    public PsiReference findReferenceAt(int offset) {
        return PyBaseElementImpl.findReferenceAt((PsiElement)this, offset);
    }

    @Nullable
    protected static <T extends StubBasedPsiElement<? extends PyTypeCommentOwnerStub> & PyTypeCommentOwner> String getTypeCommentAnnotationFromStubOrPsi(@NotNull T elem) {
        PyTypeCommentOwnerStub stub;
        if (elem == null) {
            PyBaseElementImpl.$$$reportNull$$$0(2);
        }
        if ((stub = (PyTypeCommentOwnerStub)elem.getStub()) != null) {
            return stub.getTypeComment();
        }
        PsiComment comment = ((PyAstTypeCommentOwner)elem).getTypeComment();
        if (comment != null) {
            return PyTypingTypeProvider.getTypeCommentValue(comment.getText());
        }
        return null;
    }

    @Nullable
    public <E extends PsiElement> E getStubOrPsiParentOfType(@NotNull Class<E> parentClass) {
        if (parentClass == null) {
            PyBaseElementImpl.$$$reportNull$$$0(3);
        }
        return (E)super.getStubOrPsiParentOfType(parentClass);
    }

    @Nullable
    static PsiReference findReferenceAt(@NotNull PsiElement target, int offset) {
        PsiElement element;
        if (target == null) {
            PyBaseElementImpl.$$$reportNull$$$0(4);
        }
        if ((element = target.findElementAt(offset)) == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset = target.getTextRange().getStartOffset() + offset - element.getTextRange().getStartOffset();
        ArrayList<PsiReference> referencesList = new ArrayList<PsiReference>();
        PsiFile file = element.getContainingFile();
        TypeEvalContext context = file != null ? TypeEvalContext.codeAnalysis(file.getProject(), file) : TypeEvalContext.codeInsightFallback(element.getProject());
        PyResolveContext resolveContext = PyResolveContext.implicitContext(context);
        while (element != null) {
            PyBaseElementImpl.addReferences(offset, element, referencesList, resolveContext);
            offset = element.getStartOffsetInParent() + offset;
            if (element instanceof PsiFile) break;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(PsiReference.EMPTY_ARRAY), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    private static void addReferences(int offset, @NotNull PsiElement element, @NotNull Collection<PsiReference> outReferences, @NotNull PyResolveContext resolveContext) {
        PsiReference[] references2;
        if (element == null) {
            PyBaseElementImpl.$$$reportNull$$$0(5);
        }
        if (outReferences == null) {
            PyBaseElementImpl.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            PyBaseElementImpl.$$$reportNull$$$0(7);
        }
        if (element instanceof PyReferenceOwner) {
            PyReferenceOwner owner = (PyReferenceOwner)element;
            PsiPolyVariantReference reference = owner.getReference(resolveContext);
            references2 = new PsiReference[]{reference};
        } else {
            references2 = element.getReferences();
        }
        for (PsiReference reference : references2) {
            for (TextRange range : ReferenceRange.getRanges((PsiReference)reference)) {
                assert (range != null) : reference;
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyBaseElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReferences";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyBaseElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCommentAnnotationFromStubOrPsi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiParentOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceAt";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

