/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.commandInterface.command.ArgumentsInfo;
import com.intellij.commandInterface.command.CommandExecutor;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.Option;
import com.intellij.commandInterface.command.SimpleCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialCaseInfo {
    @Nullable
    private final CommandExecutor myExecutor;
    @Nullable
    private final String myCommandExternalHelpUrl;
    @Nullable
    private final ArgumentsInfo myArgumentsInfo;
    @NotNull
    private final Map<String, String> myOptionsExternalUrl = new HashMap<String, String>();

    SpecialCaseInfo(@Nullable CommandExecutor executor, @Nullable String commandExternalHelpUrl, @Nullable ArgumentsInfo argumentsInfo, @Nullable Map<String, String> optionsExternalUrl) {
        this.myExecutor = executor;
        this.myCommandExternalHelpUrl = commandExternalHelpUrl;
        this.myArgumentsInfo = argumentsInfo;
        if (optionsExternalUrl != null) {
            this.myOptionsExternalUrl.putAll(optionsExternalUrl);
        }
    }

    @NotNull
    SimpleCommand apply(@NotNull SimpleCommand command) {
        Help originalHelp;
        if (command == null) {
            SpecialCaseInfo.$$$reportNull$$$0(0);
        }
        CommandExecutor commandExecutor = this.myExecutor != null ? this.myExecutor : command.getExecutor();
        ArgumentsInfo argumentsInfo = this.myArgumentsInfo != null ? this.myArgumentsInfo : command.getArgumentsInfo();
        Collection options = Collections2.transform((Collection)command.getOptions(), (Function)new OptionReplacer());
        Help newCommandHelp = originalHelp = command.getHelp(false);
        if (this.myCommandExternalHelpUrl != null) {
            newCommandHelp = new Help(originalHelp != null ? originalHelp.getHelpString() : "Check external url", this.myCommandExternalHelpUrl);
        }
        return new SimpleCommand(command.getName(), newCommandHelp, argumentsInfo, commandExecutor, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/python/django/manage/SpecialCaseInfo", "apply"));
    }

    private class OptionReplacer
    implements Function<Option, Option> {
        private OptionReplacer() {
        }

        @Nullable
        public Option apply(@Nullable Option input) {
            if (input == null) {
                return null;
            }
            for (String optionName : input.getAllNames()) {
                String newHelpUrl = SpecialCaseInfo.this.myOptionsExternalUrl.get(optionName);
                if (newHelpUrl == null) continue;
                Help newHelp = new Help(input.getHelp().getHelpString(), newHelpUrl);
                return new Option(input.getArgumentAndQuantity(), newHelp, (Collection)input.getShortNames(), (Collection)input.getLongNames());
            }
            return input;
        }
    }
}

