/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.clickhouse.psi;

import com.intellij.database.dialects.clickhouse.types.CHouseDateTime64Type;
import com.intellij.database.dialects.clickhouse.types.CHouseDateTimeType;
import com.intellij.database.dialects.clickhouse.types.CHouseTypeSystem;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlBuiltinTypeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CHouseBuiltinTypeElementImpl
extends SqlBuiltinTypeElementImpl {
    public CHouseBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Nullable
    protected DasType parseBuiltinTypeBase() {
        PsiElement firstChild = this.getFirstChild();
        if (firstChild instanceof SqlReferenceExpression) {
            return (DasType)CHouseTypeSystem.caseSensitiveTypes.get(firstChild.getText());
        }
        JBIterable keywords = SqlImplUtil.sqlChildren((PsiElement)this).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment)).takeWhile(e -> e instanceof SqlReferenceExpression || PsiUtilCore.getElementType((PsiElement)e) instanceof SqlKeywordTokenType);
        String name2 = StringUtil.join((Iterable)keywords, kw -> kw.getText(), (String)" ");
        DasBuiltinType dasType = CHouseTypeSystem.caseInsensitiveTypes.get(StringUtil.toUpperCase((String)name2));
        if (dasType == null) {
            return null;
        }
        if (!dasType.getTypeClass().getName().equals(name2)) {
            dasType = DasTypeUtilsKt.withName(dasType, (String)name2);
        }
        return dasType;
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType<?> dasType) {
        if (dasType == null) {
            CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(1);
        }
        if (dasType instanceof CHouseDateTimeType) {
            return this.adjustDateTimeType((CHouseDateTimeType)dasType);
        }
        if (dasType instanceof CHouseDateTime64Type) {
            return this.adjustDateTime64Type((CHouseDateTime64Type)dasType);
        }
        DasBuiltinType dasBuiltinType = super.adjustType(dasType);
        if (dasBuiltinType == null) {
            CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(2);
        }
        return dasBuiltinType;
    }

    @NotNull
    private CHouseDateTimeType adjustDateTimeType(CHouseDateTimeType dasType) {
        SqlStringLiteralExpression timeZoneLiteral = (SqlStringLiteralExpression)this.findChildByClass(SqlStringLiteralExpression.class);
        CHouseDateTimeType cHouseDateTimeType = timeZoneLiteral != null ? dasType.copy(timeZoneLiteral.getValue()) : dasType;
        if (cHouseDateTimeType == null) {
            CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(3);
        }
        return cHouseDateTimeType;
    }

    @NotNull
    private CHouseDateTime64Type adjustDateTime64Type(CHouseDateTime64Type dasType) {
        int precision = this.getIntAttribute();
        SqlStringLiteralExpression timeZoneLiteral = (SqlStringLiteralExpression)this.findChildByClass(SqlStringLiteralExpression.class);
        if (precision == -1 && timeZoneLiteral == null) {
            CHouseDateTime64Type cHouseDateTime64Type = dasType;
            if (cHouseDateTime64Type == null) {
                CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(4);
            }
            return cHouseDateTime64Type;
        }
        CHouseDateTime64Type cHouseDateTime64Type = dasType.copy(precision != -1 ? precision : dasType.getPrecision(), timeZoneLiteral != null ? timeZoneLiteral.getValue() : dasType.getTimeZone());
        if (cHouseDateTime64Type == null) {
            CHouseBuiltinTypeElementImpl.$$$reportNull$$$0(5);
        }
        return cHouseDateTime64Type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/clickhouse/psi/CHouseBuiltinTypeElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/clickhouse/psi/CHouseBuiltinTypeElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDateTimeType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustDateTime64Type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

