/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.tabs.ColorSelectionComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignColorDialog
extends DialogWrapper {
    private final Project myProject;
    private final Collection<DbElement> myElements;
    private final boolean myForProjectDataSource;
    protected final ColorSelectionComponent myColorComponent;
    private JPanel myMainPanel;
    private JCheckBox mySharedCheckBox;
    private JPanel myColorPlaceHolder;
    private JCheckBox mySetRecursivelyCheckBox;
    private JCheckBox myEnableColorsCheckBox;
    private JCheckBox myUseInEditorTabsCheckBox;
    private JCheckBox myUseInDatabaseViewCheckBox;
    private JCheckBox myUseInConsoleCheckBox;
    private JCheckBox myUseInEditorCheckBox;
    private TitledSeparator myAppearanceSettingsTitledSeparator;
    private JPanel myExtraSettingsPanel;
    private AbstractAction myClearAction;

    public AssignColorDialog(@NotNull Project project, @NotNull Collection<DbElement> elements, boolean compactMode, boolean forProjectDataSource) {
        if (project == null) {
            AssignColorDialog.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            AssignColorDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myElements = elements;
        this.myForProjectDataSource = forProjectDataSource;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DatabaseBundle.message((String)"database.color.settings.title", (Object[])objectArray));
        this.myColorComponent = new ColorSelectionComponent();
        this.myColorComponent.initDefault(FileColorManager.getInstance((Project)project), null);
        this.myColorComponent.setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
        LabeledComponent panel2 = LabeledComponent.create((JComponent)new Wrapper((JComponent)this.myColorComponent), (String)DatabaseBundle.message((String)"database.color.settings.color", (Object[])new Object[0]));
        panel2.setLabelLocation("West");
        this.myColorPlaceHolder.add((Component)panel2, "Center");
        this.setupComponents();
        if (compactMode) {
            this.mySetRecursivelyCheckBox.setVisible(false);
            this.mySharedCheckBox.setVisible(false);
            this.myAppearanceSettingsTitledSeparator.setVisible(false);
            this.myExtraSettingsPanel.setVisible(false);
        }
        this.mySharedCheckBox.setVisible(forProjectDataSource);
        this.init();
        this.pack();
        this.setSize(this.getSize().width, Math.max(this.getSize().height, 500));
        this.setResizable(false);
    }

    private void setupComponents() {
        DatabaseColorManager.LocalColors localColors = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(this.myProject).getState();
        Ref sharedRef = Ref.create((Object)false);
        @NonNls String curColorName = DatabaseColorManager.getColorId((DbElement)ContainerUtil.getFirstItem(this.myElements), (Ref<Boolean>)sharedRef);
        Runnable enablerRunnable = () -> {
            for (JCheckBox c2 : UIUtil.uiTraverser((Component)this.myEnableColorsCheckBox.getParent()).filter(JCheckBox.class)) {
                if (c2 == this.myEnableColorsCheckBox) continue;
                c2.setEnabled(this.myEnableColorsCheckBox.isSelected());
            }
        };
        this.myEnableColorsCheckBox.setSelected(localColors.useColors);
        this.myEnableColorsCheckBox.addActionListener(e -> enablerRunnable.run());
        enablerRunnable.run();
        this.myUseInEditorTabsCheckBox.setSelected(localColors.inEditorTabs);
        this.myUseInDatabaseViewCheckBox.setSelected(localColors.inDatabaseView);
        this.myUseInConsoleCheckBox.setSelected(localColors.useInToolbars);
        this.myUseInEditorCheckBox.setSelected(localColors.useInEditor);
        if (this.myForProjectDataSource) {
            this.mySharedCheckBox.setSelected((Boolean)sharedRef.get());
        }
        this.mySetRecursivelyCheckBox.setSelected(true);
        Color color = null;
        try {
            color = curColorName == null ? null : ColorUtil.fromHex((String)curColorName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (curColorName != null && color != null) {
            this.myColorComponent.setCustomButtonColor(color);
        } else {
            this.myColorComponent.setSelectedColor(curColorName);
        }
        this.myClearAction = new AbstractAction(DatabaseBundle.message((String)"database.color.settings.no.color", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                AssignColorDialog.this.doOKAction(true);
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = (Action[])ArrayUtil.append((Object[])super.createActions(), (Object)this.myClearAction);
        if (actionArray == null) {
            AssignColorDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    protected void doOKAction() {
        this.doOKAction(false);
    }

    protected void doOKAction(boolean clear) {
        super.doOKAction();
        DatabaseColorManager<DatabaseColorManager.LocalColors> colorManager = DatabaseColorManager.getLocalColorManager(this.myProject);
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useColors = this.myEnableColorsCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).inEditorTabs = this.myUseInEditorTabsCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).inDatabaseView = this.myUseInDatabaseViewCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useInToolbars = this.myUseInConsoleCheckBox.isSelected();
        ((DatabaseColorManager.LocalColors)colorManager.getState()).useInEditor = this.myUseInEditorCheckBox.isSelected();
        @NonNls String colorName = clear ? null : this.myColorComponent.getSelectedColorName();
        for (DbElement element : this.myElements) {
            if (this.myForProjectDataSource) {
                DatabaseColorManager.setColorId(element, colorName, this.mySetRecursivelyCheckBox.isSelected(), this.mySharedCheckBox.isSelected());
                continue;
            }
            DatabaseColorManager.setColorIdForGlobalDataSource(element, colorName, this.mySetRecursivelyCheckBox.isSelected());
        }
    }

    @Nullable
    protected String getHelpId() {
        return "database_color_settings_dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        TitledSeparator titledSeparator;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myExtraSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("html.disable", Boolean.TRUE);
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myEnableColorsCheckBox = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.enable.database.colors"));
        jPanel2.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseInDatabaseViewCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.in.database.tool.window"));
        jPanel2.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInEditorTabsCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.in.editor.tabs"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInConsoleCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.in.toolbars"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myUseInEditorCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.in.console.editors.and.grids"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myAppearanceSettingsTitledSeparator = titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.appearance.settings"));
        jPanel3.add((Component)titledSeparator, new GridConstraints(2, 0, 1, 2, 0, 3, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.myColorPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySetRecursivelyCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.override.recursively"));
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySharedCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", AssignColorDialog.class).getString("AssignColorDialog.shared"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/AssignColorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/AssignColorDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

