/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvDsGroup;
import com.intellij.database.view.structure.DvFun;
import com.intellij.database.view.structure.DvSimpleDsGroup;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"renameDsGroup", "", "project", "Lcom/intellij/openapi/project/Project;", "group", "Lcom/intellij/database/view/structure/DvSimpleDsGroup;", "newName", "", "loggingClass", "Ljava/lang/Class;", "intellij.database.impl"})
@JvmName(name="DvHandlers")
@SourceDebugExtension(value={"SMAP\nDvHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvHandlers.kt\ncom/intellij/database/view/structure/DvHandlers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n1869#2,2:60\n37#3:62\n36#3,3:63\n*S KotlinDebug\n*F\n+ 1 DvHandlers.kt\ncom/intellij/database/view/structure/DvHandlers\n*L\n34#1:60,2\n51#1:62\n51#1:63,3\n*E\n"})
public final class DvHandlers {
    public static final void renameDsGroup(@NotNull Project project, @NotNull DvSimpleDsGroup group, @NotNull String newName, @NotNull Class<?> loggingClass) {
        BasicNode newGroup;
        Iterator $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(loggingClass, (String)"loggingClass");
        DvTreeStructureService dvTreeStructureService = (DvTreeStructureService)project.getServiceIfCreated(DvTreeStructureService.class);
        if (dvTreeStructureService == null) {
            return;
        }
        DvTreeStructureService structureService = dvTreeStructureService;
        DvTreeLayer treeFoldersLayer = structureService.getFoldersLayer();
        BasicNode basicNode = treeFoldersLayer.parentOf((BasicNode)group);
        if (basicNode == null) {
            return;
        }
        BasicNode parentGroup = basicNode;
        String parentPath = parentGroup instanceof DvSimpleDsGroup ? ((DvSimpleDsGroup)parentGroup).getPath() + "/" : "";
        String newPrefix = parentPath + newName;
        String removingPrefix = group.getPath();
        int removingLength = removingPrefix.length();
        ArrayList affectedGroups = new ArrayList();
        ArrayList affectedDSN = new ArrayList();
        Object object = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DvHandlers.renameDsGroup$lambda$1(arg_0 -> DvHandlers.renameDsGroup$lambda$0(treeFoldersLayer, arg_0), arg_0)).withRoot((Object)group)).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"traverse(...)");
        object = (Iterable)object;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            BasicNode it = (BasicNode)element$iv;
            boolean bl = false;
            BasicNode basicNode2 = it;
            if (basicNode2 instanceof DvSimpleDsGroup) {
                ((Collection)affectedGroups).add(it);
                continue;
            }
            if (!(basicNode2 instanceof DataSourceNode)) continue;
            ((Collection)affectedDSN).add(it);
        }
        Iterator iterator2 = affectedDSN.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        $this$forEach$iv = iterator2;
        while ($this$forEach$iv.hasNext()) {
            DataSourceManager dsManager;
            String oldPath;
            Object e = $this$forEach$iv.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            DataSourceNode dsn = (DataSourceNode)e;
            if (dsn.getGroupName() == null || !StringsKt.startsWith$default((String)oldPath, (String)removingPrefix, (boolean)false, (int)2, null)) continue;
            String string = oldPath.substring(removingLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String newPath = newPrefix + string;
            DataSourceManager dataSourceManager = dsManager = DataSourceManager.byDataSource((Project)project, (RawDataSource)dsn.dataSource);
            if (dataSourceManager != null) {
                dataSourceManager.setGroupName(dsn.dataSource, newPath);
                continue;
            }
            Logger.getInstance(loggingClass).error("Cannot find DSManager for " + dsn.dataSource);
        }
        String[] dsn = new String[]{"/"};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)newPrefix, (String[])dsn, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] newPathNames = thisCollection$iv.toArray(new String[0]);
        BasicNode basicNode3 = newGroup = DvFun.findNode((DvTreeLayer)treeFoldersLayer, (String[])Arrays.copyOf(newPathNames, newPathNames.length));
        Set newSelection = basicNode3 != null ? SetsKt.setOf((Object)basicNode3) : SetsKt.emptySet();
        DatabaseView.refreshViewAndSelect(project, newSelection);
    }

    private static final Iterable renameDsGroup$lambda$0(DvTreeLayer $treeFoldersLayer, BasicNode node) {
        return node instanceof DvDsGroup ? (Iterable)$treeFoldersLayer.childrenOf(node) : (Iterable)JBIterable.empty();
    }

    private static final Iterable renameDsGroup$lambda$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }
}

