/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbGenNameModelState;
import com.intellij.database.schemaEditor.ui.DbAdvancedTextEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.ExtensionsHolder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ui.JBUI;
import icons.DatabaseIcons;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;

public class DbGenNameEditor<E extends BasicElement, S extends DbGenNameModelState>
extends DbAdvancedTextEditor<E, S> {
    private boolean myGenerated;

    public DbGenNameEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        if (controller == null) {
            DbGenNameEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbGenNameEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myEditor.addSettingsProvider(editor2 -> ExtensionsHolder.Companion.setupExtensionComponent(editor2, this.createAutoGenerateExtension()));
        this.myEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DbGenNameEditor.this.isApplying()) {
                    DbGenNameEditor.this.setGenerated(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/schemaEditor/ui/DbGenNameEditor$1", "documentChanged"));
            }
        });
    }

    @NotNull
    private JComponent createAutoGenerateExtension() {
        ToggleAutoGeneratedAction autoGenerated = new ToggleAutoGeneratedAction(){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return DbGenNameEditor.this.myGenerated;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbGenNameEditor.this.setGenerated(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbGenNameEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return DbGenNameEditor.createToolbarExtension((JComponent)this.myEditor, (ActionGroup)new DefaultActionGroup(new AnAction[]{autoGenerated}));
    }

    @NotNull
    public static JComponent createToolbarExtension(JComponent target, ActionGroup group) {
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("NavBarToolbar", group, true);
        tb.setTargetComponent(target);
        tb.setReservePlaceAutoPopupIcon(false);
        tb.setMinimumButtonSize((Dimension)JBUI.size((int)16, (int)16));
        final JComponent component = tb.getComponent();
        component.setBorder((Border)JBUI.Borders.empty());
        component.setOpaque(false);
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                component.invalidate();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                component.invalidate();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                component.invalidate();
            }
        });
        JComponent jComponent = component;
        if (jComponent == null) {
            DbGenNameEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private void setGenerated(boolean generated) {
        this.myGenerated = generated;
        this.modified();
    }

    @Override
    protected void applyImpl() {
        super.applyImpl();
        ((DbGenNameModelState)this.getState()).setGenerated(this.myGenerated);
    }

    @Override
    protected void resetImpl() {
        super.resetImpl();
        this.myGenerated = ((DbGenNameModelState)this.getState()).isGenerated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/ui/DbGenNameEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/ui/DbGenNameEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static abstract class ToggleAutoGeneratedAction
    extends ToggleAction {
        public ToggleAutoGeneratedAction() {
            super(DatabaseBundle.message((String)"action.auto.generate.text", (Object[])new Object[0]), null, DatabaseIcons.TextAutoGenerate);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleAutoGeneratedAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/ui/DbGenNameEditor$ToggleAutoGeneratedAction", "getActionUpdateThread"));
        }
    }
}

