/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model.state;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelBase;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbStructureFamilyModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureModelApplier;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureNodeState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditorUtilsKt;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbStructureModelState
extends DbEditorModelBase.StateBase {
    public static final BasicMetaId ID = BasicMetaId.create((String)"DbStructureModelState");
    private final DbModelRef<?, ?> myRootRef;
    private final List<Object> myRoots;

    public DbStructureModelState(@NotNull DbModelRef<?, ?> rootRef) {
        if (rootRef == null) {
            DbStructureModelState.$$$reportNull$$$0(0);
        }
        this.myRoots = new ArrayList<Object>();
        this.myRootRef = rootRef;
    }

    @NotNull
    public List<?> getRoots() {
        List<Object> list = this.myRoots;
        if (list == null) {
            DbStructureModelState.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean register(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbStructureModelState.$$$reportNull$$$0(2);
        }
        if (!super.register(model)) {
            return false;
        }
        this.myRootRef.register(model.getController());
        this.appendRoots(model.castState(this));
        return true;
    }

    private <E extends BasicElement> void appendRoots(@NotNull DbEditorModel<E, DbStructureModelState> model) {
        DbStructureModelApplier applier;
        if (model == null) {
            DbStructureModelState.$$$reportNull$$$0(3);
        }
        if ((applier = (DbStructureModelApplier)ObjectUtils.tryCast(model.getApplier(), DbStructureModelApplier.class)) == null) {
            return;
        }
        DbEditorModelController controller = model.getController();
        for (DbModelRef<?, ?> m : controller.getAllModelsRefs()) {
            applier.addRoot(model, m);
        }
    }

    @Override
    public boolean unregister(@NotNull DbEditorModel<?, ?> model) {
        if (model == null) {
            DbStructureModelState.$$$reportNull$$$0(4);
        }
        if (!super.unregister(model)) {
            return false;
        }
        this.setRoots(Collections.emptyList());
        this.myRootRef.unregister(model.getController());
        return true;
    }

    public void removeRoot(@NotNull DbModelRef<?, ? extends DbStructureNodeState> root) {
        if (root == null) {
            DbStructureModelState.$$$reportNull$$$0(5);
        }
        this.setRoots(Group.mapWithGroups(this.getRoots(), DbModelRef.class, r -> r.equals(root) ? null : r));
    }

    public void addRoot(@NotNull DbModelRef<?, ? extends DbStructureNodeState> root, @Nullable String group) {
        if (root == null) {
            DbStructureModelState.$$$reportNull$$$0(6);
        }
        ArrayList<Object> roots = new ArrayList<Object>(this.getRoots());
        if (group == null) {
            DbStructureModelState.addToRoots(roots, root);
        } else {
            int idx = ContainerUtil.indexOf(roots, r -> {
                if (!(r instanceof Group)) return false;
                Group g = (Group)r;
                if (!g.name.equals(group)) return false;
                return true;
            });
            ArrayList<Object> children2 = new ArrayList<Object>();
            if (idx != -1) {
                children2.addAll(((Group)roots.get((int)idx)).children);
            }
            DbStructureModelState.addToRoots(children2, root);
            Group<Object> ng = new Group<Object>(group, children2);
            if (idx != -1) {
                roots.set(idx, ng);
            } else {
                DbStructureModelState.addToRoots(roots, ng);
            }
        }
        this.setRoots(roots);
    }

    private static void addToRoots(List<Object> roots, Object rt) {
        int insIdx = Collections.binarySearch(roots, rt, DbStructureModelState::compareRoots);
        roots.add(insIdx >= 0 ? insIdx : -insIdx - 1, rt);
    }

    private void setRoots(@NotNull List<?> roots) {
        if (roots == null) {
            DbStructureModelState.$$$reportNull$$$0(7);
        }
        if (this.myRoots.equals(roots)) {
            return;
        }
        this.myRoots.clear();
        this.myRoots.addAll(roots);
        this.modified();
    }

    public boolean isUnderRoots(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(8);
        }
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(9);
        }
        return DbStructureModelState.hasAncestor(controller, this.myRoots, modelRef, false);
    }

    private static boolean hasAncestor(@NotNull DbEditorModelController controller, @NotNull List<?> ancestors, @NotNull DbModelRef<?, ? extends DbStructureNodeState> child, boolean strict) {
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(10);
        }
        if (ancestors == null) {
            DbStructureModelState.$$$reportNull$$$0(11);
        }
        if (child == null) {
            DbStructureModelState.$$$reportNull$$$0(12);
        }
        for (Object a : ancestors) {
            if (!(a instanceof Group ? DbStructureModelState.hasAncestor(controller, ((Group)a).children, child, strict) : DbStructureModelState.isAncestor(controller, (DbModelRef)a, child, strict))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAncestor(@NotNull DbEditorModelController controller, @NotNull DbModelRef<?, ? extends DbStructureNodeState> ancestor, @NotNull DbModelRef<?, ? extends DbStructureNodeState> child, boolean strict) {
        ElementIdentity childId;
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(13);
        }
        if (ancestor == null) {
            DbStructureModelState.$$$reportNull$$$0(14);
        }
        if (child == null) {
            DbStructureModelState.$$$reportNull$$$0(15);
        }
        if (ancestor.equals(child)) {
            return !strict;
        }
        ElementIdentity ancestorId = ancestor.getIdentity();
        if (ancestorId == (childId = child.getIdentity())) {
            return !(ancestor.getState() instanceof DbStructureFamilyModelState);
        }
        ElementIdentity<?> underId = DbEditorUtilsKt.getAncestorUnder(controller.getMatcher(), ancestorId, childId);
        if (underId == null) {
            return false;
        }
        DbStructureNodeState dbStructureNodeState = ancestor.getState();
        if (dbStructureNodeState instanceof DbStructureFamilyModelState) {
            DbStructureFamilyModelState fs = (DbStructureFamilyModelState)dbStructureNodeState;
            return fs.getMetaObject() == underId.getMetaObject();
        }
        return true;
    }

    public boolean isInRoots(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(16);
        }
        return this.isInRootsImpl(modelRef);
    }

    private boolean isInRootsImpl(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(17);
        }
        return this.myRoots.contains(modelRef) || this.getContainingGroup(modelRef) != null;
    }

    @Nullable
    public Group<DbModelRef<?, ? extends DbStructureNodeState>> getContainingGroup(@NotNull DbModelRef<?, ? extends DbStructureNodeState> modelRef) {
        if (modelRef == null) {
            DbStructureModelState.$$$reportNull$$$0(18);
        }
        for (Object root : this.myRoots) {
            if (!(root instanceof Group)) continue;
            Group g = (Group)root;
            if (!g.children.contains(modelRef)) continue;
            return g;
        }
        return null;
    }

    @Nullable
    public Group<DbModelRef<?, ? extends DbStructureNodeState>> findGroup(@NotNull String name2) {
        if (name2 == null) {
            DbStructureModelState.$$$reportNull$$$0(19);
        }
        return (Group)JBIterable.from(this.getRoots()).filter(Group.class).find(g -> g.name.equals(name2));
    }

    @Nullable
    public static <E extends BasicElement, S extends DbStructureNodeState<?, ?>> DbModelRef<?, ? extends DbStructureNodeState<?, ?>> getParentModel(@NotNull DbEditorModelController controller, @Nullable DbModelRef<E, S> mm) {
        DbModelRef<E, DbStructureNodeState<E, E>> res2;
        if (controller == null) {
            DbStructureModelState.$$$reportNull$$$0(20);
        }
        if ((res2 = DbStructureFamilyModelState.getParentStructureNode(controller, mm)) != null && controller.getBuilder().isHideFromStructure(res2)) {
            return DbStructureModelState.getParentModel(controller, res2);
        }
        return res2;
    }

    private static int compareObjects(DbModelRef<?, ?> o1, DbModelRef<?, ?> o2) {
        int n;
        ElementIdentity id1 = o1.getIdentity();
        ElementIdentity id2 = o2.getIdentity();
        if (id1 instanceof Comparable) {
            Comparable c2 = (Comparable)id1;
            n = c2.compareTo(id2);
        } else {
            n = 0;
        }
        return n;
    }

    private static int compareFamilies(DbStructureFamilyModelApplier<?, ?> f1, DbStructureFamilyModelApplier<?, ?> f2) {
        return Integer.compare(f1.getWeight(), f2.getWeight());
    }

    private static int compareGroups(Group<?> g1, Group<?> g2) {
        return Comparing.compare((Comparable)((Object)g1.name), (Comparable)((Object)g2.name));
    }

    private static int compareRoots(Object o1, Object o2) {
        DbStructureObjectModelState os2;
        Group g1 = (Group)ObjectUtils.tryCast((Object)o1, Group.class);
        Group g2 = (Group)ObjectUtils.tryCast((Object)o2, Group.class);
        DbModelRef m1 = (DbModelRef)ObjectUtils.tryCast((Object)o1, DbModelRef.class);
        DbModelRef m2 = (DbModelRef)ObjectUtils.tryCast((Object)o2, DbModelRef.class);
        DbStructureFamilyModelApplier f1 = m1 == null ? null : (DbStructureFamilyModelApplier)ObjectUtils.tryCast(m1.getApplier(), DbStructureFamilyModelApplier.class);
        DbStructureFamilyModelApplier f2 = m2 == null ? null : (DbStructureFamilyModelApplier)ObjectUtils.tryCast(m2.getApplier(), DbStructureFamilyModelApplier.class);
        DbStructureObjectModelState os1 = m1 == null ? null : (DbStructureObjectModelState)ObjectUtils.tryCast(m1.getState(), DbStructureObjectModelState.class);
        DbStructureObjectModelState dbStructureObjectModelState = os2 = m2 == null ? null : (DbStructureObjectModelState)ObjectUtils.tryCast(m2.getState(), DbStructureObjectModelState.class);
        if (g1 != null && g2 != null) {
            return DbStructureModelState.compareGroups(g1, g2);
        }
        if (f1 != null && f2 != null) {
            return DbStructureModelState.compareFamilies(f1, f2);
        }
        if (os1 != null && os2 != null) {
            return DbStructureModelState.compareObjects(m1, m2);
        }
        if (f1 != null) {
            return -1;
        }
        if (f2 != null) {
            return 1;
        }
        if (g1 != null) {
            return -1;
        }
        if (g2 != null) {
            return 1;
        }
        if (os1 != null) {
            return -1;
        }
        if (os2 != null) {
            return 1;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 9: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendRoots";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregister";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAncestor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInRoots";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInRootsImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContainingGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getParentModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Group<T> {
        public final String name;
        public final List<T> children;

        public Group(@NotNull String name2, @NotNull List<T> children2) {
            if (name2 == null) {
                Group.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                Group.$$$reportNull$$$0(1);
            }
            this.name = name2;
            this.children = children2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            Group group = (Group)o;
            return this.name.equals(group.name) && this.children.equals(group.children);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.children);
        }

        public static <T, U> List<Object> mapWithGroups(@NotNull List<?> l, final @NotNull Class<T> clazz, final @NotNull Function<T, U> m) {
            if (l == null) {
                Group.$$$reportNull$$$0(2);
            }
            if (clazz == null) {
                Group.$$$reportNull$$$0(3);
            }
            if (m == null) {
                Group.$$$reportNull$$$0(4);
            }
            return ContainerUtil.mapNotNull(l, (Function)new Function<Object, Object>(){

                public Object fun(Object o) {
                    Object t = ObjectUtils.tryCast((Object)o, (Class)clazz);
                    if (t != null) {
                        return m.fun(t);
                    }
                    Group g = (Group)o;
                    List newChildren = ContainerUtil.mapNotNull(g.children, (Function)this);
                    if (newChildren.isEmpty()) {
                        return null;
                    }
                    return new Group(g.name, newChildren);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/schemaEditor/model/state/DbStructureModelState$Group";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mapWithGroups";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

