/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dbimport.editor.data.DetectedColumnsData;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbCollectionModelState;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbTableCollectionEditor;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.TableView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ImmutableColumnInfo;
import com.intellij.util.ui.TableViewModel;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCsvColumnsEditor<E extends BasicElement>
extends DbTableCollectionEditor<E, DetectedColumnsData.Column> {
    public DbCsvColumnsEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, DbCollectionModelState<DetectedColumnsData.Column>> model) {
        if (controller == null) {
            DbCsvColumnsEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbCsvColumnsEditor.$$$reportNull$$$0(1);
        }
        super(controller, model, false);
        this.myTable.setShowGrid(false);
    }

    @Override
    @Nullable
    protected ActionGroup createContextMenu() {
        return new DefaultActionGroup(new AnAction[]{new SimplifyName()});
    }

    @Override
    @Nullable
    public String getTitle() {
        return null;
    }

    @Override
    protected JBIterable<ColumnInfo<DetectedColumnsData.Column, ?>> createColumns() {
        return JBIterable.of((Object[])new ColumnInfo[]{new ColumnNameInfo(), new ImmutableColumnInfo<DetectedColumnsData.Column, String>(DatabaseBundle.message((String)"property.Type.title", (Object[])new Object[0])){

            public String valueOf(DetectedColumnsData.Column value) {
                return value.getType();
            }

            public boolean isCellEditable(DetectedColumnsData.Column value) {
                return true;
            }

            public TableCellRenderer getRenderer(DetectedColumnsData.Column value) {
                return new ColoredTableCellRenderer(){

                    protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column2) {
                        if (table == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.append(value == null ? "" : value.toString(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor$1$1", "customizeCellRenderer"));
                    }
                };
            }

            public TableCellEditor getEditor(DetectedColumnsData.Column value) {
                return new DefaultCellEditor(new JTextField());
            }

            public DetectedColumnsData.Column withValue(DetectedColumnsData.Column item, String value) {
                return new DetectedColumnsData.Column(item.getId(), item.getSrcName(), item.getRename(), value);
            }
        }});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "controller";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SimplifyName
    extends DumbAwareAction {
        public SimplifyName() {
            super(DatabaseBundle.message((String)"action.simplify.column.name.text", (Object[])new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                SimplifyName.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifyName.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(SimplifyName.isEnabled(SimplifyName.getTable(e)));
        }

        private static <T> boolean isEnabled(TableView<T> table) {
            ImmutableColumnInfo sc = SimplifyName.findSimplifiableColumn(table);
            return sc != null && table.getSelectedRowCount() > 0 && ContainerUtil.or((Iterable)table.getSelectedObjects(), o -> sc.isCellEditable(o));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifyName.$$$reportNull$$$0(2);
            }
            SimplifyName.simplify(SimplifyName.getTable(e));
        }

        private static <T> void simplify(TableView<T> table) {
            ImmutableColumnInfo<T, String> column2 = SimplifyName.findSimplifiableColumn(table);
            if (column2 == null) {
                return;
            }
            IntOpenHashSet selection = new IntOpenHashSet(table.getSelectedRows());
            TableViewModel model = table.getTableViewModel();
            ArrayList items = new ArrayList(model.getItems());
            ListIterator<Object> it = items.listIterator();
            while (it.hasNext()) {
                String name2;
                Object item = it.next();
                if (!selection.contains(it.previousIndex()) || !column2.isCellEditable(item) || (name2 = (String)column2.valueOf(item)) == null) continue;
                it.set(column2.withValue(item, (Object)DbImplUtil.simplify(name2)));
            }
            model.setItems(items);
        }

        @Nullable
        private static <T> ImmutableColumnInfo<T, String> findSimplifiableColumn(@Nullable TableView<T> table) {
            ColumnInfo[] infos;
            if (table == null) {
                return null;
            }
            for (ColumnInfo info2 : infos = table.getTableViewModel().getColumnInfos()) {
                if (!(info2 instanceof SimplifiableMarker) || !(info2 instanceof ImmutableColumnInfo)) continue;
                ImmutableColumnInfo ici = (ImmutableColumnInfo)info2;
                return ici;
            }
            return null;
        }

        @Nullable
        private static TableView<?> getTable(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifyName.$$$reportNull$$$0(3);
            }
            return (TableView)ObjectUtils.tryCast((Object)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT), TableView.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor$SimplifyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor$SimplifyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }

        public static interface SimplifiableMarker {
        }
    }

    private static class ColumnNameInfo
    extends ImmutableColumnInfo<DetectedColumnsData.Column, String>
    implements SimplifyName.SimplifiableMarker {
        private ColumnNameInfo() {
            super(DatabaseBundle.message((String)"column.name.column", (Object[])new Object[0]));
        }

        public String valueOf(DetectedColumnsData.Column value) {
            return value.getName();
        }

        public DetectedColumnsData.Column withValue(DetectedColumnsData.Column column2, String value) {
            if (Objects.equals(column2.getName(), value)) {
                return column2;
            }
            String rename = Objects.equals(column2.getSrcName(), value) ? null : value;
            return column2.copy(column2.getId(), column2.getSrcName(), rename, column2.getType());
        }

        public TableCellRenderer getRenderer(DetectedColumnsData.Column column2) {
            final String srcName = column2 == null ? "" : column2.getSrcName();
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column2) {
                    String strVal;
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String string = strVal = value == null ? "" : value.toString();
                    if (srcName.isEmpty() || srcName.equals(value)) {
                        this.append(strVal);
                    } else {
                        this.append(strVal);
                        this.append(" (" + srcName + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/editor/editor/DbCsvColumnsEditor$ColumnNameInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public boolean isCellEditable(DetectedColumnsData.Column value) {
            return true;
        }

        public TableCellEditor getEditor(DetectedColumnsData.Column column2) {
            return new DefaultCellEditor(new JTextField());
        }
    }
}

